/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.markdown;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclnt.jsfserver.util.CCServletBase;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;
import org.eclnt.jsfserver.util.markdown.MarkdownTextConverter;

public class MarkdownServlet
extends CCServletBase {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            resp.setCharacterEncoding("UTF-8");
            String resource = ServletUtil.isolateResourcePath(req);
            int dirLevel = this.countDirLevel(resource);
            resource = ServletUtil.updateResource(req, resource);
            resource = resource.replace(".ccmd", ".md");
            String mdText = WebResourceClassloaderReader.readUTF8File(resource);
            String html = MarkdownTextConverter.instance().convertMarkdownToHtml(mdText, dirLevel);
            resp.getWriter().write(html);
        }
        catch (Throwable t) {
            throw new Error("Problem processing markdown on " + req.getRequestURL());
        }
    }

    private int countDirLevel(String resource) {
        int counter = 0;
        int index = 0;
        while ((index = resource.indexOf(47, index)) >= 0) {
            ++index;
            ++counter;
        }
        return counter;
    }
}

