/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.tool;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclnt.jsfserver.util.webappfiles.WebappDirectoryXML;
import org.eclnt.util.file.CLDirectoryInfo;
import org.eclnt.util.file.CLFileInfo;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class BuildWebAppFilesXml {
    List<String> m_includes = new ArrayList<String>();
    List<String> m_excludes = new ArrayList<String>();
    List<String> m_extensions = new ArrayList<String>();

    public BuildWebAppFilesXml() {
        this.m_excludes.add(".git");
        this.m_excludes.add(".svn");
        this.m_extensions.add(".xml");
        this.addInclude("eclnt/risc/i18n/");
        this.addInclude("eclntjsfserver/config/");
        this.addInclude("eclntjsfserver/keyvariants/");
        this.addInclude("eclntjsfserver/styles/");
    }

    public static void main(String[] args) {
        if (args == null || args.length != 2) {
            throw new Error("Wrong number of arguments: " + args.length + ".\nParam1: Name of root directory to scan and to create file\nParam2: Name of directory where to write the file " + "/eclntdirectoryinfo.xml" + "\n");
        }
        String root = args[0];
        String target = args[1];
        new BuildWebAppFilesXml().buildWebAppDirectoryXML(root, target, true);
    }

    public void addInclude(String dirName) {
        this.m_includes.add(dirName);
    }

    public void addExclude(String exclude) {
        this.m_excludes.add(exclude);
    }

    public void clearAllIncludes() {
        this.m_includes.clear();
    }

    public void clearAllExcludes() {
        this.m_excludes.clear();
    }

    public void clearAllExtensions() {
        this.m_extensions.clear();
    }

    public CLDirectoryInfo buildWebAppDirectory(String rootFileName) {
        rootFileName = ValueManager.encodeIntoValidFileName(rootFileName, true);
        CLDirectoryInfo rootDir = new CLDirectoryInfo();
        rootDir.setName("");
        this.addContent(rootDir, "", rootFileName, "");
        rootDir.removeEmptyDirectories();
        return rootDir;
    }

    public String buildWebAppDirectoryXML(String rootDirName, String targetDirName, boolean createFile) {
        rootDirName = ValueManager.convertFileNameToCanonical(rootDirName, true);
        targetDirName = ValueManager.convertFileNameToCanonical(targetDirName, true);
        if (!FileManager.checkIfFileExists(rootDirName)) {
            throw new Error("Directory does not exist: " + rootDirName);
        }
        CLDirectoryInfo di = this.buildWebAppDirectory(rootDirName);
        String result = WebappDirectoryXML.toXML(di);
        if (createFile) {
            String targetFileName = targetDirName + "/eclntdirectoryinfo.xml";
            System.out.println("Writing result into: " + targetFileName);
            FileManager.writeUTF8File(targetFileName, result, true);
        }
        return result;
    }

    private void addContent(CLDirectoryInfo waDir, String dirName, String absDirFileName, String relDirFileName) {
        List<File> subDirs = FileManager.getDirectoriesOfDirectory(absDirFileName);
        for (File subDir : subDirs) {
            String subDirRelFileName = relDirFileName + subDir.getName() + "/";
            if (!this.checkIfRelFileNameMatchesFilter(subDirRelFileName, false)) continue;
            CLDirectoryInfo subWADir = new CLDirectoryInfo();
            subWADir.setName(subDir.getName());
            waDir.getDirectories().add(subWADir);
            this.addContent(subWADir, subDir.getName(), absDirFileName + subDir.getName() + "/", relDirFileName + subDir.getName() + "/");
        }
        if (this.checkIfRelFileNameMatchesFilter(relDirFileName, false)) {
            List<File> subFiles = FileManager.getFilesOfDirectory(absDirFileName);
            for (File subFile : subFiles) {
                String relFileName = relDirFileName + subFile.getName();
                if (!this.checkIfRelFileNameMatchesFilter(relFileName, true)) continue;
                CLFileInfo waFile = new CLFileInfo();
                waFile.setName(subFile.getName());
                waDir.getFiles().add(waFile);
            }
        }
    }

    private boolean checkIfRelFileNameMatchesFilter(String relFileName, boolean isFile) {
        boolean result = false;
        for (String exclude : this.m_excludes) {
            if (!relFileName.contains(exclude)) continue;
            return false;
        }
        if (this.m_includes.size() > 0) {
            for (String filterDirName : this.m_includes) {
                if (!relFileName.startsWith(filterDirName) && !filterDirName.startsWith(relFileName)) continue;
                result = true;
                break;
            }
        } else {
            result = true;
        }
        if (result && isFile && this.m_extensions.size() > 0) {
            result = false;
            for (String extension : this.m_extensions) {
                if (!relFileName.endsWith(extension)) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

