/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.classresolver;

import java.util.Hashtable;
import org.eclnt.util.classloaderaccess.ClassLoaderAccess;
import org.eclnt.util.classresolver.ENUMCallerType;
import org.eclnt.util.classresolver.IClassResolver;
import org.eclnt.util.mitigation.CCMitigation;

public class DefaultClassResolver
implements IClassResolver {
    static final Class CLASS_NULL = DummyClass.class;
    ClassLoader m_lastCurrentClassLoader = null;
    Hashtable<String, Class> m_loadedClasses = new Hashtable();
    Hashtable<String, Integer> m_referredClassloader = new Hashtable();

    @Override
    public Class resolveClass(String className, boolean initialize, ClassLoader classLoader, ENUMCallerType callerType) throws ClassNotFoundException {
        this.approveLoadingOfClassIsCorrect(className, callerType);
        Class result = this.executeBufferedClassForName(className, initialize, classLoader);
        return result;
    }

    @Override
    @CCMitigation(cweIds={"470"}, comment="The loading of classes is controlled by interface IClassResolver. As part of this interface each class that is loaded within the CaptainCasa processing declares why it is loaded (ENUMCallerType-parameter). You can apply any own implementation which checks every load process to decide if a class should be loaded or not.")
    public Class resolveClass(String className, ENUMCallerType callerType) throws ClassNotFoundException {
        this.approveLoadingOfClassIsCorrect(className, callerType);
        Class result = this.executeBufferedClassForName(className, true, null);
        return result;
    }

    @Override
    public boolean checkIfClassIsAvailable(String className) {
        try {
            ClassLoader cl = ClassLoaderAccess.currentClassLoader();
            Class<?> result = Class.forName(className, false, cl);
            if (result != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected void approveLoadingOfClassIsCorrect(String className, ENUMCallerType callerType) {
    }

    @CCMitigation(cweIds={"470"}, comment="The loading of classes is controlled by interface IClassResolver. As part of this interface each class that is loaded within the CaptainCasa processing declares why it is loaded (ENUMCallerType-parameter). You can apply any own implementation which checks every load process to decide if a class should be loaded or not.")
    protected Class executeBufferedClassForName(String className, boolean initialize, ClassLoader classLoader) throws ClassNotFoundException {
        Class c;
        Integer cloaderId;
        ClassLoader current = ClassLoaderAccess.currentClassLoader();
        if (classLoader == null) {
            classLoader = current;
        }
        if (this.m_lastCurrentClassLoader != current) {
            Hashtable<String, Class> oldMap = this.m_loadedClasses;
            this.m_lastCurrentClassLoader = current;
            this.m_loadedClasses = new Hashtable();
            oldMap.clear();
        }
        if ((cloaderId = this.m_referredClassloader.get(className)) != null && cloaderId.equals(System.identityHashCode(classLoader))) {
            c = this.m_loadedClasses.get(className);
            if (c == CLASS_NULL) {
                throw new ClassNotFoundException(className);
            }
            if (c != null) {
                return c;
            }
        }
        try {
            c = Class.forName(className, initialize, classLoader);
            this.m_loadedClasses.put(className, c);
            this.m_referredClassloader.put(className, System.identityHashCode(classLoader));
            return c;
        }
        catch (ClassNotFoundException e) {
            this.m_loadedClasses.put(className, CLASS_NULL);
            throw e;
        }
    }

    static class DummyClass {
        DummyClass() {
        }
    }
}

