/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.file;

import com.veracode.annotation.FilePathCleanser;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import org.eclnt.util.classloaderaccess.ClassLoaderAccess;
import org.eclnt.util.file.CLDirectoryInfo;
import org.eclnt.util.file.CLFileInfo;
import org.eclnt.util.file.impl.ClassLoaderReaderInfoProviderUtilImpl;
import org.eclnt.util.log.ULog;
import org.eclnt.util.valuemgmt.ValueManager;

public class ClassloaderReader {
    static IInfoProvider s_infoProvider = new ClassLoaderReaderInfoProviderUtilImpl();
    static Map<String, Boolean> s_bufferCheckIfFileExists = new Hashtable<String, Boolean>();
    Map<String, ImageIcon> s_images = new HashMap<String, ImageIcon>();
    ClassLoader m_classLoader = null;
    CLDirectoryInfo m_directoryInfo = null;

    public ClassloaderReader() {
        this.m_classLoader = this.getClass().getClassLoader();
    }

    public ClassloaderReader(boolean useHotDeploymentClassLoader) {
        this.m_classLoader = useHotDeploymentClassLoader ? ClassLoaderAccess.currentClassLoader() : this.getClass().getClassLoader();
    }

    public ClassloaderReader(ClassLoader classLoader) {
        this.m_classLoader = classLoader;
    }

    public static void initializeInfoProvider(IInfoProvider infoProvider) {
        s_infoProvider = infoProvider;
    }

    public ImageIcon readImage(String fileName, boolean error) {
        ImageIcon result = this.s_images.get(fileName = this.rightSizeResourceName(fileName));
        if (result == null) {
            byte[] bytes = this.readFile(fileName, error);
            result = new ImageIcon(bytes);
            this.s_images.put(fileName, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Integer readFirstByteOfFile(String fileName) {
        Integer n;
        InputStream in = null;
        try {
            fileName = this.rightSizeResourceName(fileName);
            ULog.logINF("Reading first byte of file " + fileName);
            in = this.getResourceAsStream(fileName);
            int result = in.read();
            in.close();
            n = result;
            if (in == null) return n;
        }
        catch (Throwable t) {
            try {
                Integer n2 = null;
                return n2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        try {
            in.close();
            return n;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
    }

    public byte[] readFile(String fileName, boolean error) {
        try {
            fileName = this.rightSizeResourceName(fileName);
            ULog.logINF("Reading file " + fileName);
            byte[] result = this.readFileExecute(fileName, error);
            if (result != null) {
                return result;
            }
            throw new Error("next try");
        }
        catch (Throwable t) {
            ULog.logINF("Reading file /" + fileName);
            byte[] result = this.readFileExecute("/" + fileName, error);
            return result;
        }
    }

    public List<URL> readResourcePaths(String fileName, boolean error) {
        ArrayList<URL> result = new ArrayList<URL>();
        try {
            fileName = this.rightSizeResourceName(fileName);
            Enumeration<URL> resources = this.m_classLoader.getResources(fileName);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                result.add(resource);
            }
        }
        catch (Throwable t) {
            if (error) {
                throw new Error("Problem reading resource paths for fileName: " + fileName, t);
            }
            result.clear();
        }
        return result;
    }

    public List<String> readUTF8Files(String fileName, boolean error) {
        ULog.logINF("Multi-reading via class loader: " + fileName);
        ArrayList<String> result = new ArrayList<String>();
        try {
            fileName = this.rightSizeResourceName(fileName);
            Enumeration<URL> resources = this.m_classLoader.getResources(fileName);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                ULog.logINF("Multi-reading via class loader: > " + resource.toString());
                byte[] bytes = this.readURLContent(resource, true);
                String s = new String(bytes, ValueManager.CHARSET_UTF8);
                result.add(s);
            }
        }
        catch (Throwable t) {
            if (error) {
                throw new Error("Problem reading UTF8 files for fileName: " + fileName, t);
            }
            result.clear();
        }
        return result;
    }

    public List<String> readUTF8FilesWithVariants(String fileName) {
        List<String> fileNames = this.buildFileNameVariants(fileName);
        ArrayList<String> result = new ArrayList<String>();
        for (String fileNameVariant : fileNames) {
            try {
                result.addAll(this.readUTF8Files(fileNameVariant, false));
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    private List<String> buildFileNameVariants(String fileName) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(fileName);
        int lastDotIndex = fileName.lastIndexOf(46);
        int lastSlashIndex = fileName.lastIndexOf(47);
        if (lastDotIndex > 0 && lastDotIndex > lastSlashIndex) {
            for (int i = 0; i < 10; ++i) {
                result.add(fileName.substring(0, lastDotIndex) + ".variant_" + i + fileName.substring(lastDotIndex));
            }
        } else {
            for (int i = 0; i < 10; ++i) {
                result.add(fileName + ".variant_" + i);
            }
        }
        return result;
    }

    public List<byte[]> readFiles(String fileName, boolean error) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        try {
            fileName = this.rightSizeResourceName(fileName);
            Enumeration<URL> resources = this.m_classLoader.getResources(fileName);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                byte[] bytes = this.readURLContent(resource, true);
                result.add(bytes);
            }
        }
        catch (Throwable t) {
            if (error) {
                throw new Error("Problem when reading files for: " + fileName, t);
            }
            return new ArrayList<byte[]>();
        }
        return result;
    }

    public String readURLContentAsUTF8(URL url, boolean withError) {
        try {
            byte[] content = this.readURLContent(url, true);
            String result = new String(content, ValueManager.CHARSET_UTF8);
            return result;
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Problem reading URLContent as UTF8: " + url, t);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] readURLContent(URL url, boolean withError) {
        byte[] byArray;
        InputStream is = null;
        try {
            is = url.openStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while (true) {
                int i;
                if ((i = is.read()) < 0) {
                    bos.close();
                    byArray = bos.toByteArray();
                    break;
                }
                bos.write(i);
            }
        }
        catch (Throwable t) {
            try {
                if (withError) {
                    throw new Error("Problem reading content of URL: " + url, t);
                }
                byte[] byArray2 = null;
                return byArray2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
        try {
            is.close();
            return byArray;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return byArray;
    }

    public String readUTF8File(String fileName, boolean withError) {
        try {
            fileName = this.rightSizeResourceName(fileName);
            ULog.logINF("Reading UTF8 file " + fileName);
            byte[] content = this.readFile(fileName, withError);
            return new String(content, ValueManager.CHARSET_UTF8);
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Could not read " + fileName, t);
            }
            return null;
        }
    }

    public InputStream readFileIntoInputStream(String fileName, boolean error) {
        try {
            fileName = this.rightSizeResourceName(fileName);
            InputStream in = this.getResourceAsStream(ValueManager.approveFileName(fileName));
            if (in == null) {
                throw new Exception("InputStream returned as null");
            }
            return in;
        }
        catch (Throwable t) {
            if (error) {
                throw new Error(t);
            }
            return null;
        }
    }

    public Set<String> getFilesInPathDirectory(String path) {
        if (this.m_directoryInfo == null) {
            this.m_directoryInfo = s_infoProvider.readDirectoryInfo(this.m_classLoader);
        }
        if (this.m_directoryInfo == null) {
            throw new Error("Directory info for class loader is not provided");
        }
        CLDirectoryInfo di = this.m_directoryInfo.findDirectory(path);
        List<CLFileInfo> fis = di.getFiles();
        HashSet<String> result = new HashSet<String>();
        for (CLFileInfo fi : fis) {
            result.add(fi.getName());
        }
        return result;
    }

    public Set<String> getDirectories(String path) {
        if (this.m_directoryInfo == null) {
            this.m_directoryInfo = s_infoProvider.readDirectoryInfo(this.m_classLoader);
        }
        if (this.m_directoryInfo == null) {
            throw new Error("Directory info for class loader is not provided");
        }
        CLDirectoryInfo di = this.m_directoryInfo.findDirectory(path);
        List<CLDirectoryInfo> fis = di.getDirectories();
        HashSet<String> result = new HashSet<String>();
        for (CLDirectoryInfo fi : fis) {
            result.add(fi.getName());
        }
        return result;
    }

    public String rightSizeResourceName(String fileName) {
        fileName = ValueManager.encodeIntoValidClassLoaderPath(fileName, false);
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readFileExecute(String fileName, boolean error) {
        byte[] maxn2222;
        InputStream in;
        block23: {
            in = null;
            ByteArrayOutputStream bos = null;
            try {
                in = this.getResourceAsStream(ValueManager.approveFileName(fileName));
                bos = new ByteArrayOutputStream();
                while (true) {
                    int maxn2222;
                    byte[] portion;
                    int n;
                    if ((n = in.read(portion = new byte[maxn2222 = 1000])) == maxn2222) {
                        bos.write(portion);
                        continue;
                    }
                    if (n < 0) {
                        maxn2222 = bos.toByteArray();
                        if (bos == null) break block23;
                        break;
                    }
                    bos.write(portion, 0, n);
                }
            }
            catch (Throwable t) {
                try {
                    if (error) {
                        throw new Error(t);
                    }
                    byte[] byArray = null;
                    return byArray;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            try {
                bos.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (in == null) return maxn2222;
        try {
            in.close();
            return maxn2222;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return maxn2222;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkIfFileExists(String fileName) {
        Boolean result = s_bufferCheckIfFileExists.get(fileName);
        if (result == null) {
            Map<String, Boolean> map = s_bufferCheckIfFileExists;
            synchronized (map) {
                result = s_bufferCheckIfFileExists.get(fileName);
                if (result == null) {
                    Integer firstByte = this.readFirstByteOfFile(fileName);
                    result = firstByte == null ? Boolean.valueOf(false) : Boolean.valueOf(true);
                    s_bufferCheckIfFileExists.put(fileName, result);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetBuffers() {
        Map<String, Boolean> map = s_bufferCheckIfFileExists;
        synchronized (map) {
            s_bufferCheckIfFileExists.clear();
        }
    }

    @FilePathCleanser(userComment="Generic method for accessing files from the classloader. Calling functions need to ensure that proper content is passed.")
    private InputStream getResourceAsStream(String fileName) {
        return this.m_classLoader.getResourceAsStream(ValueManager.approveFileName(fileName));
    }

    public static interface IInfoProvider {
        public CLDirectoryInfo readDirectoryInfo(ClassLoader var1);
    }
}

