/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace.wfinbox;

import java.io.Serializable;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.ModalPopup;
import org.eclnt.jsfserver.defaultscreens.ModelessPopup;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.defaultscreens.YESNOPopup;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDListBinding;
import org.eclnt.jsfserver.elements.util.DefaultModalPopupListener;
import org.eclnt.util.log.CLog;
import org.eclnt.workplace.IWorkpageContainer;
import org.eclnt.workplace.IWorkpageDispatcher;
import org.eclnt.workplace.WorkpageDispatchedPageBean;
import org.eclnt.workplace.WorkpageStartInfo;
import org.eclnt.workplace.WorkpageStarterFactory;
import org.eclnt.workplace.wfinbox.WFDelegateUI;
import org.eclnt.workplace.wfinbox.WFDummyManager;
import org.eclnt.workplace.wfinbox.WFItemTraceUI;
import org.eclnt.workplace.wfinbox.WFLongTextUI;
import org.eclnt.workplace.wfinbox.WFManagerFactory;
import org.eclnt.workplace.wfinbox.WorkItem;
import org.eclnt.workplace.wfinbox.WorkItemDetail;
import org.eclnt.workplace.wfinbox.WorkItemPage;

public class WFItemDetailUI
extends WorkpageDispatchedPageBean
implements Serializable {
    WorkItem m_wi;
    WorkItemDetail m_wid;
    FIXGRIDListBinding<PagesItem> m_pages = new FIXGRIDListBinding();
    IListener m_listener;
    ModelessPopup m_longTextPopup;
    ModalPopup m_delegationPopup;
    ModelessPopup m_addCommentPopup;

    public WFItemDetailUI(IWorkpageDispatcher workpageDispatcher) {
        super(workpageDispatcher);
        this.prepare(WFDummyManager.createDummyWorkItemDetail());
    }

    public WFItemDetailUI(IWorkpageDispatcher workpageDispatcher, WorkItem item, IListener listener) {
        super(workpageDispatcher);
        WorkItemDetail det = WFManagerFactory.getInstance().readDetailForWorkItem(item);
        this.prepare(det);
        this.m_listener = listener;
    }

    @Override
    public String getPageName() {
        return "/eclntjsfserver/includes/wfitemdetail.jsp";
    }

    @Override
    public String getRootExpressionUsedInPage() {
        return "#{WFItemDetailUI}";
    }

    private void prepare(WorkItemDetail wid) {
        this.m_wid = wid;
        this.m_wi = wid.getWorkItem();
        this.m_pages.getItems().clear();
        for (WorkItemPage wip : this.m_wid.getPages()) {
            this.m_pages.getItems().add(new PagesItem(wip));
        }
    }

    public WorkItem getWi() {
        return this.m_wi;
    }

    public WorkItemDetail getWid() {
        return this.m_wid;
    }

    public FIXGRIDListBinding<PagesItem> getPages() {
        return this.m_pages;
    }

    public void onStatusFINISHED(ActionEvent event) {
        YESNOPopup.createInstance("Finishing Work Item", "Do you really want to finish this work items?", new YESNOPopup.IYesNoListener(){

            @Override
            public void reactOnYes() {
                WFItemDetailUI.this.switchStatus("FINISHED");
            }

            @Override
            public void reactOnNo() {
            }
        });
    }

    public void onStatusINWORK(ActionEvent event) {
        this.switchStatus("INWORK");
    }

    public void onStatusOPEN(ActionEvent event) {
        this.switchStatus("OPEN");
    }

    public void onDelegate(ActionEvent event) {
        WFDelegateUI dui = new WFDelegateUI(this.getOwningDispatcher(), this.m_wi, new WFDelegateUI.IListener(){

            @Override
            public void reactOnDelegate(String user, String comment) {
                WFItemDetailUI.this.m_delegationPopup.close();
                WFItemDetailUI.this.m_delegationPopup = null;
                WFItemDetailUI.this.delegate(user, comment);
            }

            @Override
            public void reactOnCancel() {
                WFItemDetailUI.this.m_delegationPopup.close();
                WFItemDetailUI.this.m_delegationPopup = null;
            }
        });
        this.m_delegationPopup = this.openModalPopup(dui, "Delegate Work Item", 400, 400, null);
        this.m_delegationPopup.setPopupListener(new DefaultModalPopupListener(this.m_delegationPopup));
        this.m_delegationPopup.setStartfromrootwindow(false);
    }

    public boolean getDescriptionAvailable() {
        return this.m_wi.getDescription() != null && this.m_wi.getDescription().length() != 0;
    }

    public void onShowItemDescription(ActionEvent event) {
        this.openLongText(this.m_wi.getDescription());
    }

    public void onAddComment(ActionEvent event) {
        WFItemTraceUI wui = new WFItemTraceUI(this.m_wid, new WFItemTraceUI.IListener(){

            @Override
            public void reactOnCommentAdded(String newComment) {
                if (WFItemDetailUI.this.m_addCommentPopup != null) {
                    WFItemDetailUI.this.m_addCommentPopup.close();
                }
                WFItemDetailUI.this.m_addCommentPopup = null;
            }
        });
        this.m_addCommentPopup = this.openModelessPopup(wui, "", 400, 500, new ModelessPopup.IModelessPopupListener(){

            @Override
            public void reactOnPopupClosedByUser() {
                if (WFItemDetailUI.this.m_addCommentPopup != null) {
                    WFItemDetailUI.this.m_addCommentPopup.close();
                }
                WFItemDetailUI.this.m_addCommentPopup = null;
            }
        });
        this.m_addCommentPopup.setCloseonclickoutside(true);
        this.m_addCommentPopup.setUndecorated(true);
    }

    private void delegate(String user, String comment) {
        try {
            WFManagerFactory.getInstance().delegate(this.m_wi, user, comment);
            if (this.m_listener != null) {
                this.m_listener.reactOnDataChanged();
            }
        }
        catch (Throwable t) {
            this.handleError(t);
        }
    }

    private void switchStatus(String newStatus) {
        try {
            WFManagerFactory.getInstance().switchStatus(this.m_wi, newStatus);
            if (this.m_listener != null) {
                this.m_listener.reactOnDataChanged();
            }
        }
        catch (Throwable t) {
            this.handleError(t);
        }
    }

    private void showPage(WorkItemPage wip) {
        try {
            WorkpageStartInfo wpsi = wip.getWorkpageStartInfo();
            IWorkpageDispatcher wpd = (IWorkpageDispatcher)this.getOwningDispatcher().getTopOwner();
            IWorkpageContainer wpc = wpd.getWorkpageContainer();
            WorkpageStarterFactory.getWorkpageStarter().startWorkpage(wpd, wpc, wpsi);
        }
        catch (Throwable t) {
            this.handleError(t);
        }
    }

    private void handleError(Throwable t) {
        CLog.L.log(CLog.LL_ERR, "", t);
        Statusbar.outputError("Error: " + t.toString());
    }

    public void openLongText(String html) {
        WFLongTextUI ltui = new WFLongTextUI(html);
        this.m_longTextPopup = this.openModelessPopup(ltui, "", 400, 300, new ModelessPopup.IModelessPopupListener(){

            @Override
            public void reactOnPopupClosedByUser() {
                WFItemDetailUI.this.m_longTextPopup.close();
                WFItemDetailUI.this.m_longTextPopup = null;
            }
        });
        this.m_longTextPopup.setUndecorated(true);
        this.m_longTextPopup.setCloseonclickoutside(true);
    }

    public class PagesItem
    extends FIXGRIDItem
    implements Serializable {
        WorkItemPage i_wip;

        public PagesItem(WorkItemPage wip) {
            this.i_wip = wip;
        }

        public WorkItemPage getWip() {
            return this.i_wip;
        }

        public void onShowPage(ActionEvent event) {
            WFItemDetailUI.this.showPage(this.i_wip);
        }

        public void onOpenLongText(ActionEvent event) {
            WFItemDetailUI.this.openLongText(this.i_wip.getDescription());
        }

        public boolean getLongTextAvailable() {
            return this.i_wip.getDescription() != null && this.i_wip.getDescription().length() > 0;
        }
    }

    public static interface IListener {
        public void reactOnDataChanged();
    }
}

