/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.HashSet;
import org.eclnt.util.file.DirectoryStampMgmt;
import org.eclnt.util.file.FileManager;
import org.junit.Assert;
import org.junit.Test;

public class TestDirectoryStampMgmt {
    @Test
    public void testTomcatDev() {
        try {
            String dir = "C:/bmu_jtc/tomcatdev/webapps/demos/WEB-INF/";
            long stamp1 = DirectoryStampMgmt.createStampForDirectory(dir);
            System.out.println(stamp1);
            System.out.println("Finished");
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error("t");
        }
    }

    @Test
    public void testPerformance() {
        try {
            long ts1 = System.currentTimeMillis();
            String dir = "C:/bmu_jtc/git/eclnt_demos/WebContent/";
            long stamp1 = DirectoryStampMgmt.createStampForDirectory(dir);
            long ts2 = System.currentTimeMillis();
            System.out.println(stamp1);
            System.out.println(ts2 - ts1 + " ms");
            System.out.println("Finished");
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error("t");
        }
    }

    @Test
    public void testChanges() {
        try {
            String dir = "C:/bmu_jtc/git/eclnt_demos/webcontentbuild/";
            long stamp1 = DirectoryStampMgmt.createStampForDirectory(dir);
            System.out.println(stamp1);
            String fileName = dir + "WEB-INF/classes/apphotel/logic/towns.txt";
            String s1 = FileManager.readUTF8File(fileName, true);
            String s2 = s1 + " ";
            FileManager.writeUTF8File(fileName, s2, true);
            long stamp2 = DirectoryStampMgmt.createStampForDirectory(dir);
            System.out.println(stamp2);
            FileManager.writeUTF8File(fileName, s1, true);
            long stamp3 = DirectoryStampMgmt.createStampForDirectory(dir);
            System.out.println(stamp3);
            long stamp4 = DirectoryStampMgmt.createStampForDirectory(dir);
            System.out.println(stamp4);
            Assert.assertNotEquals((long)stamp1, (long)stamp2);
            Assert.assertNotEquals((long)stamp2, (long)stamp3);
            Assert.assertEquals((long)stamp3, (long)stamp4);
            System.out.println("Finished");
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error("t");
        }
    }

    @Test
    public void testIgnore() {
        try {
            String dir = "C:/bmu_jtc/git/eclnt_demos/webcontentbuild/";
            String fileName1 = dir + "WEB-INF/classes/ZZZZHarry.txt";
            String fileName2 = dir + "WEB-INF/classes/HarryXXXXHarry.txt";
            FileManager.deleteFile(fileName1);
            FileManager.deleteFile(fileName2);
            HashSet<String> ignoreNames = new HashSet<String>();
            ignoreNames.add("ZZZZ*");
            ignoreNames.add("*XXXX*");
            long stamp1 = DirectoryStampMgmt.createStampForDirectory(dir, ignoreNames);
            long stamp3 = DirectoryStampMgmt.createStampForDirectory(dir);
            System.out.println(stamp1);
            System.out.println(stamp3);
            System.out.println("---- after adding files ----");
            FileManager.writeUTF8File(fileName1, "TEST", true);
            FileManager.writeUTF8File(fileName2, "TEST", true);
            long stamp2 = DirectoryStampMgmt.createStampForDirectory(dir, ignoreNames);
            long stamp4 = DirectoryStampMgmt.createStampForDirectory(dir);
            System.out.println(stamp2);
            System.out.println(stamp4);
            FileManager.deleteFile(fileName1);
            FileManager.deleteFile(fileName2);
            Assert.assertEquals((long)stamp1, (long)stamp2);
            Assert.assertNotEquals((long)stamp3, (long)stamp4);
            System.out.println("Finished");
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error("t");
        }
    }
}

