/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.beantesting;

import java.util.List;
import org.eclnt.jsfserver.beantesting.RequestSimlulation;
import org.eclnt.jsfserver.defaultscreens.DefaultScreens;
import org.eclnt.jsfserver.defaultscreens.IdAttributesSelection;
import org.eclnt.jsfserver.defaultscreens.IdTextSelection;
import org.eclnt.jsfserver.defaultscreens.ModalPopup;
import org.eclnt.jsfserver.defaultscreens.ModelessPopup;
import org.eclnt.jsfserver.defaultscreens.OKPopup;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.defaultscreens.YESNOPopup;
import org.eclnt.jsfserver.elements.BaseActionEvent;
import org.eclnt.jsfserver.elements.impl.TESTComponent;
import org.eclnt.jsfserver.elements.phases.PhaseManager;
import org.eclnt.jsfserver.elements.phases.PhaseRunnables;
import org.eclnt.jsfserver.session.UsageWithoutSessionContext;
import org.eclnt.jsfserver.util.webappfiles.WebappDirectoryManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class Testing {
    public static void startTest() {
        UsageWithoutSessionContext.initUsageWithoutSessionContext();
    }

    public static void startTest(String webAppDirectory) {
        UsageWithoutSessionContext.initUsageWithoutSessionContext();
        UsageWithoutSessionContext.setWebcontentDirectory(webAppDirectory);
        WebappDirectoryManager.initialize();
    }

    public static void simulateRequest(RequestSimlulation rs) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("simulatePhaseBeforeUpdate\n");
            Testing.simulatePhaseBeforeUpdate();
            sb.append("processUpdate\n");
            rs.processUpdate();
            sb.append("simulatePhaseAfterUpdate\n");
            Testing.simulatePhaseAfterUpdate();
            sb.append("simulatePhaseBeforeInvoke\n");
            Testing.simulatePhaseBeforeInvoke();
            sb.append("processUpdate\n");
            rs.processInvoke();
            sb.append("simulatePhaseAfterInvoke\n");
            Testing.simulatePhaseAfterInvoke();
            sb.append("simulatePhaseBeforeRenderResponse\n");
            Testing.simulatePhaseBeforeRenderResponse();
            sb.append("processRendern");
            rs.processRender();
            sb.append("simulatePhaseAfterRenderResponse\n");
            Testing.simulatePhaseAfterRenderResponse();
        }
        catch (Throwable t) {
            throw new Error("Prolbem occurred during request simulation.\n" + sb.toString(), t);
        }
    }

    public static void simulatePhaseBeforeUpdate() {
        PhaseRunnables prs = PhaseManager.getPhaseRunnables();
        if (prs != null) {
            prs.runBeforeUpdateRunnables();
        }
    }

    public static void simulatePhaseAfterUpdate() {
        PhaseRunnables prs = PhaseManager.getPhaseRunnables();
        if (prs != null) {
            prs.runAfterUpdateRunnables();
        }
    }

    public static void simulatePhaseBeforeInvoke() {
        PhaseRunnables prs = PhaseManager.getPhaseRunnables();
        if (prs != null) {
            prs.runBeforeInvokeRunnables();
        }
    }

    public static void simulatePhaseAfterInvoke() {
        PhaseRunnables prs = PhaseManager.getPhaseRunnables();
        if (prs != null) {
            prs.runAfterInvokeRunnables();
        }
    }

    public static void simulatePhaseBeforeRenderResponse() {
        PhaseRunnables prs = PhaseManager.getPhaseRunnables();
        if (prs != null) {
            prs.runBeforeRenderResponseRunnables();
        }
    }

    public static void simulatePhaseAfterRenderResponse() {
        PhaseRunnables prs = PhaseManager.getPhaseRunnables();
        if (prs != null) {
            prs.runAfterRenderResponseRunnables();
        }
    }

    public static Statusbar getStatusbar() {
        return DefaultScreens.getSessionAccess().getStatusbar();
    }

    public static IdAttributesSelection getPopupIdAttributesSelection() {
        return DefaultScreens.getSessionAccess().getPopupIdAttributesSelection();
    }

    public static IdTextSelection getPopupIdTextSelection() {
        return DefaultScreens.getSessionAccess().getPopupIdTextSelection();
    }

    public static OKPopup getPopupOKPopup() {
        return DefaultScreens.getSessionAccess().getOkPopup();
    }

    public static YESNOPopup getPopupYESNOPopup() {
        return DefaultScreens.getSessionAccess().getYesNoPopup();
    }

    public static List<ModalPopup> getModalPopups() {
        return DefaultScreens.getSessionAccess().getSortedModalPopups();
    }

    public static List<ModelessPopup> getModelessPopups() {
        return DefaultScreens.getSessionAccess().getSortedModelessPopups();
    }

    public static TESTComponent createTestComponent() {
        TESTComponent tc = new TESTComponent();
        return tc;
    }

    public static BaseActionEvent createTestComponentEvent(TESTComponent tc, String clientEventString) {
        String command = ValueManager.decodeMethodName(clientEventString);
        return tc.createBaseActionEvent(command, clientEventString);
    }

    public static BaseActionEvent createEvent(String clientEventString) {
        TESTComponent tc = new TESTComponent();
        String command = ValueManager.decodeMethodName(clientEventString);
        return tc.createBaseActionEvent(command, clientEventString);
    }
}

