/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.bufferedcontent;

import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import org.eclnt.jsfserver.bufferedcontent.IBufferedStreamContent;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;

public abstract class DefaultBufferedStreamContent
implements IBufferedStreamContent,
ICCServerConstants {
    String m_id = "BUFFERED_" + UniqueIdCreator.createRandomId();
    String m_extension;
    String m_fileName;
    String m_currentClientFileName = null;
    String m_currentAccessURL = null;
    String m_currentAccessQueryString = null;

    @Override
    public long getContentLength() {
        return -1L;
    }

    public void setExtension(String value) {
        this.m_extension = value;
    }

    public String getExtension() {
        return this.m_extension;
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    public void setFileName(String value) {
        this.m_fileName = value;
        if (this.m_fileName != null) {
            this.m_fileName = ValueManager.encodeIntoValidFileName(this.m_fileName, false);
            int lastSlashIndex = this.m_fileName.lastIndexOf("/");
            if (lastSlashIndex >= 0) {
                this.m_fileName = this.m_fileName.substring(lastSlashIndex + 1);
            }
            if (this.m_fileName.length() == 0) {
                this.m_fileName = null;
            }
        }
    }

    public String getFileName() {
        return this.m_fileName;
    }

    @Override
    public String getURL() {
        String result = "ccbuffer/" + this.m_id + ".ccbuffer";
        if (this.m_extension != null) {
            result = result + "." + this.m_extension;
        }
        result = ServletUtil.encodeURL(result, HttpSessionAccess.getCurrentRequest(), HttpSessionAccess.getCurrentResponse());
        result = ServletUtil.addFileNameAdviceIntoURL(result, this.m_fileName);
        result = "/" + result;
        return result;
    }

    @Override
    @Deprecated
    public String getURLForBROWSERUsage() {
        if (!HttpSessionAccess.checkIfRunningInEmbeddedMode()) {
            return this.getURL();
        }
        try {
            String tempDirectory = HttpSessionAccess.getServletTempDirectory();
            String cctempDirectory = tempDirectory + "/cctemp/";
            FileManager.ensureDirectoryForFileExists(cctempDirectory);
            String fileName = cctempDirectory + "cctemp_" + UniqueIdCreator.createRandomId() + ".temp";
            if (this.m_extension != null) {
                fileName = fileName + "." + this.m_extension;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.writeStream(bos);
            FileManager.writeFile(fileName, bos.toByteArray(), true);
            return "file:///" + fileName;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_WAR, "Error when preparing dynamic content file", t);
            return null;
        }
    }

    @Override
    public void passClientFileName(String clientFileName) {
        this.m_currentClientFileName = clientFileName;
    }

    @Override
    public void passCurrentRequestQueryString(String queryString) {
        this.m_currentAccessQueryString = queryString;
    }

    public String getCurrentRequestQueryString() {
        return this.m_currentAccessQueryString;
    }

    @Override
    public void passCurrentRequestURL(String url) {
        this.m_currentAccessURL = url;
    }

    public String getCurrentClientFileName() {
        return this.m_currentClientFileName;
    }

    public String getCurrentRequestURL() {
        return this.m_currentAccessURL;
    }

    @Override
    public void beginGetting() {
    }

    @Override
    public void endGetting() {
        this.m_currentClientFileName = null;
    }

    @Override
    public void preProcessResponse(HttpServletResponse response) {
    }
}

