/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.defaultscreens;

import java.io.Serializable;
import java.util.Set;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDListBinding;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;

public class ImageSelection
implements Serializable {
    IImageSelectionListener m_listener;
    String m_directoryPath = "/eclntjsfserver/images/";
    FIXGRIDListBinding<MyRow> m_rows = new FIXGRIDListBinding();

    public FIXGRIDListBinding<MyRow> getRows() {
        return this.m_rows;
    }

    public void prepare(IImageSelectionListener listener, String directoryPath) {
        this.m_listener = listener;
        this.m_directoryPath = directoryPath;
        if (!this.m_directoryPath.startsWith("/")) {
            this.m_directoryPath = "/" + this.m_directoryPath;
        }
        if (!this.m_directoryPath.endsWith("/")) {
            this.m_directoryPath = this.m_directoryPath + "/";
        }
        this.updateRows();
    }

    private void selectImage(String icon) {
        if (this.m_listener != null && icon != null) {
            this.m_listener.imageSelected(icon);
        }
    }

    private void updateRows() {
        this.m_rows.getItems().clear();
        Set<String> images = WebResourceClassloaderReader.getFilesInPathDirectory(this.m_directoryPath, null);
        int colCounter = 0;
        int rowCounter = -1;
        for (String image : images) {
            if (colCounter == 0) {
                MyRow r = new MyRow();
                this.m_rows.getItems().add(r);
                ++rowCounter;
            }
            MyRow mr = this.m_rows.getItems().get(rowCounter);
            switch (colCounter) {
                case 0: {
                    mr.i_icon1 = this.m_directoryPath + image;
                    break;
                }
                case 1: {
                    mr.i_icon2 = this.m_directoryPath + image;
                    break;
                }
                case 2: {
                    mr.i_icon3 = this.m_directoryPath + image;
                    break;
                }
                case 3: {
                    mr.i_icon4 = this.m_directoryPath + image;
                }
            }
            ++colCounter;
            colCounter %= 4;
        }
    }

    public static interface IImageSelectionListener {
        public void imageSelected(String var1);
    }

    public class MyRow
    extends FIXGRIDItem
    implements Serializable {
        String i_icon1;
        String i_icon2;
        String i_icon3;
        String i_icon4;

        public String getIcon1() {
            return this.i_icon1;
        }

        public String getIcon2() {
            return this.i_icon2;
        }

        public String getIcon3() {
            return this.i_icon3;
        }

        public String getIcon4() {
            return this.i_icon4;
        }

        public void onIcon1(ActionEvent ae) {
            ImageSelection.this.selectImage(this.i_icon1);
        }

        public void onIcon2(ActionEvent ae) {
            ImageSelection.this.selectImage(this.i_icon2);
        }

        public void onIcon3(ActionEvent ae) {
            ImageSelection.this.selectImage(this.i_icon3);
        }

        public void onIcon4(ActionEvent ae) {
            ImageSelection.this.selectImage(this.i_icon4);
        }
    }
}

