/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.defaultscreens;

import java.io.Serializable;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.DefaultScreens;
import org.eclnt.jsfserver.defaultscreens.ModalPopup;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.i18n.I18N;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.StyleManager;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class OKPopup
implements Serializable,
ModalPopup.IModalPopupListener,
ICCServerConstants {
    public static String PAGENAME_DEFAULT = "/eclntjsfserver/popups/ok.jsp";
    public static String PAGENAME_HTML = "/eclntjsfserver/popups/okht.jsp";
    ModalPopup m_modalPopup;
    String m_text = "No text specified.";
    String m_icon = null;
    String m_buttonImage = null;
    String m_cancelButtonImage = null;
    IOKListener m_okListener;
    String m_textOk = null;
    String m_headline = null;
    String m_textAlign = "center";
    String m_textCancel = null;
    String m_textColor = null;
    String m_textContentType = "text/plain";
    boolean m_textContentAvoidSanitizing = false;
    boolean m_showCancel = false;
    String m_bodyBgpaint = null;
    String m_bodyBackgroundColor = null;
    String m_imageBackgroundColor = null;
    String m_imageBgpaint = null;

    public static void initialize() {
        if (SystemXml.getDefaultPopups().getOkpopup() != null) {
            PAGENAME_DEFAULT = SystemXml.getDefaultPopups().getOkpopup();
        }
    }

    public static OKPopup createInstance(String title, String text) {
        return OKPopup.createInstance(title, text, null);
    }

    public static OKPopup createInstance(String title, String text, IOKListener okListener) {
        return OKPopup.createInstanceExecute(title, text, "text/plain", okListener);
    }

    private static OKPopup createInstanceExecute(String title, String text, String contentType, IOKListener okListener) {
        OKPopup result = DefaultScreens.getSessionAccess().getOkPopup();
        result.m_buttonImage = StyleManager.getStyleValue("ccOKPopupOK");
        result.m_cancelButtonImage = StyleManager.getStyleValue("ccOKPopupCancel");
        result.m_textOk = null;
        if (result.m_modalPopup == null) {
            result.resetAll();
            result.setText(text);
            result.setTextContentType(contentType);
            result.setTextAlign("center");
            result.setHeadline(null);
            result.setIcon(null);
            result.m_okListener = okListener;
            result.m_modalPopup = ModalPopup.createInstance();
            String pageName = PAGENAME_DEFAULT;
            if ("browser".equals(HttpSessionAccess.getCurrentClientType())) {
                pageName = PAGENAME_HTML;
            }
            PopupSize ps = OKPopup.calculatePopupSize(text);
            result.m_modalPopup.open(pageName, title, ps.width, ps.height, result);
            result.m_modalPopup.setClientname("OKPopup");
            result.m_modalPopup.setStyleseq("riscdialog_popup_decorated");
            result.m_modalPopup.setStartfromrootwindow(false);
            result.m_modalPopup.showAsTopPopup();
        } else {
            if ("text/html".equals(contentType)) {
                result.setTextContentType(contentType);
            }
            CLog.L.log(CLog.LL_WAR, "OK Popup was created second time - texts will be concatenated");
            String currentText = result.getText();
            if ("text/plain".equals(result.getTextContentType())) {
                result.setText(currentText + "\r\n" + text);
            } else {
                result.setText(currentText + "<br>" + text);
            }
            result.setHeadline(null);
            result.setIcon(null);
            result.m_okListener = okListener;
        }
        result.m_showCancel = false;
        return result;
    }

    private static PopupSize calculatePopupSize(String text) {
        PopupSize result = text != null && text.length() > 2000 ? new PopupSize(800, 400) : (text != null && text.length() > 800 ? new PopupSize(800, 300) : (text != null && text.length() > 400 ? new PopupSize(600, 300) : (text != null && text.length() > 200 ? new PopupSize(500, 250) : new PopupSize(400, 200))));
        return result;
    }

    private void resetAll() {
        this.m_icon = null;
        this.m_buttonImage = null;
        this.m_cancelButtonImage = null;
        this.m_okListener = null;
        this.m_textOk = null;
        this.m_headline = null;
        this.m_textAlign = "center";
        this.m_textCancel = null;
        this.m_textContentType = "text/plain";
        this.m_textContentAvoidSanitizing = false;
        this.m_showCancel = false;
        this.m_bodyBackgroundColor = StyleManager.getStyleValue("ccOKPopupBackgroundColor");
        this.m_bodyBgpaint = null;
        this.m_textColor = StyleManager.getStyleValue("ccOKPopupTextColor");
        this.m_imageBackgroundColor = StyleManager.getStyleValue("ccOKPopupImageBackground");
        this.m_imageBgpaint = StyleManager.getStyleValue("ccOKPopupImageBgpaint");
    }

    public String getBodyBackgroundColor() {
        return this.m_bodyBackgroundColor;
    }

    public void setBodyBackgroundColor(String bodyBackgroundColor) {
        this.m_bodyBackgroundColor = bodyBackgroundColor;
    }

    public void setText(String value) {
        this.m_text = value;
    }

    public String getText() {
        return this.m_text;
    }

    public void setTextAlign(String value) {
        this.m_textAlign = value;
    }

    public String getTextAlign() {
        return this.m_textAlign;
    }

    public void setTextColor(String value) {
        this.m_textColor = value;
    }

    public String getTextColor() {
        return this.m_textColor;
    }

    public void setTextContentType(String textContentType, boolean avoidSanitizing) {
        this.m_textContentType = textContentType;
        this.m_textContentAvoidSanitizing = avoidSanitizing;
    }

    public void setTextContentType(String textContentType) {
        this.m_textContentType = textContentType;
    }

    public String getTextContentType() {
        return this.m_textContentType;
    }

    public boolean getTextContentAvoidSanitizing() {
        return this.m_textContentAvoidSanitizing;
    }

    public String getButtonImage() {
        return this.m_buttonImage;
    }

    public void setButtonImage(String buttonImage) {
        this.m_buttonImage = buttonImage;
    }

    public String getCancelButtonImage() {
        return this.m_cancelButtonImage;
    }

    public void setCancelButtonImage(String cancelButtonImage) {
        this.m_cancelButtonImage = cancelButtonImage;
    }

    public String getImageBackgroundColor() {
        return this.m_imageBackgroundColor;
    }

    public void setImageBackgroundColor(String imageBackgroundColor) {
        this.m_imageBackgroundColor = imageBackgroundColor;
    }

    public String getImageBgpaint() {
        return this.m_imageBgpaint;
    }

    public void setImageBgpaint(String imageBgpaint) {
        this.m_imageBgpaint = imageBgpaint;
    }

    public boolean getHeadlineRendered() {
        return this.m_headline != null && this.m_headline.length() != 0;
    }

    public void setHeadline(String value) {
        this.m_headline = value;
    }

    public String getHeadline() {
        return this.m_headline;
    }

    public void setIcon(String value) {
        this.m_icon = value;
    }

    public String getIcon() {
        return this.m_icon;
    }

    public ModalPopup getModalPopup() {
        return this.m_modalPopup;
    }

    public boolean isIconRendered() {
        return this.m_icon != null;
    }

    public void onClose(ActionEvent ae) {
        this.m_modalPopup.close();
        this.m_modalPopup = null;
        if (this.m_okListener != null) {
            try {
                this.m_okListener.reactOnOK();
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Problem when calling ok-processing", t);
                Statusbar.outputAlert(t.toString(), "Problem", ValueManager.getStackstraceString(t));
            }
        }
    }

    public void onCancel(ActionEvent ae) {
        this.m_modalPopup.close();
        this.m_modalPopup = null;
        if (this.m_okListener != null && this.m_okListener instanceof IOKCancelListener) {
            try {
                ((IOKCancelListener)this.m_okListener).reactOnCancel();
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Problem when calling cancel-processing", t);
                Statusbar.outputAlert(t.toString(), "Problem", ValueManager.getStackstraceString(t));
            }
        }
    }

    public void close() {
        this.reactOnPopupClosedByUser();
    }

    @Override
    public void reactOnPopupClosedByUser() {
        this.m_modalPopup.close();
        this.m_modalPopup = null;
        if (this.m_okListener != null && this.m_okListener instanceof IOKCancelListener) {
            try {
                ((IOKCancelListener)this.m_okListener).reactOnCancel();
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Problem when calling cancel-processing", t);
                Statusbar.outputAlert(t.toString(), "Problem", ValueManager.getStackstraceString(t));
            }
        }
    }

    public void setTextOk(String value) {
        this.m_textOk = value;
    }

    public String getTextOk() {
        if (this.m_textOk == null) {
            return new I18N().get("OKPopup_ok");
        }
        return this.m_textOk;
    }

    public void setTextCancel(String value) {
        this.m_textCancel = value;
    }

    public String getTextCancel() {
        if (this.m_textCancel == null) {
            return new I18N().get("OKPopup_cancel");
        }
        return this.m_textCancel;
    }

    public void setShowCancel(boolean value) {
        this.m_showCancel = value;
    }

    public boolean getShowCancel() {
        return this.m_showCancel;
    }

    public String getBodyBgpaint() {
        return this.m_bodyBgpaint;
    }

    public void setBodyBgpaint(String bodyBgpaint) {
        this.m_bodyBgpaint = bodyBgpaint;
    }

    public static interface IOKListener {
        public void reactOnOK();
    }

    static class PopupSize {
        int width = 400;
        int height = 200;

        public PopupSize() {
        }

        public PopupSize(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }

    public static interface IOKCancelListener
    extends IOKListener {
        public void reactOnCancel();
    }

    public static class OKCancelListenerLambda
    implements IOKCancelListener {
        Runnable i_ok;
        Runnable i_cancel;

        public OKCancelListenerLambda(Runnable ok) {
            this.i_ok = ok;
        }

        public OKCancelListenerLambda(Runnable ok, Runnable cancel) {
            this.i_ok = ok;
            this.i_cancel = cancel;
        }

        @Override
        public void reactOnOK() {
            if (this.i_ok != null) {
                this.i_ok.run();
            }
        }

        @Override
        public void reactOnCancel() {
            if (this.i_cancel != null) {
                this.i_cancel.run();
            }
        }
    }
}

