/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.eclnt.jsfserver.elements.impl.FIXGRIDBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDComponent;
import org.eclnt.jsfserver.elements.impl.FIXGRIDExportSanitizer;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDOdsExporter;
import org.eclnt.jsfserver.elements.util.DefaultFIXGRIDExportInfoProvider;
import org.eclnt.jsfserver.elements.util.ENUMExportType;
import org.eclnt.jsfserver.elements.util.IFIXGRIDExportInfoProvider;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.odftoolkit.odfdom.type.Color;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.Row;
import org.odftoolkit.simple.table.Table;

public class FIXGRIDOdsExporter
implements IFIXGRIDOdsExporter {
    static final String DEFAULT_HEADER_BACKGROUND = "#F0F0F0";
    static final String DEFAULT_FOOTER_BACKGROUND = "#F0F0F0";
    static final String DEFAULT_VALUE_BACKGROUND = "#FFFFFF";
    float m_columnSizeFactor = 0.33f;
    IFIXGRIDExportInfoProvider m_exportInfoProvider = new DefaultFIXGRIDExportInfoProvider();
    FIXGRIDBinding m_fixgrid;
    List<FIXGRIDComponent.ColumnInfo> m_columns;
    int m_currentRowCounter = 0;
    SpreadsheetDocument m_sshDocument;
    Table m_sshTable;

    @Override
    public void setGridTitle(String title) {
    }

    @Override
    public byte[] exportGrid(FIXGRIDBinding fixgrid, List<FIXGRIDComponent.ColumnInfo> columns, List<List<FIXGRIDBinding.FormattedValue>> data, boolean selctedItemsOnly) {
        this.m_currentRowCounter = 0;
        this.m_fixgrid = fixgrid;
        this.m_columns = columns;
        try {
            this.m_sshDocument = this.createSpreasSheetDocument();
            this.m_sshTable = this.createTableInSpreadSheetDocument();
            this.transferColumnsWidths();
            CLog.L.log(CLog.LL_INF, "ODS export: processing header rows");
            List<List<FIXGRIDBinding.FormattedValue>> headerRows = fixgrid.getExporter().exportToValueListHeader();
            FIXGRIDExportSanitizer.instance().sanitizeValueDataBeforeExport(ENUMExportType.ODS, headerRows);
            if (this.m_exportInfoProvider != null) {
                headerRows = this.m_exportInfoProvider.updateHeaderRowValues(headerRows);
            }
            this.createBeforeHeader();
            this.createHeaderRows(headerRows);
            this.createAfterHeader();
            CLog.L.log(CLog.LL_INF, "Excel export: processing content rows");
            this.createDataRows(data);
            CLog.L.log(CLog.LL_INF, "ODS export: processing footer rows");
            List<List<FIXGRIDBinding.FormattedValue>> footerRows = fixgrid.getExporter().exportToValueListFooter();
            FIXGRIDExportSanitizer.instance().sanitizeValueDataBeforeExport(ENUMExportType.ODS, footerRows);
            if (this.m_exportInfoProvider != null) {
                footerRows = this.m_exportInfoProvider.updateHeaderRowValues(footerRows);
            }
            this.createBeforeFooter();
            this.createFooterRows(footerRows);
            this.createAfterFooter();
            byte[] result = this.createByteContent(this.m_sshDocument);
            return result;
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    protected void createHeaderRows(List<List<FIXGRIDBinding.FormattedValue>> headerRows) {
        for (List<FIXGRIDBinding.FormattedValue> row : headerRows) {
            this.createHeaderRow(row);
            ++this.m_currentRowCounter;
        }
    }

    protected void createDataRows(List<List<FIXGRIDBinding.FormattedValue>> data) {
        for (List<FIXGRIDBinding.FormattedValue> row : data) {
            this.createDataRow(row);
            ++this.m_currentRowCounter;
        }
    }

    protected void createFooterRows(List<List<FIXGRIDBinding.FormattedValue>> footerRows) {
        for (List<FIXGRIDBinding.FormattedValue> row : footerRows) {
            this.createFooterRow(row);
            ++this.m_currentRowCounter;
        }
    }

    protected void createDataRow(List<FIXGRIDBinding.FormattedValue> row) {
        this.createRow(row);
        this.drawBackgroundInRow(this.findDefaultValueBackground());
    }

    protected void createHeaderRow(List<FIXGRIDBinding.FormattedValue> row) {
        this.createRow(row);
        this.drawBackgroundInRow(this.findDefaultHeaderBackground());
    }

    protected void createFooterRow(List<FIXGRIDBinding.FormattedValue> row) {
        this.createRow(row);
        this.drawBackgroundInRow(this.findDefaultFooterBackground());
    }

    protected void drawBackgroundInRow(String background) {
        Row sshRow = this.m_sshTable.getRowByIndex(this.m_currentRowCounter);
        for (int i = 0; i < this.m_columns.size(); ++i) {
            sshRow.getCellByIndex(i).setCellBackgroundColor(Color.valueOf((String)background));
        }
    }

    protected String findDefaultHeaderBackground() {
        return "#F0F0F0";
    }

    protected String findDefaultFooterBackground() {
        return "#F0F0F0";
    }

    protected String findDefaultValueBackground() {
        return DEFAULT_VALUE_BACKGROUND;
    }

    protected void createRow(List<FIXGRIDBinding.FormattedValue> row) {
        Row sshRow = this.m_sshTable.getRowByIndex(this.m_currentRowCounter);
        int counter = 0;
        for (FIXGRIDBinding.FormattedValue v : row) {
            Cell sshCell = sshRow.getCellByIndex(counter);
            this.transferFormattedValueIntoCell(v, sshCell);
            ++counter;
        }
    }

    protected void transferFormattedValueIntoCell(FIXGRIDBinding.FormattedValue v, Cell sshCell) {
        if (v == null) {
            return;
        }
        if (v.getValue() == null) {
            return;
        }
        if (ValueManager.checkIfClassIsNumber(v.getValue().getClass())) {
            int numberOfDecimals;
            String s = ValueManager.convertObject2ValueString(v.getValue());
            Double d = (Double)ValueManager.convertStringIntoObject(s, Double.class);
            if (v.getFormatmask() != null && (numberOfDecimals = this.findNumberOfDecimals(v.getFormatmask())) > 0) {
                String odsFormat = this.buildFormatString(numberOfDecimals);
                sshCell.setFormatString(odsFormat);
            }
            sshCell.setDoubleValue(d);
        } else if (v.getValue().getClass() == Boolean.class || v.getValue().getClass() == Boolean.TYPE) {
            sshCell.setBooleanValue((Boolean)v.getValue());
        } else if (Date.class.isAssignableFrom(v.getValue().getClass())) {
            Calendar cal = null;
            cal = v.getTimezone() != null ? Calendar.getInstance(TimeZone.getTimeZone(v.getTimezone())) : Calendar.getInstance();
            cal.setTime((Date)v.getValue());
            if (v.getFormatmask() != null && v.getFormatmask().contains("time")) {
                sshCell.setDateTimeValue(cal);
            } else {
                sshCell.setDateValue(cal);
            }
        } else if (v.getValue().getClass() == LocalDate.class) {
            LocalDate ld = (LocalDate)v.getValue();
            Date d = Date.from(ld.atStartOfDay(ZoneId.systemDefault()).toInstant());
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            sshCell.setDateValue(cal);
        } else if (v.getValue().getClass() == LocalDateTime.class) {
            LocalDateTime ldt = (LocalDateTime)v.getValue();
            Date d = Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            sshCell.setDateTimeValue(cal);
        } else {
            String s = ValueManager.convertObject2DisplayString(v.getValue(), v.getFormat(), v.getFormatmask(), v.getTimezone(), true);
            sshCell.setStringValue(s);
        }
    }

    protected String buildFormatString(int numberOfDecimals) {
        if (numberOfDecimals < 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("#,##0.");
        for (int i = 0; i < numberOfDecimals; ++i) {
            sb.append("0");
        }
        return sb.toString();
    }

    protected int findNumberOfDecimals(String formatmask) {
        if (formatmask == null) {
            return -1;
        }
        int pos = formatmask.indexOf("decmax");
        if (pos >= 0) {
            return ValueManager.decodeInt(formatmask.substring(pos + 6), -1);
        }
        pos = formatmask.indexOf("dec");
        if (pos >= 0) {
            return ValueManager.decodeInt(formatmask.substring(pos + 3), -1);
        }
        pos = formatmask.indexOf(".");
        if (pos >= 0) {
            return formatmask.length() - (pos + 1);
        }
        return -1;
    }

    protected void createAfterHeader() {
    }

    protected void createBeforeHeader() {
    }

    protected void createAfterFooter() {
    }

    protected void createBeforeFooter() {
    }

    protected byte[] createByteContent(SpreadsheetDocument sshDocument) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        sshDocument.save((OutputStream)bos);
        return bos.toByteArray();
    }

    protected void transferColumnsWidths() {
        int counter = 0;
        for (FIXGRIDComponent.ColumnInfo column : this.m_columns) {
            int width = this.calculateColumnWidth(column);
            this.m_sshTable.getColumnByIndex(counter).setWidth((double)width);
            ++counter;
        }
    }

    protected int calculateColumnWidth(FIXGRIDComponent.ColumnInfo ci) {
        int w = ci.getExportWidth();
        if (w < 0) {
            w = ci.getWidth();
        }
        if (w < 0) {
            w = Math.round(-300.0f * (float)w / 100.0f);
            if (ci.getMinWidth() > 0 && w < ci.getMinWidth()) {
                w = ci.getMinWidth();
            }
        }
        if (this.m_columnSizeFactor != 1.0f) {
            w = Math.round((float)w * this.m_columnSizeFactor);
        }
        if (this.m_exportInfoProvider != null) {
            w = this.m_exportInfoProvider.findColumnWidthForPDFColumn(ci, w);
        }
        return w;
    }

    protected Table createTableInSpreadSheetDocument() {
        Table ta = (Table)this.m_sshDocument.getTableList().get(0);
        ta.setTableName("Export");
        return ta;
    }

    protected SpreadsheetDocument createSpreasSheetDocument() throws Exception {
        return SpreadsheetDocument.newSpreadsheetDocument();
    }

    @Override
    public void setExportInfoProvider(IFIXGRIDExportInfoProvider exportInfoProvider) {
    }

    @Override
    public void setColumnSizeFactor(float columnSizeFactor) {
    }

    @Override
    public float getColumnSizeFactor() {
        return 0.0f;
    }

    @Override
    public void setMaxNumberOfGridRows(int maxNumberOfGridRows) {
    }

    @Override
    public int getMaxNumberOfGridRows() {
        return 0;
    }

    public void ping(String fileName) {
        try {
            SpreadsheetDocument sd = SpreadsheetDocument.newSpreadsheetDocument();
            Table ta = (Table)sd.getTableList().get(0);
            ta.setTableName("Export");
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    ta.getColumnByIndex(i).setWidth(100.0);
                    continue;
                }
                ta.getColumnByIndex(i).setWidth(50.0);
            }
            for (int iRow = 0; iRow < 20; ++iRow) {
                Row r = ta.getRowByIndex(iRow);
                Cell c = r.getCellByIndex(0);
                c.setDoubleValue(Double.valueOf(100.555));
                c = r.getCellByIndex(1);
                Calendar cal = Calendar.getInstance();
                cal.setTime(new Date());
                c.setDateValue(cal);
                c = r.getCellByIndex(2);
                c.setBooleanValue(Boolean.valueOf(true));
                for (int iCol = 3; iCol < 10; ++iCol) {
                    Cell c2 = r.getCellByIndex(iCol);
                    c2.setStringValue("Test " + iRow + "/" + iCol);
                    c2.setCellBackgroundColor(Color.valueOf((String)"#800000"));
                }
            }
            sd.save(fileName);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }
}

