/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.managedbean.preview;

import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.managedbean.preview.DefaultProcessPreview;
import org.eclnt.jsfserver.managedbean.preview.IPreviewInstanceConfigurator;
import org.eclnt.jsfserver.managedbean.preview.ProcessPreviewUtil;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.classresolver.ENUMCallerType;
import org.eclnt.util.log.CLog;
import org.eclnt.util.logdt.DTLogFactory;
import org.eclnt.util.logdt.ENUMLogCategory;

public class ProcessPreviewByInstanceConfigurator
extends DefaultProcessPreview {
    IPreviewInstanceConfigurator m_prepInstance;

    @Override
    public void processBeforeCreation(String beanName, Class dispatchedBeanClass) {
        try {
            String prepClassName = ProcessPreviewUtil.findPreparationClassName(dispatchedBeanClass);
            Class prepClass = null;
            try {
                prepClass = CCClassResolver.resolveClass(prepClassName, true, HotDeployManager.currentClassLoader(), ENUMCallerType.EXPRESSIONRESOLUTION);
                this.m_prepInstance = (IPreviewInstanceConfigurator)prepClass.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                return;
            }
        }
        catch (Throwable t) {
            DTLogFactory.getLog().log(ENUMLogCategory.OTHER, null, "Problem when preparing preview configurator instance: " + dispatchedBeanClass.getName(), t);
            CLog.L.log(CLog.LL_INF, "Problem when preparing preview configurator instance: " + dispatchedBeanClass.getName(), t);
            return;
        }
    }

    @Override
    public void processPreviewInitialization(String beanName, Object dispatchedBean) {
        try {
            if (this.m_prepInstance == null) {
                return;
            }
            if (dispatchedBean == null) {
                return;
            }
            this.m_prepInstance.configureForPreview(beanName, dispatchedBean);
        }
        catch (Throwable t) {
            DTLogFactory.getLog().log(ENUMLogCategory.OTHER, null, "Problem when preparing preview configurator instance: " + dispatchedBean.getClass().getName(), t);
            CLog.L.log(CLog.LL_INF, "Problem when preparing preview configurator instance: " + dispatchedBean.getClass().getName(), t);
            return;
        }
    }
}

