/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.rttools;

import java.io.Serializable;
import java.util.List;
import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.ModalPopup;
import org.eclnt.jsfserver.defaultscreens.YESNOPopup;
import org.eclnt.jsfserver.elements.events.BaseActionEventPopupMenuItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeItem;
import org.eclnt.jsfserver.elements.util.DefaultModalPopupListener;
import org.eclnt.jsfserver.rttools.StreamStoreDetailUI;
import org.eclnt.jsfserver.rttools.StreamStoreNewContentUI;
import org.eclnt.jsfserver.streamstore.IStreamStore;
import org.eclnt.jsfserver.streamstore.StreamStore;
import org.eclnt.jsfserver.streamstore.StreamStoreFile;
import org.eclnt.util.log.CLog;
import org.eclnt.workplace.IWorkpageDispatcher;
import org.eclnt.workplace.WorkpageDispatchedPageBean;
import org.eclnt.workplace.WorkpageStartInfo;
import org.eclnt.workplace.WorkpageStarterFactory;

@CCGenClass(expressionBase="#{cctd.StreamStoreTreeUI}")
public class StreamStoreTreeUI
extends WorkpageDispatchedPageBean
implements Serializable {
    protected FIXGRIDTreeBinding<TreeNode> m_tree = new FIXGRIDTreeBinding();
    IStreamStore mm_streamStore;
    String m_streamStoreFileRootWS;
    String m_editPage = "/eclntjsfserver/includes/streamstoredetail.jsp";
    boolean m_withTenantManagement = true;
    boolean m_renderedHeader = true;

    public StreamStoreTreeUI(IWorkpageDispatcher workpageDispatcher) {
        super(workpageDispatcher);
        this.reloadTree();
    }

    public StreamStoreTreeUI(IWorkpageDispatcher workpageDispatcher, String streamStoreFileRootWS, boolean withTenantManagement, String editPage) {
        super(workpageDispatcher);
        this.m_streamStoreFileRootWS = streamStoreFileRootWS;
        this.m_editPage = editPage;
        this.m_withTenantManagement = withTenantManagement;
        this.reloadTree();
    }

    @Override
    public String getPageName() {
        return "/eclntjsfserver/includes/streamstoretree.jsp";
    }

    @Override
    public String getRootExpressionUsedInPage() {
        return "#{cctd.StreamStoreTreeUI}";
    }

    public FIXGRIDTreeBinding<TreeNode> getTree() {
        return this.m_tree;
    }

    public void onRefresh(ActionEvent event) {
        this.reloadTree();
    }

    public boolean getRenderedHeader() {
        return this.m_renderedHeader;
    }

    public void setRenderedHeader(boolean renderedHeader) {
        this.m_renderedHeader = renderedHeader;
    }

    private void reloadTree() {
        this.m_tree.getRootNode().removeAllChildNodes(true);
        TreeNode top = new TreeNode(this.m_tree.getRootNode(), "/ccextcalendar", "Calendar Definition", true, true);
        top.setImage("/eclntjsfserver/images/fixfolder.png");
        top = new TreeNode(this.m_tree.getRootNode(), "/ccworkplace", "Workplace Configuration", true, false);
        top.setImage("/eclntjsfserver/images/fixfolder.png");
        TreeNode sub = new TreeNode(top, "/ccworkplace/functiontrees", "Function Trees", true, true);
        sub.setImage("/eclntjsfserver/images/fixfolder.png");
        sub = new TreeNode(top, "/ccworkplace/perspectives", "Perspectives", true, true);
        sub.setImage("/eclntjsfserver/images/fixfolder.png");
        sub = new TreeNode(top, "/ccworkplace/userinfo", "User Info", true, true);
        sub.setImage("/eclntjsfserver/images/fixfolder.png");
    }

    private void showFile(String absPath, String selectorText) {
        WorkpageStartInfo wpsi = new WorkpageStartInfo();
        wpsi.setJspPage(this.m_editPage);
        wpsi.setId("streamstore_" + absPath);
        wpsi.setParam(StreamStoreDetailUI.PARAM_ABSPATH, absPath);
        wpsi.setParam(StreamStoreDetailUI.PARAM_STREAMSTOREFILEROOTWS, this.m_streamStoreFileRootWS);
        wpsi.setParam(StreamStoreDetailUI.PARAM_WITHTENANTMANAGEMENT, this.m_withTenantManagement + "");
        wpsi.setText(absPath);
        wpsi.setSelectorTitle(selectorText);
        wpsi.setDecorated(false);
        WorkpageStarterFactory.getWorkpageStarter().startWorkpage(this.getOwningDispatcher(), this.getWorkpageContainer(), wpsi);
    }

    private void createFile(final TreeNode treeNode, final String absPath) {
        StreamStoreNewContentUI ncui = new StreamStoreNewContentUI();
        final ModalPopup popup = this.openModalPopup(ncui, "Create new content", 0, 0, null);
        popup.setPopupListener(new DefaultModalPopupListener(popup));
        ncui.prepare(new StreamStoreNewContentUI.IListener(){

            @Override
            public void reactOnContentSpecified(String contentName) {
                popup.close();
                StreamStoreTreeUI.this.createFileExecute(treeNode, absPath, contentName);
            }
        }, absPath);
    }

    private void createFileExecute(TreeNode treeNode, String absPath, String contentName) {
        String path = absPath + "/" + contentName;
        StreamStore.getInstance().writeUTF8(path, "", true);
        this.showFile(path, contentName);
        TreeNode nt = new TreeNode(treeNode, path, contentName, false, false);
        this.m_tree.ensureItemToBeDisplayed(nt);
        this.m_tree.deselectCurrentSelection();
        this.m_tree.selectItem(nt);
    }

    private void removeFile(final TreeNode treeNode, final String absPath) {
        YESNOPopup.createInstance("Removing file", "Dou you really want to remove the selected content?", new YESNOPopup.IYesNoListener(){

            @Override
            public void reactOnYes() {
                StreamStoreTreeUI.this.removeFileExecute(treeNode, absPath);
            }

            @Override
            public void reactOnNo() {
            }
        });
    }

    private void removeFileExecute(TreeNode treeNode, String absPath) {
        StreamStore.getInstance().removeStream(absPath, true);
        treeNode.removeNode();
    }

    private IStreamStore findStreamStore() {
        if (this.mm_streamStore == null) {
            if (this.m_streamStoreFileRootWS == null) {
                CLog.L.log(CLog.LL_INF, "Using normal runtime stream store");
                this.mm_streamStore = StreamStore.getInstance();
            } else {
                CLog.L.log(CLog.LL_INF, "Using file stream store, root: " + this.m_streamStoreFileRootWS + "/ tenant management: " + this.m_withTenantManagement);
                this.mm_streamStore = new StreamStoreFile();
                ((StreamStoreFile)this.mm_streamStore).init(this.m_streamStoreFileRootWS, this.m_withTenantManagement);
            }
        }
        return this.mm_streamStore;
    }

    public class TreeNode
    extends FIXGRIDTreeItem
    implements Serializable {
        boolean i_isFolder;
        boolean i_subNodesAvailable;
        String i_absPath;
        boolean i_alsoReadSubFolders;

        public TreeNode(FIXGRIDTreeItem parentNode, String absPath, String text, boolean isFolder, boolean alsoReadSubFolders) {
            super(parentNode);
            this.i_subNodesAvailable = false;
            this.i_alsoReadSubFolders = false;
            this.i_absPath = absPath;
            this.setText(text);
            this.i_isFolder = isFolder;
            this.i_alsoReadSubFolders = alsoReadSubFolders;
            if (this.i_isFolder) {
                this.setStatus(1);
                this.setImage("/eclntjsfserver/images/folder.png");
            } else {
                this.setStatus(2);
                this.setImage("/eclntjsfserver/images/textxml.png");
            }
        }

        @Override
        public void onToggle() {
            if (!this.i_subNodesAvailable) {
                List<String> names = StreamStoreTreeUI.this.findStreamStore().getContainedStreams(this.i_absPath, false);
                for (String name : names) {
                    new TreeNode(this, this.i_absPath + "/" + name, name, false, false);
                }
                if (this.i_alsoReadSubFolders) {
                    List<String> dirNames = StreamStoreTreeUI.this.findStreamStore().getContainedFolders(this.i_absPath, false);
                    for (String dirName : dirNames) {
                        new TreeNode(this, this.i_absPath + "/" + dirName, dirName, true, true);
                    }
                }
                this.i_subNodesAvailable = true;
            }
        }

        @Override
        public void onRowExecute() {
            if (this.i_isFolder) {
                this.toggleNode();
            } else {
                StreamStoreTreeUI.this.showFile(this.i_absPath, this.getText());
            }
        }

        public String getPopupMenu() {
            if (this.i_isFolder) {
                return "FOLDERPOPUPMENU";
            }
            return "ENDNODEPOPUPMENU";
        }

        @Override
        public void processTREENDOEAction(ActionEvent event) {
            super.processTREENDOEAction(event);
            if (event instanceof BaseActionEventPopupMenuItem) {
                BaseActionEventPopupMenuItem e = (BaseActionEventPopupMenuItem)event;
                if ("ADDNEWCONTENT".equals(e.getCommand())) {
                    StreamStoreTreeUI.this.createFile(this, this.i_absPath);
                }
                if ("REMOVECONTENT".equals(e.getCommand())) {
                    StreamStoreTreeUI.this.removeFile(this, this.i_absPath);
                }
            }
        }
    }
}

