/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.session;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.configuration.CCConfigurationObject;
import org.eclnt.jsfserver.defaultscreens.Client;
import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.jsfserver.session.ISessionDefaultsProvider;
import org.eclnt.jsfserver.session.UsageWithoutSessionContext;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.parse.SAXParserUtil;
import org.eclnt.util.file.ConfigFileReader;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SessionInfo
implements Serializable,
ICCServerConstants {
    private static final Object s_syncher = new Object();
    private static CCConfigurationObject<ISessionDefaultsProvider> s_sessionDefaultsProvider;
    private static ServletContext s_servletContext;
    private String m_style = null;
    public boolean m_styleWasChangedAtRuntime = false;
    private String m_startLanguage = Locale.getDefault().getLanguage();
    private String m_startCountry = Locale.getDefault().getCountry();
    private String m_startClientlanguage = null;
    private String m_startClientcountry = null;
    private String m_startClienttimezone = null;
    private boolean m_defaultLanguageIsSet = false;
    private long m_requestFocusCounter = 10L;
    private boolean m_takeOverClientLocaleSettings = false;
    private boolean m_clientIsInTestMode = false;
    private String m_lastProcessedRequestId = null;
    private String m_currentServerRequestId = null;
    private String m_lastServerRequestId = null;
    private long m_htHighestFocusCounter = 1L;
    private boolean m_profileMode = false;
    private Locale m_lastRoundtripLocale = null;
    private String m_clientJavaType = null;
    private int m_nagleResponseSize = -1;
    private int m_clientTimeZoneOffset = 0;
    private Map<String, String> m_initialURLParameters = new HashMap<String, String>();
    private String m_clientStartURL = null;
    private String m_bufferedClientId = null;
    private boolean m_dataFromHttpHeaderTransferred = false;
    boolean m_pageaddonsAdded = false;
    static boolean s_sessionDefaultsParserRead;
    static SessionDefaultsParser s_sessionDefaultsParser;
    static Object s_sessionDefaultsParserSyncher;

    private SessionInfo(boolean withInit, HttpServletRequest request) {
        if (withInit) {
            this.initSessionInfo(request);
        }
    }

    static SessionInfo createSessionInfoForRiscStarter() {
        SessionInfo result = new SessionInfo(false, null);
        result.transferInitializationDefaults(null, true);
        return result;
    }

    static SessionInfo createDummySessionInfo() {
        SessionInfo result = new SessionInfo(false, null);
        result.m_clientJavaType = "risc";
        result.m_style = "defaultrisc";
        return result;
    }

    public static void initialize(ServletContext context) {
        String sdp = SystemXml.getSessionDefaultsProvider();
        if (sdp != null && sdp.length() > 0) {
            try {
                s_sessionDefaultsProvider = new CCConfigurationObject(sdp, null);
            }
            catch (Throwable t) {
                throw new Error("Problem during initialization of ISessionDefaultProvider: " + sdp, t);
            }
        }
    }

    public static SessionInfo getSessionInstance() {
        try {
            HttpSession hs = SessionInfo.getCurrentHttpSession();
            return SessionInfo.getSessionInstance(hs, null);
        }
        catch (RuntimeException e) {
            if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
                return UsageWithoutSessionContext.getDummySessionInfo();
            }
            throw e;
        }
        catch (Error e) {
            if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
                return UsageWithoutSessionContext.getDummySessionInfo();
            }
            throw e;
        }
    }

    public static void removeSessionInstance(HttpSession session, String subpageId) {
        try {
            if (session == null) {
                session = HttpSessionAccess.getCurrentHttpSession();
            }
            session.removeAttribute(SessionInfo.class.getName() + "/" + subpageId);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static SessionInfo getSessionInstance(HttpSession hs, HttpServletRequest request) {
        SessionInfo result = (SessionInfo)hs.getAttribute(SessionInfo.class.getName() + "/" + ThreadData.getInstance().getSubpageId());
        if (result == null) {
            result = new SessionInfo(true, request);
            ServletUtil.setSessionAttributeWithTrustedName(hs, SessionInfo.class.getName() + "/" + ThreadData.getInstance().getSubpageId(), result);
        } else {
            result.transferDataFromHttpHeader(request);
        }
        return result;
    }

    private static void initializeSessionInstance() {
        try {
            HttpServletRequest httpServletRequest = HttpSessionAccess.getCurrentRequest();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem during initializeSessionInstance", t);
        }
    }

    public static HttpSession getCurrentHttpSession() {
        return HttpSessionAccess.getCurrentHttpSession();
    }

    public void setStyle(String value) {
        this.m_style = value;
    }

    public void setStyleAndReloadClient(String value) {
        this.setStyle(value);
        HttpSessionAccess.reloadClient();
        this.m_styleWasChangedAtRuntime = true;
    }

    public boolean getStyleWasChangedAtRuntime() {
        return this.m_styleWasChangedAtRuntime;
    }

    public String getStyle() {
        if (this.m_style == null) {
            String result = "default";
            if ("fx".equals(HttpSessionAccess.getCurrentClientJavaType())) {
                result = "defaultfx";
            }
            if (HttpSessionAccess.checkIfCurrentClientTypeIsRisc()) {
                result = "defaultrisc";
            }
            return result;
        }
        return this.m_style;
    }

    private void applyDefaultCountryLanguageFirstTime(FacesContext context) {
        if (this.m_defaultLanguageIsSet) {
            return;
        }
        this.m_defaultLanguageIsSet = true;
        if (!Locale.getDefault().getCountry().equals(this.m_startCountry) || !Locale.getDefault().getLanguage().equals(this.m_startLanguage)) {
            Locale l = new Locale(this.m_startLanguage, this.m_startCountry);
            context.getViewRoot().setLocale(l);
        }
        Client client = Client.instance();
        if (client.getTimezone() == null) {
            client.setTimezone(this.m_startClienttimezone);
        }
        if (client.getLanguage() == null) {
            client.setLanguage(this.m_startClientlanguage);
        }
        if (client.getCountry() == null) {
            client.setCountry(this.m_startClientcountry);
        }
        if (this.m_takeOverClientLocaleSettings) {
            Locale currentLocale;
            HttpServletRequest request = HttpSessionAccess.getCurrentRequest();
            String language = request.getHeader("eclnt-language");
            String country = request.getHeader("eclnt-country");
            if (!(language == null || country == null || (currentLocale = context.getViewRoot().getLocale()).getCountry().equals(country) && currentLocale.getLanguage().equals(language))) {
                CLog.L.log(CLog.LL_INF, "Client locale values were taken over: " + language + "/" + country);
                Locale l = new Locale(language, country);
                context.getViewRoot().setLocale(l);
            }
        }
    }

    public void applyLocaleSettingsAfterRestoringView(FacesContext context) {
        if (this.m_lastRoundtripLocale != null) {
            context.getViewRoot().setLocale(this.m_lastRoundtripLocale);
        }
    }

    public void applyLastRoundtripLocale(Locale l) {
        this.m_lastRoundtripLocale = l;
    }

    public void applyLocaleSettingsBeforeRendering(FacesContext context) {
        this.applyDefaultCountryLanguageFirstTime(context);
    }

    public void applyLocaleSettingsAfterRendering(FacesContext context) {
        this.m_lastRoundtripLocale = context.getViewRoot().getLocale();
    }

    public void increaseRequestFocusCounter() {
        this.m_requestFocusCounter += 10L;
    }

    public long getNewRequestFocusCounter() {
        return this.m_requestFocusCounter;
    }

    public void setPageaddonsAdded(boolean value) {
        this.m_pageaddonsAdded = true;
    }

    public boolean getPageaddonsAdded() {
        return this.m_pageaddonsAdded;
    }

    public static SessionInfo readSessionInfoFromFile(String xmlFileName, String defaultStyle) {
        SessionInfo result = new SessionInfo(false, null);
        try {
            String xml = FileManager.readUTF8File(xmlFileName, true);
            xml = ValueManager.replaceSystemProperties(xml, HttpSessionAccess.getWebApplicationName(), true);
            SessionDefaultsParser sdp = new SessionDefaultsParser();
            SAXParserUtil.parse(xml, (DefaultHandler)sdp);
            if (sdp.i_language != null) {
                result.m_startLanguage = sdp.i_language;
            }
            if (sdp.i_country != null) {
                result.m_startCountry = sdp.i_country;
            }
            result.m_startClienttimezone = sdp.i_clienttimezone;
            result.m_startClientcountry = sdp.i_clientcountry;
            result.m_startClientlanguage = sdp.i_clientlanguage;
            if (sdp.i_style != null) {
                result.m_style = sdp.i_style;
            }
            if (HttpSessionAccess.checkIfCurrentClientTypeIsRisc()) {
                if (result.m_style == null) {
                    result.m_style = "defaultrisc";
                } else if (sdp.i_riscStyle != null) {
                    result.m_style = sdp.i_riscStyle;
                }
            }
            result.m_takeOverClientLocaleSettings = sdp.i_takeOverClientLocaleSettings;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (result.m_style == null) {
            result.m_style = defaultStyle;
        }
        return result;
    }

    public boolean getClientIsInTestMode() {
        return this.m_clientIsInTestMode;
    }

    public void setClientIsInTestMode(boolean clientIsInTestMode) {
        this.m_clientIsInTestMode = clientIsInTestMode;
    }

    public String getCurrentServerRequestId() {
        return this.m_currentServerRequestId;
    }

    public void setCurrentServerRequestId(String value) {
        this.m_currentServerRequestId = value;
    }

    public String getLastServerRequestId() {
        return this.m_lastServerRequestId;
    }

    public void setLastServerRequestId(String value) {
        this.m_lastServerRequestId = value;
    }

    public void setLastProcessedRequestId(String value) {
        this.m_lastProcessedRequestId = value;
    }

    public String getLastProcessedRequestId() {
        return this.m_lastProcessedRequestId;
    }

    public int getNagleResponseSize() {
        return this.m_nagleResponseSize;
    }

    public void setNagleResponseSize(int nagleResponseSize) {
        this.m_nagleResponseSize = nagleResponseSize;
    }

    public long getHtHighestFocusCounter() {
        return this.m_htHighestFocusCounter;
    }

    public void setHtHighestFocusCounter(long htHighestFocusCounter) {
        this.m_htHighestFocusCounter = htHighestFocusCounter;
    }

    public boolean getProfileMode() {
        return this.m_profileMode;
    }

    public void setProfileMode(boolean profileMode) {
        this.m_profileMode = profileMode;
    }

    public Map<String, String> getInitialURLParameters() {
        return this.m_initialURLParameters;
    }

    public String getClientStartURL() {
        return this.m_clientStartURL;
    }

    public String getBufferedClientId() {
        return this.m_bufferedClientId;
    }

    public void bufferClientIdAtEndOfFacesRequest() {
        String currentClientId;
        this.m_bufferedClientId = currentClientId = HttpSessionAccess.getCurrentClientId(false);
    }

    private void transferDataFromHttpHeader(HttpServletRequest request) {
        if (request == null) {
            return;
        }
        if (this.m_dataFromHttpHeaderTransferred) {
            return;
        }
        try {
            String clientStartURL;
            String clientTimeZoneOffset = request.getHeader("eclnt-timezoneoffset");
            if (clientTimeZoneOffset != null) {
                this.m_clientTimeZoneOffset = ValueManager.decodeInt(clientTimeZoneOffset, 0);
            }
            if ((clientStartURL = request.getHeader("eclnt-originalurl")) != null) {
                this.m_clientStartURL = clientStartURL;
            }
            this.m_dataFromHttpHeaderTransferred = true;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem transferring parameters from http header", t);
        }
    }

    private void initSessionInfo(HttpServletRequest request) {
        this.transferDataFromHttpHeader(request);
        if (request == null) {
            request = HttpSessionAccess.getCurrentRequest();
        }
        boolean isRiscRequest = HttpSessionAccess.checkIfCurrentClientTypeIsRisc(request);
        this.transferInitializationDefaults(request, isRiscRequest);
        CLog.L.log(CLog.LL_INF, "Default information assigned to this new session info is: Style: " + this.m_style + " / Language: " + this.m_startLanguage + " / Country: " + this.m_startCountry + " / TakeoverClientLocaleSettings: " + this.m_takeOverClientLocaleSettings);
    }

    private void transferInitializationDefaults(HttpServletRequest request, boolean isRiscRequest) {
        try {
            CLog.L.log(CLog.LL_INF, "Initializing session info");
            SessionDefaultsParser sdp = SessionInfo.readSessionDefaultsFromConfiguration();
            if (sdp != null) {
                if (sdp.i_language != null) {
                    this.m_startLanguage = sdp.i_language;
                }
                if (sdp.i_country != null) {
                    this.m_startCountry = sdp.i_country;
                }
                if (sdp.i_style != null) {
                    this.m_style = sdp.i_style;
                }
                if (isRiscRequest) {
                    if (this.m_style == null) {
                        this.m_style = "defaultrisc";
                    }
                    if (sdp.i_riscStyle != null) {
                        this.m_style = sdp.i_riscStyle;
                    }
                }
                this.m_startClienttimezone = sdp.i_clienttimezone;
                this.m_startClientlanguage = sdp.i_clientlanguage;
                this.m_startClientcountry = sdp.i_clientcountry;
                this.m_takeOverClientLocaleSettings = sdp.i_takeOverClientLocaleSettings;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (s_sessionDefaultsProvider != null && s_sessionDefaultsProvider.instance() != null) {
            s_sessionDefaultsProvider.instance().initializeSessionInfo(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SessionDefaultsParser readSessionDefaultsFromConfiguration() {
        if (!s_sessionDefaultsParserRead) {
            Object object = s_sessionDefaultsParserSyncher;
            synchronized (object) {
                if (!s_sessionDefaultsParserRead) {
                    s_sessionDefaultsParserRead = true;
                    try {
                        CLog.L.log(CLog.LL_INF, "Initializing session info");
                        String xml = ConfigFileReader.readConfigFile("/eclntjsfserver/config/sessiondefaults.xml", true);
                        if (xml != null) {
                            SessionDefaultsParser sdp = new SessionDefaultsParser();
                            SAXParserUtil.parse(xml, (DefaultHandler)sdp);
                            s_sessionDefaultsParser = sdp;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        return s_sessionDefaultsParser;
    }

    public static String getSessionDefaultStyleForJavaClient() {
        SessionDefaultsParser sdp = SessionInfo.readSessionDefaultsFromConfiguration();
        if (sdp != null && sdp.i_style != null) {
            return sdp.i_style;
        }
        return "default";
    }

    public static String getSessionDefaultStyleForRISCClient() {
        SessionInfo sessionInfo = SessionInfo.createSessionInfoForRiscStarter();
        return sessionInfo.getStyle();
    }

    public String getClientJavaType() {
        return this.m_clientJavaType;
    }

    public void setClientJavaType(String clientJavaType) {
        this.m_clientJavaType = clientJavaType;
        if (this.m_style == null) {
            this.m_style = "fx".equals(this.m_clientJavaType) ? "defaultfx" : "default";
        }
    }

    public int getClientTimeZoneOffset() {
        return this.m_clientTimeZoneOffset;
    }

    public void setClientTimeZoneOffset(int clientTimeZoneOffset) {
        this.m_clientTimeZoneOffset = clientTimeZoneOffset;
    }

    static {
        s_sessionDefaultsParserRead = false;
        s_sessionDefaultsParser = null;
        s_sessionDefaultsParserSyncher = new Object();
    }

    static class SessionDefaultsParser
    extends DefaultHandler {
        String i_style;
        String i_riscStyle;
        String i_language;
        String i_country;
        String i_clienttimezone;
        String i_clientlanguage;
        String i_clientcountry;
        boolean i_takeOverClientLocaleSettings;

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, name, attributes);
            if (name.equals("sessiondefaults")) {
                String clientcountry;
                String clientlanguage;
                String clienttimezone;
                String country;
                String language;
                String riscStyle;
                String style = attributes.getValue("style");
                if (style != null) {
                    this.i_style = style;
                }
                if ((riscStyle = attributes.getValue("riscstyle")) != null) {
                    this.i_riscStyle = riscStyle;
                }
                if ((language = attributes.getValue("language")) != null) {
                    this.i_language = language;
                }
                if ((country = attributes.getValue("country")) != null) {
                    this.i_country = country;
                }
                if ((clienttimezone = attributes.getValue("clienttimezone")) != null) {
                    this.i_clienttimezone = clienttimezone;
                }
                if ((clientlanguage = attributes.getValue("clientlanguage")) != null) {
                    this.i_clientlanguage = clientlanguage;
                }
                if ((clientcountry = attributes.getValue("clientcountry")) != null) {
                    this.i_clientcountry = clientcountry;
                }
                this.i_takeOverClientLocaleSettings = ValueManager.decodeBoolean(attributes.getValue("takeoverclientlocalesettings"), false);
            }
        }

        public String getStyle() {
            return this.i_style;
        }

        public String getRiscStyle() {
            return this.i_riscStyle;
        }

        public String getLanguage() {
            return this.i_language;
        }

        public String getCountry() {
            return this.i_country;
        }

        public String getClienttimezone() {
            return this.i_clienttimezone;
        }

        public String getClientlanguage() {
            return this.i_clientlanguage;
        }

        public String getClientcountry() {
            return this.i_clientcountry;
        }

        public boolean isTakeOverClientLocaleSettings() {
            return this.i_takeOverClientLocaleSettings;
        }
    }
}

