/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.streamstore;

import java.util.List;
import org.eclnt.jsfserver.streamstore.IStreamStore;
import org.eclnt.jsfserver.streamstore.IStreamStoreWithBinary;
import org.eclnt.util.valuemgmt.Base64;

public class StreamStoreWithBinaryWrapper
implements IStreamStoreWithBinary {
    private IStreamStore m_stringInstance;

    public StreamStoreWithBinaryWrapper(IStreamStore stringInstance) {
        if (stringInstance == null) {
            throw new Error("stringInstance of IStreamStore must no be passed as null");
        }
        this.m_stringInstance = stringInstance;
    }

    public IStreamStore getStringInstance() {
        return this.m_stringInstance;
    }

    @Override
    public List<String> getContainedStreams(String path, boolean withError) {
        return this.m_stringInstance.getContainedStreams(path, withError);
    }

    @Override
    public List<String> getContainedFolders(String path, boolean withError) {
        return this.m_stringInstance.getContainedFolders(path, withError);
    }

    @Override
    public String readUTF8(String path, boolean withError) {
        return this.m_stringInstance.readUTF8(path, withError);
    }

    @Override
    public void writeUTF8(String path, String xml, boolean withError) {
        this.m_stringInstance.writeUTF8(path, xml, withError);
    }

    @Override
    public void removeStream(String path, boolean withError) {
        this.m_stringInstance.removeStream(path, withError);
    }

    @Override
    public boolean checkIfStreamExists(String path, boolean withError) {
        return this.m_stringInstance.checkIfStreamExists(path, withError);
    }

    @Override
    public byte[] readData(String path, boolean withError) {
        try {
            String result = this.readUTF8(path, withError);
            return Base64.decode(result);
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Could not read data: " + path);
            }
            return null;
        }
    }

    @Override
    public void writeData(String path, byte[] data, boolean withError) {
        block2: {
            try {
                String dataString = Base64.encode(data);
                this.writeUTF8(path, dataString, withError);
            }
            catch (Throwable t) {
                if (!withError) break block2;
                throw new Error("Could not read data: " + path);
            }
        }
    }
}

