/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.tools;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.SchemaOutputResolver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.workplace.WorkplaceFunctionTreeInfoNode;
import org.eclnt.workplace.WorkplaceTileInfo;
import org.eclnt.workplace.WorkplaceUserInfo;

public class XSDSchemaGenerator {
    static String s_ownDir = "C:/bmu_jtc/git/eclnt_jsfserver/";
    static String s_centralDir = "C:/bmu_web/xsd/";

    public static void main(String[] args) {
        if (args.length >= 2) {
            s_ownDir = ValueManager.encodeIntoValidFileName(args[0], true);
            s_centralDir = ValueManager.encodeIntoValidFileName(args[1], true);
        }
        XSDSchemaGenerator.generateWorkplaceTileInfoSchema();
        XSDSchemaGenerator.generateWorkplaceFuncTionTreeInfoSchema();
        XSDSchemaGenerator.generateWorkplaceUserInfoSchema();
        System.out.println("--- finished ---");
    }

    public static void generateWorkplaceTileInfoSchema() {
        try {
            JAXBContext jbContext = JAXBContext.newInstance((Class[])new Class[]{WorkplaceTileInfo.class});
            MySchemaOutputResolver or = new MySchemaOutputResolver();
            or.createOutput("cc1", "WorkplaceTileInfo");
            jbContext.generateSchema((SchemaOutputResolver)or);
            String xsdContent = new String(or.i_bos.toByteArray());
            FileManager.writeUTF8File(s_centralDir + "WorkplaceTileInfo.xsd", xsdContent, true);
            FileManager.writeUTF8File(s_ownDir + "src/org/eclnt/xsdresources/WorkplaceTileInfo.xsd", xsdContent, true);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error(t);
        }
    }

    public static void generateWorkplaceFuncTionTreeInfoSchema() {
        try {
            JAXBContext jbContext = JAXBContext.newInstance((Class[])new Class[]{WorkplaceFunctionTreeInfoNode.class});
            MySchemaOutputResolver or = new MySchemaOutputResolver();
            or.createOutput("cc1", "WorkplaceTileInfo");
            jbContext.generateSchema((SchemaOutputResolver)or);
            String xsdContent = new String(or.i_bos.toByteArray());
            FileManager.writeUTF8File(s_centralDir + "WorkplaceFunctionTreeInfoNode.xsd", xsdContent, true);
            FileManager.writeUTF8File(s_ownDir + "src/org/eclnt/xsdresources/WorkplaceFunctionTreeInfoNode.xsd", xsdContent, true);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error(t);
        }
    }

    public static void generateWorkplaceUserInfoSchema() {
        try {
            JAXBContext jbContext = JAXBContext.newInstance((Class[])new Class[]{WorkplaceUserInfo.class});
            MySchemaOutputResolver or = new MySchemaOutputResolver();
            or.createOutput("cc1", "WorkplaceTileInfo");
            jbContext.generateSchema((SchemaOutputResolver)or);
            String xsdContent = new String(or.i_bos.toByteArray());
            FileManager.writeUTF8File(s_centralDir + "WorkplaceUserInfo.xsd", xsdContent, true);
            FileManager.writeUTF8File(s_ownDir + "eclnt_jsfserver/src/org/eclnt/xsdresources/WorkplaceUserInfo.xsd", xsdContent, true);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error(t);
        }
    }

    static class MySchemaOutputResolver
    extends SchemaOutputResolver {
        ByteArrayOutputStream i_bos = new ByteArrayOutputStream();
        String i_result;

        MySchemaOutputResolver() {
        }

        public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
            StreamResult result = new StreamResult(this.i_bos);
            result.setSystemId("dummy");
            return result;
        }
    }
}

