/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import jakarta.servlet.ServletContext;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.List;
import org.eclnt.jsfserver.util.IBootstrap;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.classresolver.ENUMCallerType;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.valuemgmt.JAXBManager;

public class CCInitializeBootstrap {
    public static final String BOOTSTRAP_FILENAME = "ccbootstrap.xml";

    public static void bootstrap(ServletContext servletContext) {
        ClassloaderReader clr = new ClassloaderReader();
        List<String> xmls = clr.readUTF8Files(BOOTSTRAP_FILENAME, false);
        for (String xml : xmls) {
            CCInitializeBootstrap.processBootStrapXML(xml, servletContext);
        }
    }

    private static void processBootStrapXML(String xml, ServletContext servletContext) {
        try {
            if (xml == null) {
                return;
            }
            if (xml.trim().length() == 0) {
                return;
            }
            BootstrapInfo bsi = (BootstrapInfo)JAXBManager.unmarshal(xml, BootstrapInfo.class);
            if (bsi != null && bsi.getClassName() != null && bsi.getClassName().trim().length() != 0) {
                Class clazz = CCClassResolver.resolveClass(bsi.getClassName(), ENUMCallerType.CONFIGURATION);
                IBootstrap bs = (IBootstrap)clazz.newInstance();
                bs.startUp(servletContext);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error("Error during processing of BootStrap: " + xml, t);
        }
    }

    @XmlRootElement(name="bootstrap")
    public static class BootstrapInfo {
        String i_className;

        @XmlAttribute(name="class")
        public String getClassName() {
            return this.i_className;
        }

        public void setClassName(String className) {
            this.i_className = className;
        }
    }
}

