/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import com.veracode.annotation.FilePathCleanser;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclnt.jsfserver.configuration.CCConfigurationObjectLoader;
import org.eclnt.jsfserver.elements.macros.MacroFactory;
import org.eclnt.jsfserver.onlinehelp.OnlineHelpConfiguration;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.InitEclntJsfServerSLF4JBridge;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.VersionXml;
import org.eclnt.jsfserver.util.parse.SAXParserUtil;
import org.eclnt.util.file.ConfigFileReader;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.log.CLogDelegatingHandler;
import org.eclnt.util.log.CLogFormatter;
import org.eclnt.util.log.CLogLogger;
import org.eclnt.util.log.ILogInfoProvider;
import org.eclnt.util.log.ILogOutput;
import org.eclnt.util.log.PLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class InitEclntJsfServer {
    private static Level s_logLevel = CLog.LL_INF;
    private static boolean s_log2Console = false;
    private static boolean s_plainText = false;
    private static boolean s_logOuptutclassmethod = false;
    private static boolean s_log2File = true;
    private static String s_logDirectory = null;
    private static String s_loginfoproviderclassname = null;
    private static int s_logLimit = 10000000;
    private static int s_logCount = 5;
    private static String s_logDelegateclassname = null;
    private static boolean s_logUseParentHandlers = false;
    public static Level s_logLevelMissingPropertyGet = CLog.LL_WAR;
    public static boolean s_logStacktraceMissingPropertyGet = false;
    public static boolean s_logUseSLF4JBridge = false;
    public static boolean s_logSLF4JRemoveHandlersForRootLogger = false;
    public static boolean s_logSLF4JPlainText = false;
    public static boolean s_loggingDelegationProcessed = false;

    public static boolean getLogOutputClassMethod() {
        return s_logOuptutclassmethod;
    }

    public static String getLogDirectory() {
        return s_logDirectory;
    }

    public static void outputInitBeginStatement(ServletContext servletContext) {
        CLog.L.log(CLog.LL_INF, "***********************************************************");
        CLog.L.log(CLog.LL_INF, "* INITIALIZATION of Enterprise Client Server Environment. ");
        CLog.L.log(CLog.LL_INF, "* Context path: " + servletContext.getContextPath());
        CLog.L.log(CLog.LL_INF, "*                                                         ");
        try {
            CLog.L.log(CLog.LL_INF, "* Logging directory: " + s_logDirectory);
            if (s_logDirectory != null) {
                File f = FileManager.createFileInstance(s_logDirectory);
                CLog.L.log(CLog.LL_INF, "*                    " + f.getCanonicalPath());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            CLog.L.log(CLog.LL_INF, "* Temp    directory: " + HttpSessionAccess.getServletTempDirectory());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CLog.L.log(CLog.LL_INF, "***********************************************************");
        CLog.L.log(CLog.LL_INF, "* Java version : " + System.getProperty("java.version"));
        CLog.L.log(CLog.LL_INF, "* Max heap size: " + Runtime.getRuntime().maxMemory());
        CLog.L.log(CLog.LL_INF, "***********************************************************");
    }

    public static void outputInitEndStatement(ServletContext servletContext) {
        CLog.L.log(CLog.LL_INF, "***********************************************************");
        CLog.L.log(CLog.LL_INF, "* INITIALIZATION finished");
        CLog.L.log(CLog.LL_INF, "***********************************************************");
    }

    public static void init(ServletContext servletContext) {
        InitEclntJsfServer.initVersion(servletContext);
        InitEclntJsfServer.initCleanupWorkDirectory(servletContext);
        InitEclntJsfServer.initFileManagerSecurity(servletContext);
        CLog.L.log(CLog.LL_INF, "***********************************************************");
        CLog.L.log(CLog.LL_INF, "* Initialize Macros");
        InitEclntJsfServer.initOnlineHelp(servletContext);
        InitEclntJsfServer.initLoggingDelegation(servletContext);
        InitEclntJsfServer.initMacros(servletContext);
    }

    public static void reinitLogging(ServletContext servletContext) {
        InitEclntJsfServerSLF4JBridge.resetInitialization();
        InitEclntJsfServer.initLogging(servletContext);
    }

    public static void initLogging(ServletContext servletContext) {
        try {
            FileHandler fh;
            String loggingXML = ConfigFileReader.readConfigFile("/eclntjsfserver/config/logging.xml", true);
            if (loggingXML != null) {
                try {
                    SAXParserUtil.parse(loggingXML, (DefaultHandler)new LoggingXMLParser());
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "Error when parsing logging.xml", t);
                }
            }
            CLog.L.setLevel(s_logLevel);
            CLogFormatter.init(s_logOuptutclassmethod);
            Handler[] currentHandlers = CLog.L.getHandlers();
            for (int i = 0; i < currentHandlers.length; ++i) {
                CLog.L.removeHandler(currentHandlers[i]);
            }
            CLog.L.setUseParentHandlers(false);
            CLog.L.log(CLog.LL_INF, "initializing the logging");
            if (s_logUseParentHandlers) {
                try {
                    CLog.L.setUseParentHandlers(true);
                }
                catch (Throwable i) {
                    // empty catch block
                }
            }
            if (s_log2File) {
                try {
                    if (s_logDirectory == null) {
                        s_logDirectory = InitEclntJsfServer.findLogDirectoryByLogInfoProvider();
                    }
                    if (s_logDirectory == null) {
                        s_logDirectory = ((File)servletContext.getAttribute("jakarta.servlet.context.tempdir")).getAbsolutePath();
                    }
                    s_logDirectory = ValueManager.encodeIntoValidFileName(s_logDirectory, true);
                    FileManager.ensureDirectoryExists(s_logDirectory);
                    String logName = s_logDirectory + "log_eclntjsfserver.txt";
                    CLog.L.log(CLog.LL_INF, "initializing the logging - logfile = " + logName);
                    fh = InitEclntJsfServer.createFileHandler(logName, s_logLevel);
                    CLog.L.addHandler(fh);
                    InitEclntJsfServer.outputLogLocationInfo(servletContext);
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_WAR, "Logging to the file system is not possible: " + t, t);
                }
            }
            PLog.L.setLevel(PLog.LL_INF);
            try {
                if (s_logDirectory == null) {
                    s_logDirectory = InitEclntJsfServer.findLogDirectoryByLogInfoProvider();
                }
                if (s_logDirectory == null) {
                    s_logDirectory = ((File)servletContext.getAttribute("jakarta.servlet.context.tempdir")).getAbsolutePath();
                }
                s_logDirectory = ValueManager.encodeIntoValidFileName(s_logDirectory, true);
                FileManager.ensureDirectoryExists(s_logDirectory);
                String logName = s_logDirectory + "log_performance.txt";
                CLog.L.log(CLog.LL_INF, "initializing the performance logging - logfile = " + logName);
                fh = InitEclntJsfServer.createFileHandler(logName, PLog.LL_INF);
                PLog.L.addHandler(fh);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_WAR, "Problem when initializing performance log: " + t);
            }
            CLog.L.setPlainText(s_plainText);
            if (s_log2Console) {
                CLog.addConsoleHandler();
            }
            CLog.L.setLevel(s_logLevel);
            if (s_log2Console) {
                CLog.L.log(CLog.LL_WAR, "***********************************************************");
                CLog.L.log(CLog.LL_WAR, "* CONSOLE LOGGING is switched on - due to defintion in logging.xml");
                CLog.L.log(CLog.LL_WAR, "*                 By default console logging is done to System.err.");
                CLog.L.log(CLog.LL_WAR, "*                 The Java Logger does not allow to properly change");
                CLog.L.log(CLog.LL_WAR, "*                 this.");
                CLog.L.log(CLog.LL_WAR, "*                 Please DO NOT USE console logging for productive");
                CLog.L.log(CLog.LL_WAR, "*                 scenarios!");
                CLog.L.log(CLog.LL_WAR, "***********************************************************");
            }
            if (s_logUseSLF4JBridge) {
                try {
                    InitEclntJsfServerSLF4JBridge.initialize(s_logSLF4JRemoveHandlersForRootLogger);
                    CLog.L = new CLogLogger(Logger.getLogger("org.eclnt.serverlog.VIASLF4J"), s_logSLF4JPlainText);
                    PLog.L = new CLogLogger(Logger.getLogger("org.eclnt.serverperformancelog.VIASLF4J"), s_logSLF4JPlainText);
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "Problem when initializing and adding SLF4JBridge", t);
                }
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error when initializing the logging.", t);
            System.out.println("CC: Problem when initializing the logging");
            t.printStackTrace();
        }
    }

    private static void outputLogLocationInfo(ServletContext servletContext) {
        InitEclntJsfServer.outputLogLocationInfoToServletContextLog(servletContext);
        InitEclntJsfServer.outputLocLocationInfoToTomcatLogs(servletContext);
    }

    @FilePathCleanser(userComment="Opens up a log file handler to write into a certain file. The file name is defined as part of the configuration (i.e. it is not influenced by user input). In addition it is checked by the FileManager to be part of a white list of directories and that it does not contain any \"..\"-navigation.")
    private static FileHandler createFileHandler(String logName, Level logLevel) throws SecurityException, IOException {
        FileHandler fh = new FileHandler(logName, s_logLimit, s_logCount);
        fh.setFormatter(new CLogFormatter());
        fh.setLevel(logLevel);
        return fh;
    }

    public static void initLoggingDelegation(ServletContext servletContext) {
        if (s_loggingDelegationProcessed) {
            return;
        }
        try {
            if (s_logDelegateclassname != null) {
                try {
                    ILogOutput lo = (ILogOutput)CCConfigurationObjectLoader.instance().loadInstance(s_logDelegateclassname, true);
                    CLogDelegatingHandler handler = new CLogDelegatingHandler(lo);
                    CLog.L.addHandler(handler);
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "Problem occurred when creating the log delegation instance", t);
                }
            }
            s_loggingDelegationProcessed = true;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error when initializing the logging delegation.", t);
        }
    }

    private static void initCleanupWorkDirectory(ServletContext servletContext) {
        try {
            File f = (File)servletContext.getAttribute("jakarta.servlet.context.tempdir");
            String dirName = ValueManager.encodeIntoValidFileName(f.getAbsolutePath(), true);
            CLog.L.log(CLog.LL_INF, "***********************************************************");
            CLog.L.log(CLog.LL_INF, "* Clean up temp-org/apache/jsp directory of web application");
            String cleanDirName = ValueManager.encodeIntoValidFileName(f.getAbsolutePath(), true) + "org/apache/jsp";
            if (FileManager.checkIfFileExists(cleanDirName)) {
                CLog.L.log(CLog.LL_INF, "* Temp directory is: " + dirName);
                CLog.L.log(CLog.LL_INF, "* Cleaned directory is: " + cleanDirName);
                FileManager.deleteDirectoryContent(cleanDirName);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_WAR, "Problem when cleaning: " + t.toString(), t);
        }
        CLog.L.log(CLog.LL_INF, "***********************************************************");
    }

    private static void initVersion(ServletContext servletContext) {
        try {
            VersionXml.init(servletContext);
            CLog.L.log(CLog.LL_INF, "***********************************************************");
            CLog.L.log(CLog.LL_INF, "CaptainCasa Enterprise Client Version: " + VersionXml.getVersion());
            CLog.L.log(CLog.LL_INF, "***********************************************************");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void initMacros(ServletContext servletContext) {
        MacroFactory.initializeWebappInstance(servletContext);
    }

    private static void initOnlineHelp(ServletContext servletContext) {
        OnlineHelpConfiguration.initialize(servletContext);
    }

    private static void initFileManagerSecurity(ServletContext servletContext) {
        String dirName;
        List<SystemXml.FileManagerReadAccess> ras = SystemXml.getFileManagerReadAccessDirectories();
        for (SystemXml.FileManagerReadAccess ra : ras) {
            try {
                dirName = InitEclntJsfServer.updateDirectoryName(ra.getDirectory(), servletContext);
                FileManager.addAllowedRootDirectoryRead(dirName);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Could not add file manager access directory: " + ra.getDirectory());
            }
        }
        List<SystemXml.FileManagerWriteAccess> was = SystemXml.getFileManagerWriteAccessDirectories();
        for (SystemXml.FileManagerWriteAccess wa : was) {
            try {
                dirName = InitEclntJsfServer.updateDirectoryName(wa.getDirectory(), servletContext);
                FileManager.addAllowedRootDirectoryReadWrite(dirName);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Could not add file manager access directory: " + wa.getDirectory());
            }
        }
    }

    public static String updateDirectoryName(String directory, ServletContext servletContext) {
        if (directory == null) {
            return null;
        }
        if (directory.startsWith("${temp}")) {
            try {
                String tempDirName = FileManager.getTempFileDirectory().getAbsolutePath();
                return directory.replace("${temp}", tempDirName);
            }
            catch (Throwable t) {
                throw new Error("Could not be resolved!");
            }
        }
        if (directory.startsWith("${servlettemp}")) {
            try {
                String tempDirName = HttpSessionAccess.getServletTempDirectory(servletContext);
                return directory.replace("${servlettemp}", tempDirName);
            }
            catch (Throwable t) {
                throw new Error("Could not be resolved!");
            }
        }
        if (directory.startsWith("${servletwebapp}")) {
            try {
                String tempDirName = servletContext.getRealPath("/");
                if (tempDirName != null) {
                    return directory.replace("${servletwebapp}", tempDirName);
                }
            }
            catch (Throwable t) {
                throw new Error("Could not be resolved!");
            }
        }
        return directory;
    }

    private static String findLogDirectoryByLogInfoProvider() {
        try {
            if (s_loginfoproviderclassname == null) {
                return null;
            }
            ILogInfoProvider lip = (ILogInfoProvider)CCConfigurationObjectLoader.instance().loadInstance(s_loginfoproviderclassname, true);
            return lip.getLogDirectory();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static void outputLocLocationInfoToTomcatLogs(ServletContext servletContext) {
        try {
            int index;
            String logsPath;
            String realPath = servletContext.getRealPath("test.test");
            realPath = ValueManager.encodeIntoValidFileName(realPath, false);
            if (realPath.contains("/webapps/") && FileManager.checkIfFileExists(logsPath = realPath.substring(0, index = realPath.lastIndexOf("/webapps/")) + "/logs")) {
                String text = "----------------------------------------------------------------\nCaptainCasa - Application     : " + servletContext.getContextPath() + "\nLogging is done into directory: " + s_logDirectory + "\nName of log files             : log_eclntjsfserver.txt.*\nName of performance log files : log_performance.txt.*\n----------------------------------------------------------------";
                String contextPath = servletContext.getContextPath();
                contextPath = contextPath.replace("/", "");
                String infoFileName = logsPath + "/CaptainCasaLogInfo_" + contextPath + ".txt";
                infoFileName = ValueManager.encodeIntoValidFileName(infoFileName, false);
                FileManager.writeUTF8File(infoFileName, text, false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void outputLogLocationInfoToServletContextLog(ServletContext servletContext) {
        try {
            servletContext.log("**CC** ----------------------------------------------------------------");
            servletContext.log("**CC** CaptainCasa - Application     : " + servletContext.getContextPath());
            servletContext.log("**CC** Logging is done into directory: " + s_logDirectory);
            servletContext.log("**CC** Name of log files             : log_eclntjsfserver.txt.*");
            servletContext.log("**CC** Name of performance log files : log_performance.txt.*");
            servletContext.log("**CC** ----------------------------------------------------------------");
        }
        catch (Throwable tt) {
            CLog.L.log(CLog.LL_INF, "Problem writing message into servlet context's log: " + tt, tt);
        }
    }

    static class LoggingXMLParser
    extends DefaultHandler {
        LoggingXMLParser() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, name, attributes);
            if (name.equals("logging")) {
                String logUseParentHandlers;
                String logLimit;
                String logDirectory;
                String outputclassmethod;
                String file;
                String plainText;
                String console;
                String level = attributes.getValue("level");
                if (level != null) {
                    s_logLevel = Level.parse(level);
                }
                if ((console = attributes.getValue("console")) != null) {
                    s_log2Console = ValueManager.decodeBoolean(console, false);
                }
                if ((plainText = attributes.getValue("plaintext")) != null) {
                    s_plainText = ValueManager.decodeBoolean(plainText, false);
                }
                if ((file = attributes.getValue("file")) != null) {
                    s_log2File = ValueManager.decodeBoolean(file, true);
                }
                if ((outputclassmethod = attributes.getValue("outputclassmethod")) != null) {
                    s_logOuptutclassmethod = ValueManager.decodeBoolean(outputclassmethod, false);
                }
                if ((logDirectory = attributes.getValue("directory")) != null) {
                    s_logDirectory = ValueManager.convertFileNameToCanonical(logDirectory, true);
                }
                s_loginfoproviderclassname = attributes.getValue("loginfoproviderclassname");
                String logCount = attributes.getValue("count");
                if (logCount != null) {
                    s_logCount = ValueManager.decodeInt(logCount, 5);
                    if (s_logCount <= 0) {
                        s_logCount = 5;
                    }
                }
                if ((logLimit = attributes.getValue("limit")) != null) {
                    s_logLimit = ValueManager.decodeInt(logLimit, 10000000);
                    if (s_logLimit <= 0) {
                        s_logLimit = 10000000;
                    }
                }
                if ((logUseParentHandlers = attributes.getValue("useparenthandlers")) != null) {
                    s_logUseParentHandlers = ValueManager.decodeBoolean(logUseParentHandlers, false);
                }
                s_logDelegateclassname = attributes.getValue("delegateclassname");
                String s = attributes.getValue("useslf4jbridge");
                if ("true".equals(s)) {
                    s_logUseSLF4JBridge = true;
                }
                if ("true".equals(s = attributes.getValue("slf4jremovehandlersforrootlogger"))) {
                    s_logSLF4JRemoveHandlersForRootLogger = true;
                }
                if ("true".equals(s = attributes.getValue("slf4jplaintext"))) {
                    s_logSLF4JPlainText = true;
                }
            } else if (name.equals("loglevelmissingpropertyget")) {
                String st;
                String level = attributes.getValue("level");
                if (level != null) {
                    s_logLevelMissingPropertyGet = Level.parse(level);
                }
                if ((st = attributes.getValue("stacktrace")) != null) {
                    s_logStacktraceMissingPropertyGet = ValueManager.decodeBoolean(st, false);
                }
            }
        }
    }
}

