/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclnt.editor.tools.ProjectInfo;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;

public class StyleDesignTimeCopier {
    String m_uuid = UniqueIdCreator.createUUID();
    String m_baseDirectory = null;
    ProjectInfo m_projectInfo;
    boolean m_styleIsCopied = false;

    public StyleDesignTimeCopier(ProjectInfo projectInfo) {
        this.m_projectInfo = projectInfo;
    }

    public List<String> getCopiedStyleNames() {
        this.createStyleCopy();
        List<File> dirs = FileManager.getDirectoriesOfDirectory(this.m_baseDirectory);
        ArrayList<String> result = new ArrayList<String>();
        for (File dir : dirs) {
            result.add(dir.getName());
        }
        return result;
    }

    public String getBaseDirectoryName() {
        this.createStyleCopy();
        return this.m_baseDirectory;
    }

    public String getStyleXmlFileName(String styleName) {
        this.createStyleCopy();
        return this.m_baseDirectory + styleName + "/style.xml";
    }

    public String getStyleDirectoryName(String styleName) {
        return this.m_baseDirectory + styleName + "/";
    }

    private void createStyleCopy() {
        if (this.m_styleIsCopied) {
            return;
        }
        this.m_baseDirectory = HttpSessionAccess.getServletTempDirectory() + "/editor/stylecopy/" + this.m_uuid + "/" + this.m_projectInfo.getName() + "/";
        this.m_baseDirectory = ValueManager.encodeIntoValidFileName(this.m_baseDirectory, true);
        ClassLoader cl = this.m_projectInfo.getCurrentDesignTimeIndependentClassLoader();
        if (cl == null) {
            throw new Error("Classloader is not set in current project info: " + this.m_projectInfo.getName());
        }
        ClassloaderReader clr = new ClassloaderReader(cl);
        Set<String> styleNames = clr.getDirectories("/eclntjsfserver/styles/");
        for (String styleName : styleNames) {
            Set<String> fileNames = clr.getFilesInPathDirectory("/eclntjsfserver/styles/" + styleName);
            for (String fileName : fileNames) {
                byte[] content;
                if (!fileName.endsWith(".xml") || (content = clr.readFile("/eclntjsfserver/styles/" + styleName + "/" + fileName, false)) == null || content.length <= 0) continue;
                String copyFileName = this.m_baseDirectory + styleName + "/" + fileName;
                FileManager.ensureDirectoryForFileExists(copyFileName);
                FileManager.writeFile(copyFileName, content, true);
            }
        }
        this.m_styleIsCopied = true;
    }
}

