/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.references;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import org.eclnt.util.log.CLog;

public class ReferenceMgr {
    static ReferenceMgr s_instance = new ReferenceMgr();
    long m_referenceCounter = 0L;
    Hashtable<Long, MyWeakReference> m_objects = new Hashtable();
    ReferenceQueue<Object> m_referenceQueue = new ReferenceQueue();
    long m_cleanUpThreadInterval = 5000L;

    private ReferenceMgr() {
        new MyCleanUpThread().start();
    }

    public static ReferenceMgr getInstance() {
        return s_instance;
    }

    public long getCleanUpThreadInterval() {
        return this.m_cleanUpThreadInterval;
    }

    public void setCleanUpThreadInterval(long cleanUpThreadInterval) {
        this.m_cleanUpThreadInterval = cleanUpThreadInterval;
    }

    public long registerObject(Object o) {
        long key = this.increaseReferenceCounter();
        MyWeakReference ref = new MyWeakReference(key, o);
        this.m_objects.put(key, ref);
        return key;
    }

    public Object getRegisteredObject(long key) {
        MyWeakReference ref = this.m_objects.get(key);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    private synchronized void cleanUpReferences() {
        MyWeakReference ref;
        int cleanedReferences = 0;
        while ((ref = (MyWeakReference)this.m_referenceQueue.poll()) != null) {
            this.m_objects.remove(ref.i_key);
            ++cleanedReferences;
        }
        CLog.L.log(CLog.LL_INF, "ReferenceMgr - number of cleaned references: " + cleanedReferences);
    }

    private synchronized long increaseReferenceCounter() {
        ++this.m_referenceCounter;
        return this.m_referenceCounter;
    }

    class MyCleanUpThread
    extends Thread {
        MyCleanUpThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    MyCleanUpThread.sleep(ReferenceMgr.this.m_cleanUpThreadInterval);
                }
                catch (Throwable t) {
                    break;
                }
                ReferenceMgr.this.cleanUpReferences();
            }
        }
    }

    class MyWeakReference
    extends WeakReference<Object> {
        long i_key;

        public MyWeakReference(long key, Object o) {
            super(o, ReferenceMgr.this.m_referenceQueue);
            this.i_key = key;
        }
    }
}

