/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.webappfiles;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclnt.jsfserver.managedbean.DefaultHotDeployListener;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.managedbean.HotDeployNotifier;
import org.eclnt.jsfserver.util.WebResourceReader;
import org.eclnt.jsfserver.util.webappfiles.WebappDirectoryXML;
import org.eclnt.util.file.CLDirectoryInfo;
import org.eclnt.util.file.CLFileInfo;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class WebappDirectoryManager {
    static Object SYNCHER = new Object();
    public static final String WEBAPPDIRFILE_PATH = "/eclntdirectoryinfo.xml";
    static CLDirectoryInfo s_webAppDirectory;
    static Map<String, String> s_directoriesReadFromWebResources;
    static boolean s_initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        if (!s_initialized) {
            Object object = SYNCHER;
            synchronized (object) {
                if (!s_initialized) {
                    s_initialized = true;
                    CLog.L.log(CLog.LL_INF, "WebappDirectoryManager - Initialization begin");
                    s_webAppDirectory = WebappDirectoryManager.readCombinedFromClassloader(HotDeployManager.currentClassLoader());
                    s_directoriesReadFromWebResources.clear();
                    CLog.L.log(CLog.LL_INF, "WebappDirectoryManager - Initialization end");
                }
            }
        }
    }

    public static void reset() {
        s_initialized = false;
    }

    public static CLDirectoryInfo getRoot() {
        WebappDirectoryManager.initialize();
        return s_webAppDirectory;
    }

    public static List<String> getDirectories(String dirPath) {
        WebappDirectoryManager.initialize();
        dirPath = ValueManager.encodeIntoValidWebResourcePath(dirPath, true);
        WebappDirectoryManager.ensureDirPathIsFullyReadFromWebResources(dirPath);
        ArrayList<String> result = new ArrayList<String>();
        CLDirectoryInfo wad = s_webAppDirectory.findDirectory(dirPath);
        if (wad == null) {
            return result;
        }
        for (CLDirectoryInfo subWad : wad.getDirectories()) {
            result.add(subWad.getName());
        }
        return result;
    }

    public static List<String> getFiles(String dirPath) {
        WebappDirectoryManager.initialize();
        dirPath = ValueManager.encodeIntoValidWebResourcePath(dirPath, true);
        WebappDirectoryManager.ensureDirPathIsFullyReadFromWebResources(dirPath);
        ArrayList<String> result = new ArrayList<String>();
        CLDirectoryInfo wad = s_webAppDirectory.findDirectory(dirPath);
        if (wad == null) {
            return result;
        }
        for (CLFileInfo subWaf : wad.getFiles()) {
            result.add(subWaf.getName());
        }
        return result;
    }

    public static CLDirectoryInfo readCombinedFromClassloader(ClassLoader cl) {
        WebappDirectoryManager.initialize();
        List<CLDirectoryInfo> wads = WebappDirectoryManager.readAllFromClassloader(cl);
        if (wads.size() == 0) {
            return new CLDirectoryInfo("");
        }
        CLDirectoryInfo result = wads.get(0);
        for (int i = 1; i < wads.size(); ++i) {
            result.merge(wads.get(i));
        }
        return result;
    }

    private static List<CLDirectoryInfo> readAllFromClassloader(ClassLoader cl) {
        WebappDirectoryManager.initialize();
        CLog.L.log(CLog.LL_INF, "Reading class loader directory structure - begin");
        ClassloaderReader clr = new ClassloaderReader(true);
        List<URL> urls = clr.readResourcePaths(WEBAPPDIRFILE_PATH, false);
        ArrayList<CLDirectoryInfo> result = new ArrayList<CLDirectoryInfo>();
        for (URL url : urls) {
            CLog.L.log(CLog.LL_INF, "Adding/processing: " + url);
            String xml = clr.readURLContentAsUTF8(url, false);
            if (xml == null) continue;
            CLDirectoryInfo wad = WebappDirectoryXML.fromXML(xml);
            result.add(wad);
        }
        CLog.L.log(CLog.LL_INF, "Reading class loader directory structure - end");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureDirPathIsFullyReadFromWebResources(String dirPath) {
        if (s_directoriesReadFromWebResources.containsKey(dirPath)) {
            return;
        }
        Map<String, String> map = s_directoriesReadFromWebResources;
        synchronized (map) {
            if (s_directoriesReadFromWebResources.containsKey(dirPath)) {
                return;
            }
            CLDirectoryInfo di = new CLDirectoryInfo();
            List<String> wrDirs = WebResourceReader.getDirectoriesInPathDirectory(dirPath);
            for (String string : wrDirs) {
                di.getDirectories().add(new CLDirectoryInfo(string));
            }
            Set<String> wrFiles = WebResourceReader.getFilesInPathDirectory(dirPath);
            for (String wrFile : wrFiles) {
                di.getFiles().add(new CLFileInfo(wrFile));
            }
            if (di.getFiles().size() == 0 && di.getDirectories().size() == 0) {
                s_directoriesReadFromWebResources.put(dirPath, dirPath);
            } else {
                CLDirectoryInfo cLDirectoryInfo = s_webAppDirectory.ensureDirectoryExists(dirPath);
                cLDirectoryInfo.merge(di);
                s_directoriesReadFromWebResources.put(dirPath, dirPath);
            }
        }
    }

    static {
        s_directoriesReadFromWebResources = new ConcurrentHashMap<String, String>();
        s_initialized = false;
        HotDeployNotifier.addListener(new DefaultHotDeployListener(){

            @Override
            public void onClassLoaderUpdate(ClassLoader newClassLoader) {
                WebappDirectoryManager.reset();
            }
        });
    }
}

