/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.tool;

import org.eclnt.jsfserver.elements.tldsax.TLDAttribute;
import org.eclnt.jsfserver.elements.tldsax.TLDTag;
import org.eclnt.jsfserver.elements.tldsax.TLDTaglib;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.JAXBManager;

public class CreateXSDFromTLD {
    public static void main(String[] args) {
        try {
            String tldXml = FileManager.readUTF8File("C:\\bmu_jtc\\git\\eclnt_jsfserver\\WebContent\\WEB-INF\\eclnt.tld", true);
            String xsdXml = CreateXSDFromTLD.createXSDFromTLD("t", tldXml);
            FileManager.writeUTF8File("C:\\bmu_jtc\\git\\eclnt_jsfserver\\src\\org\\eclnt\\xsdresources\\eclnt.xsd", xsdXml, true);
            System.out.println(xsdXml);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static String createXSDFromTLD(String prefix, String tldXml) {
        StringBuffer all = new StringBuffer();
        TLDTaglib tld = (TLDTaglib)JAXBManager.unmarshal(tldXml, TLDTaglib.class);
        for (TLDTag tag : tld.getTags()) {
            if (tag.getName().startsWith("ui5")) continue;
            CreateXSDFromTLD.appendTag(all, tag);
        }
        String template = new ClassloaderReader().readUTF8File("org/eclnt/tool/resources/XSDForControlLibrary.xml.template", true);
        template = template.replace("${prefix}", prefix);
        template = template.replace("${content}", all.toString());
        return template;
    }

    private static void appendTag(StringBuffer all, TLDTag tag) {
        all.append("\n");
        all.append("    <xs:element name=\"" + tag.getName() + "\">\n");
        all.append("        <xs:complexType>\n");
        all.append("        <xs:sequence>\n");
        all.append("            <xs:any minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n");
        all.append("        </xs:sequence>\n");
        for (TLDAttribute att : tag.getAttributes()) {
            all.append("        <xs:attribute name=\"" + att.getName() + "\" type=\"xs:string\"/>\n");
        }
        all.append("        </xs:complexType>\n");
        all.append("    </xs:element>\n");
    }
}

