/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.tool;

import java.io.File;
import java.util.List;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.util.VersionXml;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class TransferPageBeanComponentJSPToXML {
    public static void main(String[] args) {
        try {
            VersionXml.overrideJakarta(false);
            if (args.length != 2) {
                throw new Exception("Wrong number of parameters!\nParam1 => fromDir\nParam2 => toDir");
            }
            String fromDir = args[0];
            String toDir = args[1];
            String protocol = TransferPageBeanComponentJSPToXML.transferDirectory(fromDir, toDir);
            System.out.println(protocol);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static String transferDirectory(String fromDir, String toDir) {
        StringBuffer sb = new StringBuffer();
        List<String> jspFileNames = FileManager.getFilesOfDirectoryByPattern(fromDir, ".jsp");
        int numberOfWrittenFiles = 0;
        sb.append("\n==============================================================");
        sb.append("\nTransfer from directory: " + fromDir);
        sb.append("\nTransfer to directory: " + toDir);
        sb.append("\nNumber of layout .jsp files: " + jspFileNames.size());
        sb.append("\n==============================================================");
        for (String jspFileName : jspFileNames) {
            TransferFileResult tfr = TransferPageBeanComponentJSPToXML.transferFile(jspFileName, toDir);
            if (tfr.success) {
                ++numberOfWrittenFiles;
            }
            sb.append(tfr.protocol);
        }
        sb.append("\n==============================================================");
        sb.append("\nSummary: \n" + numberOfWrittenFiles + " files transferred" + (jspFileNames.size() - numberOfWrittenFiles) + " files NOT transferred");
        sb.append("\n==============================================================");
        return sb.toString();
    }

    public static TransferFileResult transferFile(String jspFileName, String toDir) {
        StringBuffer sb;
        TransferFileResult result;
        block16: {
            result = new TransferFileResult();
            sb = new StringBuffer();
            File jf = new File(jspFileName);
            String xmlFileName = toDir + jf.getName();
            xmlFileName = xmlFileName.replace(".jsp", ".xml");
            File xf = new File(xmlFileName);
            sb.append("\n--------------------------------------------------------------");
            sb.append("\nTransfer of file: " + xmlFileName);
            sb.append("\n--------------------------------------------------------------");
            if (!xf.exists() || xf.lastModified() < jf.lastModified()) {
                sb.append("\nReading the JSP content...");
                String content = FileManager.readUTF8File(jspFileName, true);
                String tagName = null;
                int index = content.indexOf("<t:pagebeanroot ");
                boolean includeTagName = false;
                if (index >= 0) {
                    tagName = "t:pagebeanroot";
                    includeTagName = true;
                } else {
                    index = content.indexOf("<t:row ");
                    if (index >= 0) {
                        tagName = "t:row";
                        includeTagName = false;
                    } else {
                        tagName = null;
                    }
                }
                if (tagName != null) {
                    sb.append("\nExtracting content between outest <" + tagName + "> ... </" + tagName + ">");
                    int index1 = index;
                    int index2 = 0;
                    if (!includeTagName) {
                        index1 = content.indexOf(">", index1) + 1;
                        index2 = content.lastIndexOf("</" + tagName + ">");
                    } else {
                        index2 = content.lastIndexOf("</" + tagName + ">");
                        index2 += tagName.length() + 3;
                    }
                    if (index1 >= 0 && index2 > index1) {
                        sb.append("\nThe XML is:");
                        String xml = content.substring(index1, index2);
                        sb.append(xml);
                        try {
                            boolean xmlValid = false;
                            try {
                                xmlValid = ValueManager.checkIfXMLIsValid(xml);
                            }
                            catch (Throwable tt) {
                                Statusbar.outputError("Problem occurred: " + tt.toString(), ValueManager.getStackstraceString(tt));
                            }
                            if (!xmlValid) {
                                sb.append("\nERROR when validating saved XML - this is not a valid XML page bean component definition");
                                sb.append("\nTypical problem: the page must only contain one root node (t:pagebeanroot or t:row), this root node itself must containe exactly one child node as well");
                                result.success = false;
                                break block16;
                            }
                            sb.append("\nWriting file...");
                            FileManager.writeUTF8File(xmlFileName, xml, true);
                            sb.append("\nWriting file... ...finished.");
                            result.success = true;
                        }
                        catch (Throwable t) {
                            Statusbar.outputError("Error: " + t.toString(), ValueManager.getStackstraceString(t));
                        }
                    }
                } else {
                    sb.append("\nCould not find <t:row> ... </t:row>");
                    result.success = false;
                }
            } else {
                sb.append("\nNO TRANSFER: XML-file already exists and XML-file newer than JSP-file");
            }
        }
        result.protocol = sb.toString();
        return result;
    }

    public static class TransferFileResult {
        public boolean success;
        public String protocol;
    }
}

