/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclnt.util.file.FileInfo;

public class ZipUtil {
    static final int BUFFER = 1024;

    public static void main(String[] args) {
        try {
            String fileName = "C:\\bmu_jtc\\git\\eclnt_jsfserver\\WebContent\\WEB-INF\\lib\\gson.jar";
            FileInputStream fis = new FileInputStream(fileName);
            FileInfo ci = new ZipUtil().readDirectoryStructure(fis);
            System.out.println(ci.toString());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public FileInfo readDirectoryStructure(InputStream data) {
        try {
            List<String> fileList = this.readFileList(data);
            Collections.sort(fileList);
            Stack<FileInfo> ciStack = new Stack<FileInfo>();
            FileInfo root = new FileInfo("/");
            ciStack.add(root);
            for (String fileName : fileList) {
                FileInfo ci = new FileInfo(fileName);
                FileInfo stackCi = this.findParentContentInfoInStack(ciStack, ci);
                if (fileName.endsWith("/")) {
                    stackCi.getSubDirectories().add(ci);
                    ciStack.push(ci);
                    continue;
                }
                stackCi.getSubFiles().add(ci);
            }
            return root;
        }
        catch (Throwable t) {
            throw new Error("Problem reading directory Structure", t);
        }
    }

    private FileInfo findParentContentInfoInStack(Stack<FileInfo> stack, FileInfo ci) {
        int maxi = stack.size();
        for (int i = 0; i < maxi; ++i) {
            FileInfo stackCi = stack.peek();
            if (ci.getAbsoluteName().startsWith(stackCi.getAbsoluteName())) {
                return stackCi;
            }
            stack.pop();
        }
        throw new Error("Should not happen!");
    }

    public List<String> readFileList(InputStream data) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            ZipInputStream inZip = new ZipInputStream(data);
            ZipEntry inZipEntry = inZip.getNextEntry();
            while (inZipEntry != null) {
                result.add("/" + inZipEntry.getName());
                inZipEntry = inZip.getNextEntry();
            }
            inZip.close();
            data.close();
            return result;
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unZipIt(InputStream data, String outputFolder, IListener listener) {
        byte[] byteBuffer = new byte[1024];
        try {
            int counter = 0;
            ZipInputStream inZip = new ZipInputStream(data);
            ZipEntry inZipEntry = inZip.getNextEntry();
            while (inZipEntry != null) {
                ++counter;
                String fileName = inZipEntry.getName();
                File unZippedFile = new File(outputFolder + File.separator + fileName);
                if (inZipEntry.isDirectory()) {
                    unZippedFile.mkdirs();
                } else {
                    new File(unZippedFile.getParent()).mkdirs();
                    unZippedFile.createNewFile();
                    FileOutputStream unZippedFileOutputStream = null;
                    try {
                        int length;
                        unZippedFileOutputStream = new FileOutputStream(unZippedFile);
                        while ((length = inZip.read(byteBuffer)) > 0) {
                            unZippedFileOutputStream.write(byteBuffer, 0, length);
                        }
                    }
                    catch (Throwable t) {
                        listener.updateStatusProblem(t.toString());
                    }
                    finally {
                        try {
                            unZippedFileOutputStream.close();
                        }
                        catch (Throwable length) {}
                    }
                }
                inZipEntry = inZip.getNextEntry();
                if (listener == null || counter % 10 != 0) continue;
                listener.updateDetail("Number of unzipped files: " + counter, -1.0);
            }
            inZip.close();
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public void zipFiles(List<File> files, OutputStream os) {
        ZipOutputStream zos = null;
        BufferedInputStream bis = null;
        try {
            zos = new ZipOutputStream(os);
            for (File file : files) {
                int count;
                FileInputStream fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis, 1024);
                ZipEntry ze = new ZipEntry(file.getName());
                zos.putNextEntry(ze);
                byte[] data = new byte[1024];
                while ((count = bis.read(data, 0, 1024)) != -1) {
                    zos.write(data, 0, count);
                }
                bis.close();
            }
        }
        catch (Throwable t) {
            throw new Error("Problem occurred when zipping List of files", t);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
        }
    }

    public static interface IListener {
        public void updateStatusProblem(String var1);

        public void updateDetail(String var1, double var2);
    }
}

