/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.http;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.eclnt.util.log.CLog;

public class HttpReader {
    static int s_defaultTimeOut = 5000;
    static int s_defaultReadTimeOut = 10000;

    public static void initializeDefaultConnectionTimeout(int value) {
        s_defaultTimeOut = value;
    }

    public static void initializeDefaultReadTimeout(int value) {
        s_defaultReadTimeOut = value;
    }

    public static byte[] readBytesFromURL(String urlString) {
        InputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            byte[] response;
            URL url = new URL(urlString);
            in = new BufferedInputStream(url.openStream());
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(s_defaultTimeOut);
            connection.setReadTimeout(s_defaultReadTimeOut);
            in = new BufferedInputStream(connection.getInputStream());
            out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int n = 0;
            while (-1 != (n = in.read(buf))) {
                out.write(buf, 0, n);
            }
            byte[] byArray = response = out.toByteArray();
            return byArray;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem when reading: " + urlString, t);
            throw new Error(t);
        }
        finally {
            try {
                out.close();
            }
            catch (Throwable throwable) {}
            try {
                in.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

