/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.map;

import java.util.HashMap;

public class LazyLoadingMap<VALUECLASS>
extends HashMap<String, VALUECLASS> {
    ILazyLoader<VALUECLASS> m_loader;

    public LazyLoadingMap() {
    }

    public LazyLoadingMap(ILazyLoader<VALUECLASS> loader) {
        this.m_loader = loader;
    }

    public void setLoader(ILazyLoader<VALUECLASS> loader) {
        this.m_loader = loader;
    }

    public ILazyLoader<VALUECLASS> getLoader() {
        return this.m_loader;
    }

    @Override
    public VALUECLASS get(Object key) {
        Object result = super.get(key);
        if (result == null && !this.containsKey(key)) {
            if (!(key instanceof String)) {
                throw new Error("Key must be of type String");
            }
            result = this.lazyLoad((String)key);
            this.put((String)key, result);
        }
        return (VALUECLASS)result;
    }

    public VALUECLASS getDirectly(Object key) {
        return (VALUECLASS)super.get(key);
    }

    protected VALUECLASS lazyLoad(String key) {
        if (this.m_loader == null) {
            throw new Error("Loader not defined");
        }
        return this.m_loader.lazyLoad(key);
    }

    public static interface ILazyLoader<BEANCLASS> {
        public BEANCLASS lazyLoad(String var1);
    }
}

