/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.valuemgmt;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.swing.ImageIcon;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.ULog;
import org.eclnt.util.valuemgmt.ValueManager;

public class ImageShrinker {
    public static boolean checkIfShrinkingIsSupported(String extension) {
        if (extension == null) {
            return false;
        }
        if ((extension = ValueManager.toLowerCaseId(extension)).equals("jpg")) {
            return true;
        }
        if (extension.equals("jpeg")) {
            return true;
        }
        if (extension.equals("gif")) {
            return true;
        }
        if (extension.equals("giff")) {
            return true;
        }
        return extension.equals("png");
    }

    public static byte[] shrinkImage(byte[] bytes, int width, int height, String format) throws ImageShrinkerException {
        return ImageShrinker.shrinkImage(bytes, width, height, 0.85f, format);
    }

    public static byte[] shrinkImage(byte[] bytes, int width, int height, float quality, String format) throws ImageShrinkerException {
        return ImageShrinker.sizeImage(bytes, width, height, quality, format, true, true);
    }

    public static byte[] sizeImage(byte[] bytes, int width, int height, float quality, String format, boolean keepRatio, boolean onlyShrkinking) throws ImageShrinkerException {
        try {
            format = ValueManager.toLowerCaseId(format);
            if ("jpeg".equals(format)) {
                format = "jpg";
            }
            if ("giff".equals(format)) {
                format = "gif";
            }
            ImageIcon originalImage = new ImageIcon(bytes);
            boolean landscape = true;
            if (originalImage.getIconWidth() < originalImage.getIconHeight()) {
                int dummy = width;
                width = height;
                height = dummy;
                landscape = false;
            }
            if (onlyShrkinking && originalImage.getIconWidth() <= width && originalImage.getIconHeight() <= height) {
                return bytes;
            }
            BufferedImage newImage = "png".equals(format) || "gif".equals(format) ? new BufferedImage(width, height, 2) : new BufferedImage(width, height, 1);
            Graphics g = newImage.getGraphics();
            int newX = 0;
            int newY = 0;
            int newWidth = width;
            int newHeight = height;
            if (keepRatio && (newY = height / 2 - (newHeight = Math.round((float)width / (float)originalImage.getIconWidth() * (float)originalImage.getIconHeight())) / 2) < 0) {
                newY = 0;
                newHeight = height;
                newWidth = Math.round((float)height / (float)originalImage.getIconHeight() * (float)originalImage.getIconWidth());
                newX = width / 2 - newWidth / 2;
            }
            if ("jpg".equalsIgnoreCase(format) || "gif".equalsIgnoreCase(format)) {
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, width, height);
            }
            g.drawImage(originalImage.getImage(), newX, newY, newWidth, newHeight, null);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if ("jpg".equalsIgnoreCase(format)) {
                try {
                    Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(format);
                    ImageWriter iw = iter.next();
                    ImageWriteParam iwp = iw.getDefaultWriteParam();
                    iwp.setCompressionMode(2);
                    iwp.setCompressionQuality(quality);
                    MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(bos);
                    iw.setOutput(ios);
                    IIOImage image = new IIOImage(newImage, null, null);
                    iw.write(null, image, iwp);
                    iw.dispose();
                }
                catch (Throwable t) {
                    ULog.logINF("Using default ImageIO.write, exception: " + t.toString());
                    ImageIO.write((RenderedImage)newImage, format, bos);
                }
            } else {
                ImageIO.write((RenderedImage)newImage, format, bos);
            }
            bos.close();
            return bos.toByteArray();
        }
        catch (Throwable t) {
            ULog.logINF("Error occurred when shrinking image", t);
            throw new ImageShrinkerException(t);
        }
    }

    public static void main(String[] args) {
        try {
            byte[] bytes = FileManager.readFile("C:/temp/aaaaa/aaaaa.jpg", true);
            byte[] newBytes = ImageShrinker.shrinkImage(bytes, 100, 80, 0.8f, "jpg");
            FileManager.writeFile("c:/temp/aaaaa/aaaaa_converted.jpg", newBytes, true);
            System.out.println("OK");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static class ImageShrinkerException
    extends Exception {
        public ImageShrinkerException() {
        }

        public ImageShrinkerException(String message, Throwable cause) {
            super(message, cause);
        }

        public ImageShrinkerException(String message) {
            super(message);
        }

        public ImageShrinkerException(Throwable cause) {
            super(cause);
        }
    }
}

