/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.ModalPopup;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.defaultscreens.YESNOPopup;
import org.eclnt.jsfserver.elements.impl.DYNAMICCONTENTBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDListBinding;
import org.eclnt.jsfserver.elements.impl.ROWDYNAMICCONTENTBinding;
import org.eclnt.jsfserver.elements.util.DefaultModalPopupListener;
import org.eclnt.jsfserver.i18n.I18N;
import org.eclnt.workplace.IWorkpageDispatcher;
import org.eclnt.workplace.WorkplaceFunctionTreeInfoNode;
import org.eclnt.workplace.WorkplaceTileInfo;
import org.eclnt.workplace.WorkplaceUserInfo;
import org.eclnt.workplace.WorkplaceViewManager;

public class WorkplacePerspectiveManager
implements Serializable {
    IWorkpageDispatcher m_owningDispatcher;
    WorkplaceFunctionTreeInfoNode m_rootNode;
    DYNAMICCONTENTBinding m_content = new DYNAMICCONTENTBinding();
    String m_user;
    WorkplaceUserInfo m_userInfo;
    String m_currentPerspective;
    String m_currentPerspectiveText;
    String m_expressionBase;
    List<Invoker> m_invokers = new ArrayList<Invoker>();
    ModalPopup m_modalPopup;
    String m_popupName;
    FIXGRIDListBinding<PerspectiveGridItem> m_perspectiveGrid = new FIXGRIDListBinding();

    public WorkplacePerspectiveManager(IWorkpageDispatcher owningDispatcher) {
        this.m_owningDispatcher = owningDispatcher;
        this.m_expressionBase = owningDispatcher.getExpressionBase();
    }

    public void prepare(String user, WorkplaceUserInfo userInfo) {
        this.m_owningDispatcher.getWorkpageContainer().getHistory().block();
        this.m_user = user;
        this.m_userInfo = userInfo;
        this.renderContent();
        this.m_currentPerspective = userInfo.getDefaultPerspective();
        this.m_currentPerspectiveText = userInfo.getDefaultPerspective();
        this.m_owningDispatcher.getWorkpageContainer().getHistory().unblock();
    }

    public void setName(String value) {
        this.m_popupName = value;
        if (this.m_popupName != null) {
            this.m_popupName = this.m_popupName.replace("/", "_");
            this.m_popupName = this.m_popupName.replace("\\", "_");
            while (this.m_popupName.startsWith(" ")) {
                this.m_popupName = this.m_popupName.substring(1);
            }
        }
    }

    public String getName() {
        return this.m_popupName;
    }

    public FIXGRIDListBinding<PerspectiveGridItem> getPerspectiveGrid() {
        return this.m_perspectiveGrid;
    }

    public DYNAMICCONTENTBinding getContent() {
        return this.m_content;
    }

    public String getCurrentPerspective() {
        return this.m_currentPerspective;
    }

    public String getCurrentPerspectiveText() {
        return this.m_currentPerspectiveText;
    }

    public List<Invoker> getInvokers() {
        return this.m_invokers;
    }

    public void onManagePerspectives(ActionEvent event) {
        this.m_popupName = null;
        String replaceExpression = this.m_owningDispatcher.getExpressionBase();
        replaceExpression = replaceExpression.substring(0, replaceExpression.length() - 1);
        replaceExpression = replaceExpression + ".workpageContainer.perspectiveManager.";
        this.m_modalPopup = ModalPopup.createInstance();
        this.m_modalPopup.open("/eclntjsfserver/includes/wp_perspectiveadmin.jsp", I18N.getString("WPP_managePerspectivesTitle"), 0, 0, new DefaultModalPopupListener(this.m_modalPopup));
        this.m_modalPopup.setContentReplace("#{BEAN.:" + replaceExpression);
        this.m_popupName = null;
        this.m_perspectiveGrid.getItems().clear();
        List<String> names = WorkplaceViewManager.getAvailalablePersonalTileInfos(this.m_user);
        for (String name : names) {
            this.m_perspectiveGrid.getItems().add(new PerspectiveGridItem(name));
        }
    }

    public void onSave(ActionEvent event) {
        if (this.m_popupName == null || this.m_popupName.trim().length() == 0) {
            Statusbar.outputAlert(I18N.getString("WPP_missingName"));
            return;
        }
        WorkplaceTileInfo tileInfo = this.m_owningDispatcher.getWorkpageContainer().getTileManager().exportWorkplaceTileInfo();
        WorkplaceViewManager.storePersonalTileInfo(tileInfo, this.m_user, this.m_popupName);
        this.m_modalPopup.close();
        this.m_modalPopup = null;
        this.renderContent();
    }

    private void renderContent() {
        ROWDYNAMICCONTENTBinding.ComponentNode ms;
        Object mi;
        this.m_invokers.clear();
        ROWDYNAMICCONTENTBinding.ComponentNode bm = new ROWDYNAMICCONTENTBinding.ComponentNode("t:buttonmenu");
        bm.addAttribute("text", this.m_expressionBase.replace("}", ".workpageContainer.perspectiveManager.currentPerspectiveText}"));
        bm.addAttribute("buttonmenumode", "buttonandmenu");
        bm.addAttribute("stylevariant", "WP_PERSPECTIVEMANAGER");
        int counter = 0;
        for (String perspective : this.m_userInfo.getPerspectives()) {
            mi = new ROWDYNAMICCONTENTBinding.ComponentNode("t:menuitem");
            bm.addSubNode((ROWDYNAMICCONTENTBinding.ComponentNode)mi);
            ((ROWDYNAMICCONTENTBinding.ComponentNode)mi).addAttribute("text", perspective);
            ((ROWDYNAMICCONTENTBinding.ComponentNode)mi).addAttribute("actionListener", this.m_expressionBase.replace("}", ".workpageContainer.perspectiveManager.invokers[" + counter + "].onAction}"));
            Invoker inv = new Invoker(perspective);
            this.m_invokers.add(inv);
            ++counter;
        }
        List<String> userPerspectives = WorkplaceViewManager.getAvailalablePersonalTileInfos(this.m_user);
        if (userPerspectives.size() > 0) {
            ms = new ROWDYNAMICCONTENTBinding.ComponentNode("t:menuseparator");
            bm.addSubNode(ms);
            for (String perspective : userPerspectives) {
                ROWDYNAMICCONTENTBinding.ComponentNode mi2 = new ROWDYNAMICCONTENTBinding.ComponentNode("t:menuitem");
                bm.addSubNode(mi2);
                int index = perspective.lastIndexOf(47);
                String perspectiveText = perspective.substring(index + 1);
                mi2.addAttribute("text", perspectiveText);
                mi2.addAttribute("actionListener", this.m_expressionBase.replace("}", ".workpageContainer.perspectiveManager.invokers[" + counter + "].onAction}"));
                Invoker inv = new Invoker(perspective);
                this.m_invokers.add(inv);
                ++counter;
            }
        }
        ms = new ROWDYNAMICCONTENTBinding.ComponentNode("t:menuseparator");
        bm.addSubNode(ms);
        mi = new ROWDYNAMICCONTENTBinding.ComponentNode("t:menuitem");
        bm.addSubNode((ROWDYNAMICCONTENTBinding.ComponentNode)mi);
        ((ROWDYNAMICCONTENTBinding.ComponentNode)mi).addAttribute("text", "#{eclnti18n.WPP_menuitemManagePerspectives}");
        ((ROWDYNAMICCONTENTBinding.ComponentNode)mi).addAttribute("actionListener", this.m_expressionBase.replace("}", ".workpageContainer.perspectiveManager.onManagePerspectives}"));
        this.m_content.setContentNode(bm);
    }

    private void selectPerspective(String perspective) {
        this.m_currentPerspective = perspective;
        this.m_currentPerspectiveText = perspective;
        this.m_owningDispatcher.getWorkpageContainer().getTileManager().importWorkplaceTileInfo(perspective);
    }

    public class PerspectiveGridItem
    extends FIXGRIDItem {
        String i_perspectiveName;

        public PerspectiveGridItem(String perspectiveName) {
            this.i_perspectiveName = perspectiveName;
            int slashIndex = this.i_perspectiveName.indexOf("/");
            this.i_perspectiveName = this.i_perspectiveName.substring(slashIndex + 1);
        }

        public String getPerspectiveName() {
            return this.i_perspectiveName;
        }

        @Override
        public void onRowSelect() {
            WorkplacePerspectiveManager.this.m_popupName = this.i_perspectiveName;
        }

        public void onRemove(ActionEvent event) {
            YESNOPopup.createInstance(I18N.getString("WPP_popupYesNoRemoveTitle"), I18N.getString("WPP_popupYesNoRemoveContent"), new YESNOPopup.IYesNoListener(){

                @Override
                public void reactOnYes() {
                    PerspectiveGridItem.this.removeExecute();
                }

                @Override
                public void reactOnNo() {
                }
            });
        }

        private void removeExecute() {
            WorkplaceViewManager.removePersonalTileInfo(WorkplacePerspectiveManager.this.m_user, this.i_perspectiveName);
            WorkplacePerspectiveManager.this.m_perspectiveGrid.getItems().remove(this);
            WorkplacePerspectiveManager.this.renderContent();
        }
    }

    public class Invoker
    implements Serializable {
        String i_perspective;

        public Invoker(String perspective) {
            this.i_perspective = perspective;
        }

        public void onAction(ActionEvent ae) {
            WorkplacePerspectiveManager.this.selectPerspective(this.i_perspective);
        }
    }
}

