/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace.wfinbox;

import java.io.Serializable;
import java.util.List;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.ModelessPopup;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDListBinding;
import org.eclnt.jsfserver.util.useraccess.UserAccessMgr;
import org.eclnt.util.log.CLog;
import org.eclnt.workplace.IWorkpageDispatcher;
import org.eclnt.workplace.WorkpageDispatchedPageBean;
import org.eclnt.workplace.wfinbox.IWFManager;
import org.eclnt.workplace.wfinbox.WFItemDetailUI;
import org.eclnt.workplace.wfinbox.WFManagerFactory;
import org.eclnt.workplace.wfinbox.WorkItem;

public class WFInboxUI
extends WorkpageDispatchedPageBean {
    FIXGRIDListBinding<GridItem> m_grid = new FIXGRIDListBinding();
    ModelessPopup m_itemPopup;
    WFItemDetailUI m_itemUI;

    public WFInboxUI(IWorkpageDispatcher dispatcher) {
        super(dispatcher);
        this.refreshGrid();
    }

    @Override
    public String getPageName() {
        return "/eclntjsfserver/includes/wfinbox.jsp";
    }

    @Override
    public String getRootExpressionUsedInPage() {
        return "#{WFInboxUI}";
    }

    public FIXGRIDListBinding<GridItem> getGrid() {
        return this.m_grid;
    }

    public WFItemDetailUI getItemUI() {
        return this.m_itemUI;
    }

    public void onRefreshGridAction(ActionEvent event) {
        this.refreshGrid();
    }

    private void refreshGrid() {
        try {
            this.m_grid.getItems().clear();
            String user = UserAccessMgr.getCurrentUser();
            CLog.L.log(CLog.LL_INF, "Refreshing Inbox for user: " + user);
            IWFManager wfm = WFManagerFactory.getInstance();
            List<WorkItem> wis = wfm.readOpenWorkflowItemsForUser(user);
            for (WorkItem wi : wis) {
                this.m_grid.getItems().add(new GridItem(wi));
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "", t);
            Statusbar.outputAlert("Error when reading workflow inbox: " + t.toString());
        }
    }

    public void showWorkItem(WorkItem wi) {
        try {
            WFItemDetailUI wiui;
            if (wi == null) {
                return;
            }
            this.m_itemUI = wiui = new WFItemDetailUI(this.getOwningDispatcher(), wi, new WFItemDetailUI.IListener(){

                @Override
                public void reactOnDataChanged() {
                    WFInboxUI.this.refreshGrid();
                }
            });
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "", t);
            Statusbar.outputAlert("Error when starting work item.");
        }
    }

    public class GridItem
    extends FIXGRIDItem
    implements Serializable {
        WorkItem i_wi;

        public GridItem(WorkItem wi) {
            this.i_wi = wi;
        }

        public WorkItem getWi() {
            return this.i_wi;
        }

        @Override
        public void onRowSelect() {
            WFInboxUI.this.showWorkItem(this.i_wi);
        }
    }
}

