/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.ArrayList;
import java.util.List;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.file.PropertiesFileManager;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.junit.Assert;
import org.junit.Test;

public class TestPropertiesFileManager {
    @Test
    public void testUnsecape() {
        try {
            Assert.assertEquals((Object)"\u00c4\u00d6\u00dc", (Object)PropertiesFileManager.unescapeString("\u00c4\u00d6\u00dc"));
            System.out.println("FINISHED");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    @Test
    public void testReadWriteEscaped() {
        this.testReadWrite(false);
    }

    @Test
    public void testReadWriteUTF8() {
        this.testReadWrite(true);
    }

    @Test
    public void testAdd() {
        this.testAdd(true);
    }

    @Test
    public void testAddKeepExisting() {
        this.testAdd(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdd(boolean overwriteExisting) {
        String fileName = FileManager.getTempFileDirectory() + "/cctest/" + UniqueIdCreator.createId() + ".properties";
        try {
            List<PropertiesFileManager.PropertyValue> oldPvs = this.buildPropertyValues();
            PropertiesFileManager.savePropertiesInFile(fileName, oldPvs, true, true);
            System.out.println("--- this is the file content");
            String s = FileManager.readUTF8File(fileName, true);
            System.out.println(s);
            System.out.println("---");
            ArrayList<PropertiesFileManager.PropertyValue> newPvs = new ArrayList<PropertiesFileManager.PropertyValue>();
            newPvs.add(new PropertiesFileManager.PropertyValue("aaa", "aaa"));
            newPvs.add(new PropertiesFileManager.PropertyValue("bbb", "bbb"));
            newPvs.add(new PropertiesFileManager.PropertyValue("zzz", "zzz"));
            newPvs.add(new PropertiesFileManager.PropertyValue("p2", "HARRY"));
            PropertiesFileManager.addPropertiesToFile(fileName, newPvs, overwriteExisting, true, true);
            System.out.println("--- this is the file content");
            String s2 = FileManager.readUTF8File(fileName, true);
            System.out.println(s2);
            System.out.println("---");
            List<PropertiesFileManager.PropertyValue> nowPvs = PropertiesFileManager.readPropertiesFromFile(fileName, true, true);
            Assert.assertEquals((long)nowPvs.size(), (long)(oldPvs.size() + newPvs.size() - 1));
            System.out.println("FINISHED");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
        finally {
            FileManager.deleteFile(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReadWrite(boolean asUTF8) {
        String fileName = FileManager.getTempFileDirectory() + "/cctest/" + UniqueIdCreator.createId() + ".properties";
        try {
            FileManager.ensureDirectoryForFileExists(fileName);
            List<PropertiesFileManager.PropertyValue> pvs = this.buildPropertyValues();
            PropertiesFileManager.savePropertiesInFile(fileName, pvs, asUTF8, true);
            System.out.println("--- this is the file content");
            String s = FileManager.readUTF8File(fileName, true);
            System.out.println(s);
            System.out.println("---");
            List<PropertiesFileManager.PropertyValue> rpvs = PropertiesFileManager.readPropertiesFromFile(fileName, asUTF8, true);
            Assert.assertEquals((long)rpvs.size(), (long)pvs.size());
            for (int i = 0; i < pvs.size(); ++i) {
                Assert.assertEquals((Object)pvs.get(i).getProperty(), (Object)rpvs.get(i).getProperty());
                Assert.assertEquals((Object)pvs.get(i).getValue(), (Object)rpvs.get(i).getValue());
            }
            System.out.println("FINISHED");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
        finally {
            FileManager.deleteFile(fileName);
        }
    }

    private List<PropertiesFileManager.PropertyValue> buildPropertyValues() {
        ArrayList<PropertiesFileManager.PropertyValue> pvs = new ArrayList<PropertiesFileManager.PropertyValue>();
        pvs.add(new PropertiesFileManager.PropertyValue("p1", "Abc"));
        pvs.add(new PropertiesFileManager.PropertyValue("p2", "\u00c4\u00d6\u00dc"));
        pvs.add(new PropertiesFileManager.PropertyValue("p3", "\u00e4\u00f6\u00fc"));
        pvs.add(new PropertiesFileManager.PropertyValue("p4", "Abc\ndef"));
        pvs.add(new PropertiesFileManager.PropertyValue("p5", "Abc\tdef"));
        pvs.add(new PropertiesFileManager.PropertyValue("p6", "Abc\rdef"));
        pvs.add(new PropertiesFileManager.PropertyValue("p7", "Abc\r\ndef"));
        return pvs;
    }
}

