/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.calendar;

import com.veracode.annotation.XSSCleanser;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import org.eclnt.jsfserver.calendar.ExtCalendarMgr;
import org.eclnt.jsfserver.calendar.IExtCalendarMgr;
import org.eclnt.jsfserver.util.CCESAPI;
import org.eclnt.jsfserver.util.CCServletBase;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class ExtCalendarServlet
extends CCServletBase {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String method = req.getMethod();
            if ("GET".equals(method)) {
                ServletUtil.ensureServletGetIsAllowed(((Object)((Object)this)).getClass());
            }
            String calendarId = req.getParameter("CALENDARID");
            if (req.getCharacterEncoding() == null && SystemXml.getNonJSFRequestsExplicitUTF8Conversion()) {
                calendarId = new String(calendarId.getBytes("ISO-8859-1"), "UTF-8");
            }
            String dateStr = req.getParameter("DATE");
            String timezone = req.getParameter("TIMEZONE");
            String language = req.getParameter("LANGUAGE");
            long date = ValueManager.decodeLong(dateStr, 0L);
            Date dateDate = new Date(date);
            CLog.L.log(CLog.LL_INF, "Requesting calendar information for: " + dateStr + "/" + timezone + "/" + calendarId + " // " + dateDate);
            IExtCalendarMgr ecm = ExtCalendarMgr.getInstance();
            List<IExtCalendarMgr.ExtCalendarInfo> ecis = ecm.getCalendarInfoForMonth(calendarId, dateDate, timezone);
            StringBuffer sb = new StringBuffer();
            sb.append("<result>\n");
            for (IExtCalendarMgr.ExtCalendarInfo eci : ecis) {
                String dateXML = CCESAPI.getXMLAttributeValue("" + eci.getDate().getTime());
                String commentXML = CCESAPI.getXMLAttributeValue(eci.getComment(language));
                String selectableXML = CCESAPI.getXMLAttributeValue("" + eci.isSelectable());
                String warningXML = CCESAPI.getXMLAttributeValue("" + eci.getWarningOnSelection());
                String backgroundXML = CCESAPI.getXMLAttributeValue(eci.getBackground());
                sb.append("<day date='" + dateXML + "' comment='" + commentXML + "' selectable='" + selectableXML + "' warningonselection='" + warningXML + "'");
                if (backgroundXML != null) {
                    sb.append(" background='" + backgroundXML + "'");
                }
                sb.append("/>\n");
            }
            sb.append("</result>");
            CLog.L.log(CLog.LL_INF, "Calendar information for client:\n" + sb.toString());
            this.writeXMLResultToResponse(resp, sb.toString());
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error occurred in extended calendar management servlet processing", t);
        }
    }

    @XSSCleanser(userComment="The output is an XML string that is containing data that is shown in an extended calendar component (e.g. colors of days, comments for days). The XML is assembled by using ESAPI.encoder().encodeForXMLAttribute(value) for all dynamic content that is added into the XML String.")
    private void writeXMLResultToResponse(HttpServletResponse resp, String xml) throws IOException {
        ServletUtil.setResponseContentType(resp, "application/xml");
        PrintWriter w = resp.getWriter();
        ((Writer)w).append(xml);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

