/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.configuration;

import jakarta.servlet.ServletContext;
import org.eclnt.jsfserver.configuration.CCConfigurationObjectLoader;
import org.eclnt.jsfserver.configuration.ICCConfigurationObjectWithInit;
import org.eclnt.jsfserver.configuration.ICCConfigurationObjectWithInitialize;
import org.eclnt.jsfserver.managedbean.DefaultHotDeployListener;
import org.eclnt.jsfserver.managedbean.HotDeployClassLoader;
import org.eclnt.jsfserver.managedbean.HotDeployNotifier;

public class CCConfigurationObject<CLASS> {
    CLASS m_instance;
    boolean m_instanceIsFix = false;
    String m_className;
    ServletContext m_servletContext;

    public CCConfigurationObject(String className, ServletContext servletContext) {
        try {
            this.m_className = className;
            this.instance();
            HotDeployNotifier.addListener(new DefaultHotDeployListener(){

                @Override
                public void onClassLoaderUpdate(ClassLoader newClassLoader) {
                    if (CCConfigurationObject.this.m_instance != null && CCConfigurationObject.this.m_instance.getClass().getClassLoader() instanceof HotDeployClassLoader) {
                        CCConfigurationObject.this.m_instance = null;
                    }
                }
            });
        }
        catch (Throwable t) {
            throw new Error("Problem when initializing configuration object: " + className, t);
        }
    }

    public CCConfigurationObject(CLASS instance) {
        this.m_instance = instance;
        this.m_instanceIsFix = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLASS instance() {
        if (this.m_instance == null && !this.m_instanceIsFix) {
            CCConfigurationObject cCConfigurationObject = this;
            synchronized (cCConfigurationObject) {
                if (this.m_instance == null) {
                    this.m_instance = CCConfigurationObjectLoader.instance().loadInstance(this.m_className, true);
                    if (this.m_instance instanceof ICCConfigurationObjectWithInitialize) {
                        ((ICCConfigurationObjectWithInitialize)this.m_instance).initialize(this.m_servletContext);
                    }
                    if (this.m_instance instanceof ICCConfigurationObjectWithInit) {
                        ((ICCConfigurationObjectWithInit)this.m_instance).init(this.m_servletContext);
                    }
                }
            }
        }
        return this.m_instance;
    }
}

