/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclnt.jsfserver.injection.CheckInboundAndOutboundValuesFactory;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.XMLWriter;

public class XMLNode
implements Serializable {
    boolean m_containsChange = false;
    boolean m_isNewNode = false;
    String m_name;
    String m_text;
    List<AttributeNameValue> m_attributeNamesValues = new ArrayList<AttributeNameValue>(5);
    XMLNode m_parent;
    List<XMLNode> m_children = new ArrayList<XMLNode>(5);

    public XMLNode(String name) {
        this.m_name = name;
    }

    public XMLNode(String name, boolean isNewNode, XMLNode parent) {
        this.m_name = name;
        parent.addChild(this);
        this.m_isNewNode = isNewNode;
        if (this.m_isNewNode) {
            this.markAsChanged(true);
        }
    }

    private void addChild(XMLNode node) {
        node.m_parent = this;
        this.m_children.add(node);
    }

    public List<XMLNode> getChildren() {
        return this.m_children;
    }

    public String getName() {
        return this.m_name;
    }

    public String getAttributeValue(String attributeName) {
        for (AttributeNameValue anv : this.m_attributeNamesValues) {
            if (!anv.getAttributeName().equals(attributeName)) continue;
            return anv.getAttributeValue();
        }
        return null;
    }

    public void addAttributeValue(String attributeName, String attributeValue) {
        this.m_attributeNamesValues.add(new AttributeNameValue(attributeName, attributeValue));
        if (!attributeName.equals("nochange") && !attributeName.equals("id")) {
            this.markAsChanged(true);
        }
    }

    public void addText(String text) {
        this.m_text = text;
    }

    public void writeSubNodesToWriter(Writer writer) throws IOException {
        for (XMLNode child : this.m_children) {
            child.writeToWriter(writer);
        }
    }

    public void writeToWriter(Writer writer) throws IOException {
        boolean noChangeWritten = false;
        XMLWriter.writer_startElement(writer, null, this.m_name);
        HashSet<String> processedAttributeNames = new HashSet<String>(this.m_attributeNamesValues.size());
        for (int i = 0; i < this.m_attributeNamesValues.size(); ++i) {
            AttributeNameValue anv = this.m_attributeNamesValues.get(i);
            if (processedAttributeNames.contains(anv.getAttributeName())) {
                CLog.L.log(CLog.LL_ERR, "Duplicate attribute name in XML tag processing - Should never happen! " + this.m_name + "/" + anv.getAttributeName());
                continue;
            }
            processedAttributeNames.add(anv.getAttributeName());
            String av = anv.i_attributeValue;
            av = CheckInboundAndOutboundValuesFactory.instance().checkOutboundValue(this.m_name, anv.getAttributeName(), av);
            XMLWriter.writer_writeAttribute(writer, null, anv.i_attributeName, av);
            if (!anv.i_attributeName.equals("nochange")) continue;
            noChangeWritten = true;
        }
        processedAttributeNames = null;
        if (!this.m_containsChange && !noChangeWritten && this.m_children.size() > 0) {
            XMLWriter.writer_writeAttribute(writer, null, "nochange", "true");
        }
        if (this.m_containsChange) {
            if (this.m_children.size() > 0) {
                XMLWriter.writer_closeStartElement(writer, null);
                for (XMLNode child : this.m_children) {
                    child.writeToWriter(writer);
                }
                XMLWriter.writer_endElement(writer, null, this.m_name);
            } else {
                XMLWriter.writer_closeStartAndEndElement(writer, null);
            }
        } else {
            XMLWriter.writer_closeStartAndEndElement(writer, null);
        }
    }

    public void markAsChanged(boolean fromParentOn) {
        XMLNode currentNode = this.m_parent;
        if (!fromParentOn) {
            currentNode = this;
        }
        do {
            currentNode.m_containsChange = true;
            if (currentNode.m_parent == null) break;
            currentNode = currentNode.m_parent;
        } while (!currentNode.m_containsChange);
    }

    class AttributeNameValue {
        String i_attributeName;
        String i_attributeValue;

        public AttributeNameValue(String attributeName, String attributeValue) {
            this.i_attributeName = attributeName;
            this.i_attributeValue = attributeValue;
        }

        public String getAttributeName() {
            return this.i_attributeName;
        }

        public String getAttributeValue() {
            return this.i_attributeValue;
        }
    }
}

