/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclnt.jsfserver.base.faces.component.UIComponent;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.base.faces.context.ResponseWriter;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.BaseComponentTag;
import org.eclnt.jsfserver.elements.ComponentDump;
import org.eclnt.jsfserver.elements.ComponentRepository;
import org.eclnt.jsfserver.elements.ICCComponentProperties;
import org.eclnt.jsfserver.elements.ICreateUpdateInnerComponents;
import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.jsfserver.elements.impl.IPageIncluder;
import org.eclnt.jsfserver.elements.impl.ROWPAGEBEANINCLUDEComponent;
import org.eclnt.jsfserver.elements.pagemodifier.IPageModifier;
import org.eclnt.jsfserver.pagebean.IPageBean;
import org.eclnt.jsfserver.pagebean.util.FindPageBeanExpressionInPageXml;
import org.eclnt.jsfserver.util.ExpressionManagerV;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.PageReader;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;
import org.eclnt.jsfserver.util.pageparsing.PageSAXParserHandler;
import org.eclnt.jsfserver.util.pageparsing.ParsedNodeBase;
import org.eclnt.jsfserver.util.parse.SAXParserUtil;
import org.eclnt.util.log.CLog;
import org.eclnt.util.logdt.DTLogFactory;
import org.eclnt.util.logdt.ENUMLogCategory;
import org.eclnt.util.valuemgmt.ValueManager;
import org.xml.sax.helpers.DefaultHandler;

public class ROWINCLUDEComponent
extends BaseComponent
implements IPageIncluder,
ICCServerConstants,
ICCComponentProperties,
ICreateUpdateInnerComponents {
    public static final String INCLUDE_SEPARATOR = "";
    static final Object s_syncherInBuildComponentTree = new Object();
    static Map<String, ParsedNode> s_bufferedRootNodes = new Hashtable<String, ParsedNode>();
    static long s_includeIdCounter = 0L;
    Map<String, Integer> m_pageIdPrefixCounter = new Hashtable<String, Integer>();
    int m_idPrefixCounter = 0;
    IParentExitProvider m_parentExitProvider = null;
    String m_idPrefix;
    String m_currentPage = "";
    String m_currentPageinfo = "";
    String m_contentreplace;
    String m_contentreplacedrilldown;
    boolean m_includeDrillDownReplacements = true;
    int m_pageInfoUsage = 0;
    String m_clientName;
    List<ValueManager.NameValue> m_contentreplaceList;
    String m_editorReference;
    private boolean m_firstEncode = true;
    ROWINCLUDEComponent m_parentIncludeComponent = null;
    boolean m_includeEncodeCalledFirstTime = true;
    boolean m_excludeOutestRow = false;
    int m_parentExitCounter = 0;
    boolean m_usedByPageBeanInclude = false;

    @Override
    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.m_idPrefix, this.m_currentPage, this.m_currentPageinfo, this.m_contentreplace, this.m_contentreplacedrilldown, this.m_contentreplaceList, new Boolean(this.m_includeEncodeCalledFirstTime), new Boolean(this.m_excludeOutestRow), this.m_clientName, this.m_includeDrillDownReplacements};
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.m_idPrefix = (String)values[1];
        this.m_currentPage = (String)values[2];
        this.m_currentPageinfo = (String)values[3];
        this.m_contentreplace = (String)values[4];
        this.m_contentreplacedrilldown = (String)values[5];
        this.m_contentreplaceList = (List)values[6];
        this.m_includeEncodeCalledFirstTime = (Boolean)values[7];
        this.m_excludeOutestRow = (Boolean)values[8];
        this.m_clientName = (String)values[9];
        this.m_includeDrillDownReplacements = (Boolean)values[10];
    }

    public ROWINCLUDEComponent() {
        this.setRendersChildren(true);
    }

    public void updateUsageAndRecreateContent() {
        ++this.m_pageInfoUsage;
    }

    public void setIncludeDrillDownReplacements(boolean includeDrillDownReplacements) {
        this.m_includeDrillDownReplacements = includeDrillDownReplacements;
    }

    public boolean isUsedByPageBeanInclude() {
        return this.m_usedByPageBeanInclude;
    }

    public void setUsedByPageBeanInclude(boolean usedByPageBeanInclude) {
        this.m_usedByPageBeanInclude = usedByPageBeanInclude;
    }

    public ROWPAGEBEANINCLUDEComponent getOwningROWPAGEBEANINCLUDEComponent() {
        if (!this.m_usedByPageBeanInclude) {
            return null;
        }
        return (ROWPAGEBEANINCLUDEComponent)this.getParent();
    }

    public List<BaseComponent> getParentSubComponents() {
        if (this.m_parentExitProvider != null) {
            return this.m_parentExitProvider.getParentSubComponents();
        }
        return null;
    }

    public BaseComponent getExitComponent(String id) {
        if (this.m_parentExitProvider != null) {
            return this.m_parentExitProvider.getExitComponent(id);
        }
        return null;
    }

    public int getParentExitCounter() {
        return this.m_parentExitCounter;
    }

    public void resetParentExitCounter() {
        this.m_parentExitCounter = 0;
    }

    public IParentExitProvider getParentExitProvider() {
        return this.m_parentExitProvider;
    }

    public void setParentExitProvider(IParentExitProvider parentExitProvider) {
        this.m_parentExitProvider = parentExitProvider;
    }

    @Override
    public void createUpdateInnerComponents(FacesContext context) {
        this.buildComponentTree();
    }

    @Override
    public long getChangeIndex() {
        return 0L;
    }

    @Override
    public boolean checkIfRowIsExpected() {
        UIComponent parent = this.getParent();
        if (parent != null && parent instanceof IPageIncluder) {
            return ((IPageIncluder)((Object)parent)).checkIfRowIsExpected();
        }
        return true;
    }

    public boolean getExcludeOutestRow() {
        return this.m_excludeOutestRow;
    }

    public void setExcludeOutestRow(boolean excludeOutestRow) {
        this.m_excludeOutestRow = excludeOutestRow;
    }

    public static synchronized long createNewIncludeIdCounter() {
        return s_includeIdCounter++;
    }

    public static void clearLayoutBuffer() {
        CLog.L.log(CLog.LL_INF, "ROWINCLUDE buffer was cleared");
        s_bufferedRootNodes.clear();
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        ROWINCLUDEComponent.ensureSessionIsValid(HttpSessionAccess.getCurrentHttpSessionIfAvailable(context));
        if (this.m_firstEncode) {
            this.m_parentIncludeComponent = this.findParentIncludeComponent();
            this.m_firstEncode = false;
        }
        this.m_clientName = (String)this.getAttributesGet(BaseComponentTag.ATT_clientname);
        this.m_editorReference = this.getAttributeValueAsString(ATT_editorreference);
        this.buildComponentTree();
        this.findCurrentDump(context).pushIncludePage(this.m_currentPage, this.m_contentreplacedrilldown, this.m_contentreplace, this.m_clientName);
        ThreadData.getInstance().getRowincludeDump().beginROWINCLUDE(this.m_currentPage);
    }

    @Override
    public void decode(FacesContext context) {
    }

    @Override
    public void registerInnerEvent(String requestId, BaseComponent.InnerEventBubbleContext bubbleContext) {
        if (bubbleContext == null) {
            bubbleContext = new BaseComponent.InnerEventBubbleContext();
        }
        if (!bubbleContext.getUpdateisolationProcessed()) {
            boolean updateisolation = this.checkIfIncludeComponentSupportsUpdateIsolation();
            if (updateisolation) {
                ThreadData threadData = ThreadData.getInstance();
                threadData.registerIsolatedUpdateZone(this, true);
                ROWINCLUDEComponent current = this.m_parentIncludeComponent;
                while (current != null) {
                    threadData.registerIsolatedUpdateZone(current, false);
                    current = current.m_parentIncludeComponent;
                }
            } else {
                ThreadData threadData = ThreadData.getInstance();
                if (!threadData.checkIfContainedAsIsolatedUpdateZone(this)) {
                    threadData.registerNoIsolation();
                }
            }
            bubbleContext.setUpdateisolationProcessed(true);
        }
        super.registerInnerEvent(requestId, bubbleContext);
    }

    @Override
    public void encodeChildren(FacesContext context) throws IOException {
        ThreadData threadData;
        if (CLog.L.isLoggable(CLog.LL_DBG)) {
            CLog.L.log(CLog.LL_DBG, "ROWINCLUDE - encoding sub components: " + this.m_currentPageinfo);
        }
        if ((threadData = ThreadData.getInstance()).getUpdateAllAreasIsRequired()) {
            if (CLog.L.isLoggable(CLog.LL_DBG)) {
                CLog.L.log(CLog.LL_DBG, "update all araes required ==> encoding: " + this.m_currentPageinfo);
            }
            this.invokeOnBeforeRenderingForPotencialPageBean(context);
            super.encodeChildren(context);
            return;
        }
        boolean eventIsolationUpdateOnInnerEventOnly = false;
        boolean updateoninnereventonly = ValueManager.decodeBoolean(this.getAttributeValueAsString("updateoninnereventonly"), false);
        boolean sessionWasDestroyedDuringInvokePhase = HttpSessionAccess.checkIfCurrentHttpSessionWasDestroyedDuringInvokePhase();
        if (updateoninnereventonly && !HttpSessionAccess.getCurrentRequestId().equals(this.getInnerEventRequestId())) {
            eventIsolationUpdateOnInnerEventOnly = true;
        }
        boolean eventIsolationUpdateIsolation = false;
        if (threadData.getIsolatedUpdateZones().size() > 0 && !this.checkIfIncludedInIsolatedUpdateZones()) {
            eventIsolationUpdateIsolation = true;
        }
        if (eventIsolationUpdateOnInnerEventOnly || eventIsolationUpdateIsolation) {
            ResponseWriter writer = context.getResponseWriter();
            HttpSession session = HttpSessionAccess.getCurrentHttpSession(context);
            ComponentDump currentDump = (ComponentDump)session.getAttribute(threadData.getSubpageId() + "/" + "org.eclnt.jsfserver/currentDump");
            for (UIComponent childObj : this.getChildren()) {
                BaseComponent child = (BaseComponent)childObj;
                child.renderComponentNoChange(context, writer, currentDump);
            }
            if (CLog.L.isLoggable(CLog.LL_DBG)) {
                CLog.L.log(CLog.LL_DBG, "No encoding below this ROWINCLUDE - event isolation, (" + this.m_currentPageinfo + "); eventIsolationUpdateOnInnerEventOnly " + eventIsolationUpdateOnInnerEventOnly + ", eventIsolationUpdateIsolation " + eventIsolationUpdateIsolation);
            }
            return;
        }
        this.invokeOnBeforeRenderingForPotencialPageBean(context);
        super.encodeChildren(context);
    }

    private void invokeOnBeforeRenderingForPotencialPageBean(FacesContext context) {
        block8: {
            try {
                FindPageBeanExpressionInPageXml.RootExpressionResult rer;
                if (this.m_usedByPageBeanInclude) break block8;
                String fullPageName = this.m_currentPage;
                if (!fullPageName.startsWith("/")) {
                    ThreadData threadData = ThreadData.getInstance();
                    HttpSession session = HttpSessionAccess.getCurrentHttpSession(context);
                    ComponentDump currentDump = (ComponentDump)session.getAttribute(threadData.getSubpageId() + "/" + "org.eclnt.jsfserver/currentDump");
                    fullPageName = currentDump.updateIncludedReference(this.m_currentPage);
                }
                if ((rer = FindPageBeanExpressionInPageXml.findRootExpressionInJSP(fullPageName)) == null || rer.getRootExpression() == null) break block8;
                try {
                    Object o;
                    String expression = rer.getRootExpression();
                    if (this.m_contentreplaceList != null && this.m_contentreplaceList.size() > 0) {
                        BaseComponentTag.ReplacementResult rr = BaseComponentTag.executeReplacement(expression, this.m_contentreplaceList);
                        if (rr.replacementExecuted) {
                            expression = rr.value;
                        }
                    }
                    if ((o = ExpressionManagerV.getValueForExpressionString(context, expression)) != null && o instanceof IPageBean) {
                        ((IPageBean)o).onBeforeRendering();
                    }
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_INF, "Could not create root page bean with expression: " + rer.getRootExpression(), t);
                    DTLogFactory.getLog().log(ENUMLogCategory.PROPERTYERROR_IMPL, rer.getRootExpression(), "Could not create root page bean with expression", t);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void encodeEnd(FacesContext context) throws IOException {
        this.findCurrentDump(context).popIncludePage();
        ThreadData threadData = ThreadData.getInstance();
        threadData.getRowincludeDump().endROWINCLUDE();
        ResponseWriter writer = context.getResponseWriter();
        ComponentDump currentDump = this.readCurrentComponentDump(context);
        this.detectChangesInSubComponents(writer, currentDump);
    }

    public void updateComponentTreeThoughNotRendered() {
        this.buildComponentTree();
    }

    @Override
    public void renderComponentNoChange(FacesContext context, ResponseWriter writer, ComponentDump currentDump) throws IOException {
        for (UIComponent childObj : this.getChildren()) {
            BaseComponent child = (BaseComponent)childObj;
            if (!child.isRendered()) continue;
            child.renderComponentNoChange(context, writer, currentDump);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildComponentTree() {
        String pageInfo;
        Object page = this.getAttributesGet("page");
        this.m_contentreplace = (String)this.getAttributesGet("contentreplace");
        this.m_contentreplacedrilldown = (String)this.getAttributesGet("contentreplacedrilldown");
        if (page == null) {
            page = INCLUDE_SEPARATOR;
        }
        if (!(page instanceof String)) {
            return;
        }
        IPageModifier pageModifier = (IPageModifier)this.getAttributesGet(ATT_pagemodifier);
        String pageModifierId = null;
        if (pageModifier != null) {
            pageModifierId = pageModifier.getId();
        }
        if (this.m_currentPageinfo.equals(pageInfo = page + "//" + this.m_contentreplace + "//" + this.m_contentreplacedrilldown + "//" + pageModifierId + "//" + this.m_pageInfoUsage) && !ThreadData.getInstance().getCurrentRequestRebuildsContent()) {
            return;
        }
        ComponentDump currentDump = this.findCurrentDump(HttpSessionAccess.getCurrentFacesContext());
        if (CLog.L.isLoggable(CLog.LL_DBG)) {
            CLog.L.log(CLog.LL_DBG, "ROWINCLUDE component tree is built: " + page + " /CPDD: " + currentDump.getCurrentContentReplaceWithDrillDown() + " /CP: " + this.m_contentreplace + " /PAGEMODIFIER: " + pageModifierId + " /PAGEINFOUSAGE: " + this.m_pageInfoUsage);
        }
        this.registerInnerEvent(HttpSessionAccess.getCurrentRequestId(), null);
        this.m_contentreplaceList = null;
        this.m_currentPageinfo = pageInfo;
        this.m_currentPage = (String)page;
        this.m_idPrefix = this.determineIdPrefix(this.m_currentPage, pageInfo);
        this.clearAndDestroyChildren();
        if (this.m_currentPage.equals(INCLUDE_SEPARATOR)) {
            return;
        }
        this.resetParentExitCounter();
        try {
            Object jsp = null;
            String fullPageName = currentDump.updateIncludedReference(this.m_currentPage);
            ParsedNode bufferedNode = null;
            String bufferedNodeKey = fullPageName + "/" + pageModifierId;
            if (SystemXml.getLayoutBufferActive()) {
                bufferedNode = s_bufferedRootNodes.get(bufferedNodeKey);
            }
            if (bufferedNode == null) {
                Object object = s_syncherInBuildComponentTree;
                synchronized (object) {
                    if (SystemXml.getLayoutBufferActive()) {
                        bufferedNode = s_bufferedRootNodes.get(bufferedNodeKey);
                    }
                    if (bufferedNode == null) {
                        String xml = PageReader.readXMLForAbsolutePageName(fullPageName);
                        if (xml == null) {
                            xml = ROWINCLUDEComponent.readRescuePage(fullPageName);
                        }
                        currentDump.pushIncludePage(this.m_currentPage, this.m_contentreplacedrilldown, this.m_contentreplace, this.m_clientName);
                        try {
                            ParsedNode firstNode;
                            ParsedNode rootNode = new ParsedNode();
                            IncludeParser includeParser = new IncludeParser(rootNode, pageModifier, this.m_excludeOutestRow, this.m_currentPageinfo);
                            SAXParserUtil.parse(xml, (DefaultHandler)includeParser);
                            includeParser.clearInterimParsingInfo();
                            this.initContentReplaceList();
                            if (rootNode.getSubNodes().size() == 1 && (firstNode = (ParsedNode)rootNode.getSubNodes().get(0)).getAttributeValue("id") == null) {
                                firstNode.setAttributeValue("id", this.createSubId("_CCINCLUDEID_"));
                            }
                            rootNode.render(this, this, this.m_contentreplaceList, this.m_idPrefix, this.m_currentPage);
                            if (SystemXml.getLayoutBufferActive()) {
                                s_bufferedRootNodes.put(bufferedNodeKey, rootNode);
                            }
                        }
                        catch (Throwable t) {
                            CLog.L.log(CLog.LL_ERR, "Error occurred when resolving ROWINCLUDE", t);
                            CLog.L.log(CLog.LL_ERR, "The included page is: " + fullPageName);
                            CLog.L.log(CLog.LL_ERR, "The xml is: \n" + xml);
                        }
                    }
                }
            }
            if (bufferedNode != null) {
                if (CLog.L.isLoggable(CLog.LL_DBG)) {
                    CLog.L.log(CLog.LL_DBG, "included page is taken from buffer");
                }
                currentDump.pushIncludePage(this.m_currentPage, this.m_contentreplacedrilldown, this.m_contentreplace, this.m_clientName);
                this.initContentReplaceList();
                bufferedNode.render(this, this, this.m_contentreplaceList, this.m_idPrefix, this.m_currentPage);
            }
            currentDump.popIncludePage();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, INCLUDE_SEPARATOR, t);
        }
    }

    private static String readRescuePage(String fullPageName) {
        return ROWINCLUDEComponent.readRescuePage(fullPageName, true);
    }

    private static String readRescuePage(String fullPageName, boolean asRow) {
        String result = WebResourceClassloaderReader.readUTF8FileIntoString(SystemXml.getRownincludeRescuePage(), false);
        if (result == null) {
            result = INCLUDE_SEPARATOR;
        }
        result = result.replace("@@PAGENAME@@", ValueManager.encodeIntoValidXMLString(fullPageName));
        if (!asRow) {
            result = "<t:pane>" + result + "</t:pane>";
        }
        result = PageReader.isolateXML(result, false);
        return result;
    }

    private void initContentReplaceList() {
        if (this.m_contentreplaceList == null) {
            this.m_contentreplaceList = this.findContentReplaceListDuringRendering(this.m_includeDrillDownReplacements, true);
        }
    }

    private String determineIdPrefix(String pageName, String pageInfo) {
        try {
            String result = this.getId();
            result = this.removeContainedIncludeSeparators(result);
            int idPrefixCounter = this.findIdPrefixCounter(pageInfo);
            return result + idPrefixCounter;
        }
        catch (Throwable t) {
            return ROWINCLUDEComponent.createNewIncludeIdCounter() + INCLUDE_SEPARATOR;
        }
    }

    private int findIdPrefixCounter(String pageInfo) {
        Integer result = this.m_pageIdPrefixCounter.get(pageInfo);
        if (result == null) {
            result = this.m_idPrefixCounter++;
            this.m_pageIdPrefixCounter.put(pageInfo, result);
        }
        return result;
    }

    private String removeContainedIncludeSeparators(String id) {
        if (INCLUDE_SEPARATOR.length() == 0) {
            return id;
        }
        return id.replace(INCLUDE_SEPARATOR, INCLUDE_SEPARATOR);
    }

    private ROWINCLUDEComponent findParentIncludeComponent() {
        UIComponent current = this.getParent();
        while (current != null) {
            if (!(current instanceof BaseComponent)) {
                return null;
            }
            if (current instanceof ROWINCLUDEComponent) {
                return (ROWINCLUDEComponent)current;
            }
            current = ((BaseComponent)current).getParent();
        }
        return null;
    }

    private boolean checkIfIncludeComponentSupportsUpdateIsolation() {
        ROWINCLUDEComponent current = this;
        while (current != null) {
            boolean iso = ValueManager.decodeBoolean(current.getAttributeValueAsString(ATT_updateisolation), false);
            if (iso) {
                return true;
            }
            current = current.m_parentIncludeComponent;
        }
        return false;
    }

    private boolean checkIfIncludedInIsolatedUpdateZones() {
        ThreadData threadData = ThreadData.getInstance();
        if (threadData.getIsolatedUpdateZones().contains(this)) {
            return true;
        }
        ROWINCLUDEComponent current = this.m_parentIncludeComponent;
        while (current != null) {
            if (threadData.getIsolatedUpdateZonesEntrance().contains(current)) {
                return true;
            }
            current = current.m_parentIncludeComponent;
        }
        return false;
    }

    public static interface IParentExitProvider {
        public BaseComponent getExitComponent(String var1);

        public List<BaseComponent> getParentSubComponents();
    }

    public static class ParsedNode
    extends ParsedNodeBase {
        Class i_componentTagClass;

        @Override
        public void setName(String name) {
            try {
                super.setName(name);
                this.i_componentTagClass = ComponentRepository.createComponentTagClass(this.getTagPrefix(), this.getTagName());
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, ROWINCLUDEComponent.INCLUDE_SEPARATOR, t);
            }
        }

        @Override
        public ParsedNode createSubNode() {
            ParsedNode result = new ParsedNode();
            this.getSubNodes().add(result);
            return result;
        }

        /*
         * Unable to fully structure code
         */
        public void render(ROWINCLUDEComponent parentIncludeComponent, UIComponent parentComponent, List<ValueManager.NameValue> contentreplaceList, String idPrefixInclude, String currentPage) {
            try {
                component = null;
                if (this.getTagName() != null && !this.getTagName().equals("parentexit")) {
                    componentTag = (BaseComponentTag)this.i_componentTagClass.newInstance();
                    for (i = 0; i < this.getAttributes().size(); ++i) {
                        nav = this.getAttributes().get(i);
                        qName = nav.getName();
                        value = nav.getValue();
                        if (qName.equals("id")) {
                            idValue = value = "" + idPrefixInclude + "-" + value;
                            componentTag.setId(idValue);
                            continue;
                        }
                        if (qName.equals(ICCComponentProperties.ATT_focussequence) && value != null && value.length() > 0 && !value.startsWith(".{") && !value.startsWith("#{") && !value.startsWith("ccfix_")) {
                            value = idPrefixInclude + "_" + value;
                        }
                        componentTag.invokeSetter(qName, value);
                    }
                    if (currentPage != null) {
                        pageInfo = null;
                        if (SystemXml.getClientAddOnDataWithPageInfo()) {
                            pageInfo = currentPage;
                        }
                        if (pageInfo != null) {
                            componentTag.setPageinfo(pageInfo);
                        }
                    }
                    if (contentreplaceList != null && contentreplaceList.size() > 0) {
                        componentTag.defineContentReplacements(contentreplaceList);
                    }
                    if (parentIncludeComponent != null && parentIncludeComponent.m_editorReference != null) {
                        componentTag.setEditorreference(parentIncludeComponent.m_editorReference);
                    }
                    component = componentTag.createBaseComponent();
                    ((BaseComponent)component).setIncludingROWINCLUDE(parentIncludeComponent);
                    parentComponent.getChildren().add(component);
                } else if (this.getTagName() != null && this.getTagName().equals("parentexit")) {
                    exitId = this.getAttributeValue(ParsedNode.ATT_exitid);
                    if (exitId == null) {
                        throw new Error("PARENTEXIT must always be defined with attribute EXITID");
                    }
                    try {
                        if (!"allchildren".equals(ValueManager.toLowerCaseId(exitId))) {
                            exitComponent = parentIncludeComponent.getExitComponent(exitId);
                            if (exitComponent == null) ** GOTO lbl55
                            parentComponent.getChildren().add(exitComponent);
                        }
                        exitComponents = parentIncludeComponent.getParentSubComponents();
                        if (exitComponents == null) ** GOTO lbl55
                        for (BaseComponent exitComponent : exitComponents) {
                            parentComponent.getChildren().add(exitComponent);
                        }
                    }
                    catch (Throwable t) {
                        CLog.L.log(CLog.LL_INF, "Problem including PARENTEXIT component: " + parentIncludeComponent.m_parentExitCounter, t);
                    }
                } else if (this.getTagName() == null) {
                    component = parentComponent;
                }
lbl55:
                // 10 sources

                for (ParsedNodeBase subNode : this.getSubNodes()) {
                    ((ParsedNode)subNode).render(parentIncludeComponent, component, contentreplaceList, idPrefixInclude, currentPage);
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "", t);
            }
        }
    }

    class IncludeParser
    extends PageSAXParserHandler<ParsedNode> {
        IPageModifier i_pageModifier;

        public IncludeParser(ParsedNode rootNode, IPageModifier pageModifier, boolean excludeOutestRow, String currentPageinfo) {
            super(rootNode, excludeOutestRow, currentPageinfo);
            this.i_pageModifier = pageModifier;
        }

        @Override
        protected void updateNodeAfterCreation(ParsedNode pn) {
            super.updateNodeAfterCreation(pn);
            if (this.i_pageModifier != null) {
                this.i_pageModifier.updateParsedNode(pn);
            }
        }
    }
}

