/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.elements.componentnodes.FOLDABLEPANENode;
import org.eclnt.jsfserver.elements.componentnodes.PANENode;
import org.eclnt.jsfserver.elements.componentnodes.ROWNode;
import org.eclnt.jsfserver.elements.componentnodes.ROWPAGEBEANINCLUDENode;
import org.eclnt.jsfserver.elements.events.BaseActionEventDrop;
import org.eclnt.jsfserver.elements.impl.DYNAMICCONTENTBinding;
import org.eclnt.jsfserver.elements.impl.TILEDAREAColumnInfo;
import org.eclnt.jsfserver.elements.impl.TILEDAREAInfo;
import org.eclnt.jsfserver.elements.impl.TILEDAREATileInfo;
import org.eclnt.jsfserver.elements.phases.PhaseManager;
import org.eclnt.jsfserver.pagebean.IPageBean;
import org.eclnt.jsfserver.streamstore.IStreamStore;
import org.eclnt.jsfserver.streamstore.StreamStore;
import org.eclnt.jsfserver.util.useraccess.UserAccessMgr;
import org.eclnt.jsfserver.util.valuemgmt.IDynamicContentBindingObject;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;

public class TILEDAREABinding
implements Serializable,
IDynamicContentBindingObject {
    DYNAMICCONTENTBinding m_content = new DYNAMICCONTENTBinding();
    List<Tile> m_tilesList = new ArrayList<Tile>();
    Map<String, Tile> m_tiles = new HashMap<String, Tile>();
    TILEDAREAInfo m_info = new TILEDAREAInfo();
    String m_objectbinding = null;
    String m_persistid = null;
    IPersist m_persistor = null;
    boolean m_dragTitleOnly = false;
    String m_ddid = UniqueIdCreator.createId();
    Runnable m_persistLayoutRunnable = new Runnable(){

        @Override
        public void run() {
            TILEDAREABinding.this.persistLayout();
        }
    };

    public Map<String, Tile> getTiles() {
        return this.m_tiles;
    }

    public DYNAMICCONTENTBinding getContent() {
        return this.m_content;
    }

    public IPersist getPersistor() {
        return this.m_persistor;
    }

    public void setPersistor(IPersist persistor) {
        this.m_persistor = persistor;
    }

    public boolean getDragTitleOnly() {
        return this.m_dragTitleOnly;
    }

    public void setDragTitleOnly(boolean dragTitleOnly) {
        this.m_dragTitleOnly = dragTitleOnly;
    }

    public void addTile(String id, String title, IPageBean pageBean) {
        Tile tile = new Tile(id, title, pageBean, null);
        this.m_tiles.put(id, tile);
        this.m_tilesList.add(tile);
        this.m_info = null;
    }

    public void addTile(String id, String title, IPageBean pageBean, String height) {
        Tile tile = new Tile(id, title, pageBean, height);
        this.m_tiles.put(id, tile);
        this.m_tilesList.add(tile);
        this.m_info = null;
    }

    public void clearTiles() {
        this.m_tiles.clear();
        this.m_tilesList.clear();
        this.m_info = null;
    }

    public TILEDAREAInfo getLayout() {
        return this.m_info;
    }

    public void setLayout(TILEDAREAInfo value) {
        this.m_info = value;
    }

    public void setObjectbinding(String objectbinding) {
        if (ValueManager.checkIfStringsAreEqual(objectbinding, this.m_objectbinding)) {
            return;
        }
        this.m_objectbinding = objectbinding;
        this.render();
    }

    public void rerenderIfNoLayout() {
        if (this.m_info != null) {
            return;
        }
        this.render();
    }

    public String getPersistid() {
        return this.m_persistid;
    }

    public void setPersistid(String value) {
        this.m_persistid = value;
    }

    public void onDropAction(ActionEvent event) {
        if (event instanceof BaseActionEventDrop) {
            BaseActionEventDrop e = (BaseActionEventDrop)event;
            String comment = e.getSourceComment();
            int colonIndex = e.getDragInfo().indexOf(58);
            String movedTileId = e.getDragInfo().substring(colonIndex + 1);
            if (comment.startsWith("COL_")) {
                int newColumnIndex = ValueManager.decodeInt(comment.substring(4), 0);
                this.addNewColumn(newColumnIndex);
                this.moveTile(movedTileId, newColumnIndex, 0);
            } else if (comment.startsWith("ROW_")) {
                String indices = comment.substring(4);
                int slashIndex = indices.indexOf(95);
                int newColumnIndex = ValueManager.decodeInt(indices.substring(0, slashIndex), 0);
                int newRowIndex = ValueManager.decodeInt(indices.substring(slashIndex + 1), 0);
                this.moveTile(movedTileId, newColumnIndex, newRowIndex);
            }
            this.removeEmptyColumns();
            this.render();
            if (this.m_persistid != null) {
                this.persistLayout();
            }
        }
    }

    protected void addNewColumn(int newColumnIndex) {
        TILEDAREAColumnInfo tci = new TILEDAREAColumnInfo();
        this.m_info.getColumns().add(newColumnIndex, tci);
    }

    protected void moveTile(String id, int newColumnIndex, int newRowIndex) {
        int colIndex = 0;
        int rowIndex = 0;
        boolean foundIt = false;
        for (TILEDAREAColumnInfo tci : this.m_info.getColumns()) {
            rowIndex = 0;
            for (TILEDAREATileInfo tti : tci.getTiles()) {
                if (id.equals(tti.getId())) {
                    foundIt = true;
                    break;
                }
                ++rowIndex;
            }
            if (foundIt) break;
            ++colIndex;
        }
        if (!foundIt) {
            return;
        }
        if (newColumnIndex == colIndex && (newRowIndex == rowIndex || newRowIndex == rowIndex + 1)) {
            return;
        }
        TILEDAREATileInfo tileInfo = this.m_info.getColumns().get(colIndex).getTiles().get(rowIndex);
        if (newColumnIndex != colIndex) {
            this.m_info.getColumns().get(newColumnIndex).getTiles().add(newRowIndex, tileInfo);
            this.m_info.getColumns().get(colIndex).getTiles().remove(rowIndex);
        } else {
            this.m_info.getColumns().get(newColumnIndex).getTiles().add(newRowIndex, tileInfo);
            if (newRowIndex > rowIndex) {
                this.m_info.getColumns().get(newColumnIndex).getTiles().remove(rowIndex);
            } else {
                this.m_info.getColumns().get(newColumnIndex).getTiles().remove(rowIndex + 1);
            }
        }
    }

    protected void removeEmptyColumns() {
        for (int i = this.m_info.getColumns().size() - 1; i >= 0; --i) {
            TILEDAREAColumnInfo taci = this.m_info.getColumns().get(i);
            if (taci.getTiles().size() != 0) continue;
            this.m_info.getColumns().remove(i);
        }
    }

    protected void render() {
        if (this.m_objectbinding == null) {
            return;
        }
        if (this.m_info == null) {
            this.loadLayout();
        }
        PANENode outestPane = new PANENode();
        outestPane.setWidth("100%");
        outestPane.setHeight("100%");
        ROWNode outestRow = new ROWNode();
        outestPane.addSubNode(outestRow);
        int columnsCounter = 0;
        for (TILEDAREAColumnInfo taci : this.m_info.getColumns()) {
            if (columnsCounter == 0) {
                PANENode leftDistancePane = new PANENode();
                outestRow.addSubNode(leftDistancePane);
                leftDistancePane.setHeight("100%");
                leftDistancePane.setDropreceive("CCTILE" + this.m_ddid);
                leftDistancePane.setComment("COL_" + columnsCounter);
                leftDistancePane.setActionListener(this.m_objectbinding.replace("}", ".onDropAction}"));
                leftDistancePane.setStylevariant("CCTILEDAREA_HORIZONTALDISTANCEPANE");
            }
            PANENode columnContentPane = new PANENode();
            outestRow.addSubNode(columnContentPane);
            columnContentPane.setWidth("100%");
            columnContentPane.setHeight("100%");
            columnContentPane.setRowalignmenty("top");
            int tileCounter = 0;
            for (TILEDAREATileInfo tati : taci.getTiles()) {
                if (tileCounter == 0) {
                    ROWNode topDistanceRow = new ROWNode();
                    columnContentPane.addSubNode(topDistanceRow);
                    PANENode topDistancePane = new PANENode();
                    topDistanceRow.addSubNode(topDistancePane);
                    topDistancePane.setWidth("100%");
                    topDistancePane.setDropreceive("CCTILE" + this.m_ddid);
                    topDistancePane.setComment("ROW_" + columnsCounter + "_" + tileCounter);
                    topDistancePane.setActionListener(this.m_objectbinding.replace("}", ".onDropAction}"));
                    topDistancePane.setStylevariant("CCTILEDAREA_VERTICALDISTANCEPANE");
                }
                ROWNode foldablePaneRow = new ROWNode();
                columnContentPane.addSubNode(foldablePaneRow);
                Tile tile = this.m_tiles.get(tati.getId());
                FOLDABLEPANENode foldablePane = new FOLDABLEPANENode();
                foldablePaneRow.addSubNode(foldablePane);
                foldablePane.setDragtitleonly(this.m_dragTitleOnly);
                foldablePane.setText(this.m_objectbinding.replace("}", ".tiles[\"" + tati.getId() + "\"].title}"));
                foldablePane.setOpened(this.m_objectbinding.replace("}", ".tiles[\"" + tati.getId() + "\"].openedByUI}"));
                foldablePane.setActionListener(this.m_objectbinding.replace("}", ".tiles[\"" + tati.getId() + "\"].onFoldablePaneAction}"));
                if (tile.i_height != null) {
                    foldablePane.setHeight(tile.i_height);
                }
                foldablePane.setWidth("100%");
                foldablePane.setDragsend("CCTILE" + this.m_ddid + ":" + tati.getId());
                foldablePane.setStylevariant("CCTILEDAREA_FOLDABLEPANE");
                ROWPAGEBEANINCLUDENode rowPageBeanInclude = new ROWPAGEBEANINCLUDENode();
                foldablePane.addSubNode(rowPageBeanInclude);
                rowPageBeanInclude.setPagebeanbinding(this.m_objectbinding.replace("}", ".tiles[\"" + tati.getId() + "\"].pageBean}"));
                ROWNode bottomDistanceRow = new ROWNode();
                columnContentPane.addSubNode(bottomDistanceRow);
                PANENode bottomDistancePane = new PANENode();
                bottomDistanceRow.addSubNode(bottomDistancePane);
                bottomDistancePane.setWidth("100%");
                bottomDistancePane.setDropreceive("CCTILE" + this.m_ddid);
                bottomDistancePane.setComment("ROW_" + columnsCounter + "_" + (tileCounter + 1));
                bottomDistancePane.setActionListener(this.m_objectbinding.replace("}", ".onDropAction}"));
                bottomDistancePane.setStylevariant("CCTILEDAREA_VERTICALDISTANCEPANE");
                ++tileCounter;
            }
            PANENode rightDistancePane = new PANENode();
            outestRow.addSubNode(rightDistancePane);
            rightDistancePane.setHeight("100%");
            rightDistancePane.setDropreceive("CCTILE" + this.m_ddid);
            rightDistancePane.setComment("COL_" + (columnsCounter + 1));
            rightDistancePane.setActionListener(this.m_objectbinding.replace("}", ".onDropAction}"));
            rightDistancePane.setStylevariant("CCTILEDAREA_HORIZONTALDISTANCEPANE");
            ++columnsCounter;
        }
        this.m_content.setContentNode(outestPane);
    }

    protected void loadLayout() {
        if (this.m_persistor != null) {
            this.m_persistor.load(this);
        } else {
            this.m_info = new TILEDAREAInfo();
            try {
                String currentUser = UserAccessMgr.getCurrentUser();
                String xml = StreamStore.getInstance().readUTF8("cctiledarea/" + currentUser + "/" + this.m_persistid + ".xml", true);
                StringReader r = new StringReader(xml);
                JAXBContext jbContext = JAXBContext.newInstance((Class[])new Class[]{TILEDAREAInfo.class});
                Unmarshaller um = jbContext.createUnmarshaller();
                this.m_info = (TILEDAREAInfo)um.unmarshal((Reader)r);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "problem when creating TILEDAREAInfo Object", t);
            }
        }
        HashSet<String> layoutedIds = new HashSet<String>();
        for (TILEDAREAColumnInfo taci : this.m_info.getColumns()) {
            for (int i = taci.getTiles().size() - 1; i >= 0; --i) {
                TILEDAREATileInfo tati = taci.getTiles().get(i);
                if (this.m_tiles.containsKey(tati.getId())) {
                    layoutedIds.add(tati.getId());
                    continue;
                }
                taci.getTiles().remove(i);
            }
        }
        for (Tile tile : this.m_tilesList) {
            if (layoutedIds.contains(tile.i_id)) continue;
            if (this.m_info.getColumns().size() == 0) {
                this.m_info.getColumns().add(new TILEDAREAColumnInfo());
            }
            TILEDAREATileInfo tati = new TILEDAREATileInfo();
            tati.setId(tile.i_id);
            this.m_info.getColumns().get(0).getTiles().add(tati);
        }
        this.removeEmptyColumns();
        for (TILEDAREAColumnInfo taci : this.m_info.getColumns()) {
            for (TILEDAREATileInfo tati : taci.getTiles()) {
                Tile tile = this.m_tiles.get(tati.getId());
                if (tile == null) continue;
                tile.setOpened(!tati.isFolded());
            }
        }
    }

    protected void persistLayout() {
        for (TILEDAREAColumnInfo taci : this.m_info.getColumns()) {
            for (TILEDAREATileInfo tati : taci.getTiles()) {
                Tile tile = this.m_tiles.get(tati.getId());
                if (tile == null) continue;
                tati.setFolded(tile.i_folded);
            }
        }
        if (this.m_persistor != null) {
            this.m_persistor.persist(this);
        } else {
            try {
                JAXBContext jbContext = JAXBContext.newInstance((Class[])new Class[]{TILEDAREAInfo.class});
                Marshaller m = jbContext.createMarshaller();
                m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                m.setProperty("jaxb.encoding", (Object)"UTF-8");
                StringWriter writer = new StringWriter();
                m.marshal((Object)this.m_info, (Writer)writer);
                String result = ((Object)writer).toString();
                IStreamStore streamStore = StreamStore.getInstance();
                String currentUser = UserAccessMgr.getCurrentUser();
                streamStore.writeUTF8("cctiledarea/" + currentUser + "/" + this.m_persistid + ".xml", result, true);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Error when persisting tile area info", t);
                Statusbar.outputError(t.toString());
            }
        }
    }

    public static interface IPersist {
        public void persist(TILEDAREABinding var1);

        public void load(TILEDAREABinding var1);
    }

    public class Tile {
        String i_id;
        String i_title;
        IPageBean i_pageBean;
        boolean i_folded = false;
        String i_height = null;

        public Tile(String id, String title, IPageBean pageBean, String height) {
            this.i_id = id;
            this.i_title = title;
            this.i_pageBean = pageBean;
            this.i_height = height;
        }

        public IPageBean getPageBean() {
            return this.i_pageBean;
        }

        public String getTitle() {
            return this.i_title;
        }

        public boolean getOpened() {
            return !this.i_folded;
        }

        public void setOpened(boolean value) {
            this.i_folded = !value;
        }

        public boolean getOpenedByUI() {
            return this.getOpened();
        }

        public void setOpenedByUI(boolean value) {
            this.setOpened(value);
            PhaseManager.runAfterInvokePhase(TILEDAREABinding.this.m_persistLayoutRunnable);
        }

        public String getHeight() {
            return this.i_height;
        }
    }
}

