/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.phases;

import java.io.Serializable;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.base.faces.event.PhaseEvent;
import org.eclnt.jsfserver.base.faces.event.PhaseId;
import org.eclnt.jsfserver.base.faces.event.PhaseListener;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.phases.PhaseManager;
import org.eclnt.jsfserver.elements.phases.PhaseRunnables;
import org.eclnt.jsfserver.session.SessionInfo;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ISessionAbstraction;
import org.eclnt.jsfserver.util.StackedValueKeeper;
import org.eclnt.util.log.CLog;

public class EclntPhaseListener
implements PhaseListener,
Serializable {
    public void beforePhase(PhaseEvent event) {
        this.registerFacesContextInDialogSession();
        try {
            BaseComponent.ensureSessionIsValid(HttpSessionAccess.getCurrentHttpSessionIfAvailable(event.getFacesContext()));
            CLog.L.log(CLog.LL_INF, "JSF PHASE starting: " + event.getPhaseId().toString());
            if (event.getPhaseId() == PhaseId.UPDATE_MODEL_VALUES) {
                PhaseRunnables prs = PhaseManager.getPhaseRunnables();
                if (prs != null) {
                    prs.runBeforeUpdateRunnables();
                }
            } else if (event.getPhaseId() == PhaseId.INVOKE_APPLICATION) {
                PhaseRunnables prs = PhaseManager.getPhaseRunnables();
                if (prs != null) {
                    prs.runBeforeInvokeRunnables();
                }
            } else if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
                SessionInfo.getSessionInstance().applyLocaleSettingsBeforeRendering(event.getFacesContext());
                PhaseRunnables prs = PhaseManager.getPhaseRunnables();
                if (prs != null) {
                    prs.runBeforeRenderResponseRunnables();
                }
                try {
                    StackedValueKeeper.getInstance().renderingBegins();
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "Problems when passing info to quick fetch management", t);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void registerFacesContextInDialogSession() {
        try {
            FacesContext fc = FacesContext.getCurrentInstance();
            ISessionAbstraction dialogSession = HttpSessionAccess.getCurrentDialogSession();
            dialogSession.setAttribute("ccfacescontext", fc);
            dialogSession.setAttribute("ccelcontext", fc.getELContext());
            dialogSession.setAttribute("ccapplication", fc.getApplication());
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem registering faces context in dialog session");
        }
    }

    public void afterPhase(PhaseEvent event) {
        try {
            BaseComponent.ensureSessionIsValid(HttpSessionAccess.getCurrentHttpSessionIfAvailable(event.getFacesContext()));
            CLog.L.log(CLog.LL_INF, "JSF PHASE ended: " + event.getPhaseId().toString());
            if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
                SessionInfo.getSessionInstance().applyLocaleSettingsAfterRestoringView(event.getFacesContext());
            } else if (event.getPhaseId() == PhaseId.UPDATE_MODEL_VALUES) {
                PhaseRunnables prs = PhaseManager.getPhaseRunnables();
                if (prs != null) {
                    prs.runAfterUpdateRunnables();
                }
            } else if (event.getPhaseId() == PhaseId.INVOKE_APPLICATION) {
                PhaseRunnables prs = PhaseManager.getPhaseRunnables();
                if (prs != null) {
                    prs.runAfterInvokeRunnables();
                }
            } else if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
                PhaseRunnables prs = PhaseManager.getPhaseRunnables();
                if (prs != null) {
                    prs.runAfterRenderResponseRunnables();
                }
                StackedValueKeeper.getInstance().renderingEnds();
                SessionInfo.getSessionInstance().applyLocaleSettingsAfterRendering(event.getFacesContext());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

