/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.messages;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclnt.jsfserver.messages.CrossDialogMessage;
import org.eclnt.jsfserver.messages.DialogMessageBus;
import org.eclnt.util.log.CLog;

class ClientMessageBus {
    static Map<String, ClientMessageBus> s_clientMessageBusMap = new Hashtable<String, ClientMessageBus>();
    Set<DialogMessageBus> m_dialogMessageBusInstances = new HashSet<DialogMessageBus>();
    String m_clientId;

    public ClientMessageBus(String clientId) {
        this.m_clientId = clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ClientMessageBus instance(String clientId, boolean createIfNotExists) {
        ClientMessageBus result = s_clientMessageBusMap.get(clientId);
        if (result == null && createIfNotExists) {
            Map<String, ClientMessageBus> map = s_clientMessageBusMap;
            synchronized (map) {
                result = s_clientMessageBusMap.get(clientId);
                if (result == null) {
                    result = new ClientMessageBus(clientId);
                    s_clientMessageBusMap.put(clientId, result);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishMessage(CrossDialogMessage message) {
        if (message == null) {
            return;
        }
        HashSet<DialogMessageBus> dmbs = null;
        Set<DialogMessageBus> set = this.m_dialogMessageBusInstances;
        synchronized (set) {
            dmbs = new HashSet<DialogMessageBus>(this.m_dialogMessageBusInstances);
        }
        for (DialogMessageBus dmb : dmbs) {
            try {
                dmb.publishMessage(message);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem executing message: " + t, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void registerDialogMessageBus(DialogMessageBus dmb) {
        if (dmb == null) {
            return;
        }
        Set<DialogMessageBus> set = this.m_dialogMessageBusInstances;
        synchronized (set) {
            this.m_dialogMessageBusInstances.add(dmb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void unregisterDialogMessageBus(DialogMessageBus dmb) {
        if (dmb == null) {
            return;
        }
        Set<DialogMessageBus> set = this.m_dialogMessageBusInstances;
        synchronized (set) {
            this.m_dialogMessageBusInstances.remove(dmb);
        }
    }
}

