/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.onlinehelp;

import jakarta.servlet.ServletContext;
import java.util.List;
import org.eclnt.jsfserver.onlinehelp.defaultimpl.OnlineHelpProcessorJBrowser;
import org.eclnt.jsfserver.onlinehelp.defaultimpl.OnlineHelpReader;
import org.eclnt.jsfserver.util.parse.SAXParserUtil;
import org.eclnt.util.file.EclntConfigFileReader;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OnlineHelpConfiguration {
    static String s_contentdirectory = "/onlinehelp/";
    static String s_onlinehelpreader = OnlineHelpReader.class.getName();
    static String s_onlinehelpprocessor = OnlineHelpProcessorJBrowser.class.getName();
    static int s_popupwidth = 400;
    static int s_popupheight = 300;

    public static void initialize(ServletContext servletContext) {
        List<String> xmls = EclntConfigFileReader.readConfiguration("onlinehelp", false);
        for (String xml : xmls) {
            try {
                if (xml == null || xml.length() <= 0) continue;
                SAXParserUtil.parse(xml, (DefaultHandler)new OnlineHelpParser());
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Error occurred when initializing the online help management.", t);
                throw new Error("Error occurred when initializing the online help management.");
            }
        }
    }

    public static String getContentDirectory() {
        return s_contentdirectory;
    }

    public static String getOnlineHelpProcessor() {
        return s_onlinehelpprocessor;
    }

    public static String getOnlineHelpReader() {
        return s_onlinehelpreader;
    }

    public static int getPopupwidth() {
        return s_popupwidth;
    }

    public static int getPopupheight() {
        return s_popupheight;
    }

    static class OnlineHelpParser
    extends DefaultHandler {
        OnlineHelpParser() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("onlinehelp")) {
                String popupheight;
                String popupwidth;
                String onlinehelpprocessor;
                String onlinehelpreader;
                String contentdirectory = attributes.getValue("contentdirectory");
                if (contentdirectory != null) {
                    if (!contentdirectory.startsWith("/")) {
                        contentdirectory = "/" + contentdirectory;
                    }
                    if (!contentdirectory.endsWith("/")) {
                        contentdirectory = contentdirectory + "/";
                    }
                    s_contentdirectory = contentdirectory;
                }
                if ((onlinehelpreader = attributes.getValue("onlinehelpreader")) != null) {
                    s_onlinehelpreader = onlinehelpreader;
                }
                if ((onlinehelpprocessor = attributes.getValue("onlinehelpprocessor")) != null) {
                    s_onlinehelpprocessor = onlinehelpprocessor;
                }
                if ((popupwidth = attributes.getValue("popupwidth")) != null) {
                    s_popupwidth = ValueManager.decodeIntWithRounding(popupwidth, 400);
                }
                if ((popupheight = attributes.getValue("popupheight")) != null) {
                    s_popupheight = ValueManager.decodeIntWithRounding(popupheight, 300);
                }
            }
        }
    }
}

