/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.starter;

import com.veracode.annotation.XSSCleanser;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclnt.jsfserver.configuration.CCConfigurationObject;
import org.eclnt.jsfserver.elements.ComponentRepository;
import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.session.SessionInfo;
import org.eclnt.jsfserver.starter.DefaultStartPageChecker;
import org.eclnt.jsfserver.starter.IStartPageChecker;
import org.eclnt.jsfserver.starter.IVersionStamp;
import org.eclnt.jsfserver.util.CCServletBase;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.ThreadContextInitializerFilter;
import org.eclnt.jsfserver.util.TypeOfSessionMgmt;
import org.eclnt.jsfserver.util.VersionXml;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;
import org.eclnt.jsfserver.util.WebResourceReader;
import org.eclnt.jsfserver.util.buffermgmt.CCResetBuffers;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.file.ConfigFileReader;
import org.eclnt.util.log.CLog;
import org.eclnt.util.mitigation.CCMitigation;
import org.eclnt.util.valuemgmt.ValueManager;
import org.owasp.esapi.ESAPI;

public class RISCStarter
extends CCServletBase
implements ICCServerConstants {
    static CCConfigurationObject<IVersionStamp> s_versionStamp = null;
    static CCConfigurationObject<IStartPageChecker> s_startPageChecker = null;
    static final String COMMENT_writeTemplateToRepsone = "The content that is written into the response is an HTML text that is created from a template, in which certain placeholders are replaced with actual values. The template must be part of the resources of the application, i.e. it is not possible to e.g. reference a template from outside by URL. Replacements that are based on parameters of the .risc-request are explicitly encoded with ESAPI.encoder().encodeForHTMLAttribute(). Any other replacements are only based on the system configuration,that is part of the local application.";

    public static void initialize(ServletContext context) {
        String cn;
        try {
            cn = SystemXml.getRiscStarter().getVersionstampclassname();
            s_versionStamp = cn != null ? new CCConfigurationObject(cn, null) : new CCConfigurationObject<Object>(null);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem creating instance of IVersionStamp", t);
        }
        try {
            cn = SystemXml.getRiscStarter().getStartpagecheckerclassname();
            s_startPageChecker = cn != null ? new CCConfigurationObject(cn, null) : new CCConfigurationObject<DefaultStartPageChecker>(new DefaultStartPageChecker());
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem creating instance of IStartPageChecker", t);
            throw new Error("Problem creating instance of IStartPageChecker", t);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.checkAvailabilityOfSystem();
            TypeOfSessionMgmt.associateRISCClientWithCurrentThread(this);
            String method = req.getMethod();
            CLog.L.log(CLog.LL_INF, "RISC request is started");
            String uri = req.getRequestURI();
            boolean uriContainedExplicitJSessionid = false;
            int index = uri.indexOf(";jsessionid=");
            if (index >= 0) {
                uri = uri.substring(0, index);
                uriContainedExplicitJSessionid = true;
            }
            String pageNameToShow = this.findPageNameInURI(uri);
            this.checkIfPageCanBeDirectlyStarted(req, pageNameToShow);
            String page = pageNameToShow;
            if (!page.contains("zz_cceditoraround.jsp")) {
                String version = VersionXml.getVersion();
                page = "eclntjsfserver/includes/ccaround.jsp?ccaroundoutestpage=" + page;
                if (!version.contains("undefined") && version.compareTo("20240111") < 0) {
                    page = "eclntjsfserver/includes/ccaround_before20240111.jsp?ccaroundoutestpage=" + page;
                }
            }
            HttpSession session = req.getSession();
            CLog.L.log(CLog.LL_INF, "The http session id is: " + session.getId());
            TypeOfSessionMgmt.associateRISCClientWithSession(session);
            if (!TypeOfSessionMgmt.getSessionMgmtViaCookie(false)) {
                String s = (String)session.getAttribute(this.getClass().getName() + "_touched");
                if (s == null) {
                    CLog.L.log(CLog.LL_INF, "Session was not used so far - now mark as touched!");
                    session.setAttribute(this.getClass().getName() + "_touched", (Object)"touched");
                } else if (!uriContainedExplicitJSessionid) {
                    CLog.L.log(CLog.LL_INF, "Session was already used - invalidated!");
                    session.invalidate();
                }
            }
            this.manageHeaderParametersIframeEmbedding(req, pageNameToShow, resp);
            ServletUtil.setResponseHeader(resp, "eclnt-httpsessionid", session.getId());
            String req_ccstyle = ESAPI.encoder().encodeForJavaScript(req.getParameter("ccstyle"));
            String req_cctitle = ValueManager.encodeIntoValidXMLString(req.getParameter("cctitle"));
            String req_ccpageicon = ValueManager.encodeIntoValidXMLString(req.getParameter("ccpageicon"));
            String req_ccexttitles = ESAPI.encoder().encodeForJavaScript(req.getParameter("ccexttitles"));
            String req_ccscale = ESAPI.encoder().encodeForJavaScript(req.getParameter("ccscale"));
            String req_ccdw = ESAPI.encoder().encodeForJavaScript(req.getParameter("ccdw"));
            String req_preview = req.getParameter("cc_preview");
            String req_nowelcome = req.getParameter("ccnowelcome");
            String req_suppressborderradius = req.getParameter("ccsuppressborderradius");
            RISCStarter.resetBuffers(req);
            String ccstyleParam = req_ccstyle;
            if (ccstyleParam == null) {
                ccstyleParam = SessionInfo.getSessionDefaultStyleForRISCClient();
            }
            String cctitleParam = SystemXml.getRiscStarter().getTitle();
            if (req_cctitle != null) {
                cctitleParam = req_cctitle;
            }
            String ccSwitchExtendedTitlesOn = "false";
            if ("true".equals(req_ccexttitles)) {
                ccSwitchExtendedTitlesOn = "true";
            }
            String pageIcon = SystemXml.getRiscStarter().getPageicon();
            if (req_ccpageicon != null) {
                pageIcon = req_ccpageicon;
            }
            String welcomeStyle = "";
            String welcomeDuration = "0";
            if (!"true".equals(req_preview) && !"true".equals(req_nowelcome)) {
                welcomeStyle = this.buildWelcomeStyle();
                if (SystemXml.getRiscStarter().getWelcomeduration() > 0) {
                    welcomeDuration = "" + SystemXml.getRiscStarter().getWelcomeduration();
                }
            }
            if ("true".equals(req_suppressborderradius)) {
                ServletUtil.writeCookie(resp, "ccsuppressborderradius", null, "true", false, null, false);
            }
            page = this.findePageFolderPrefix() + page;
            page = ValueManager.encodeIntoValidURL(page);
            String includeList = this.buildIncludeList(ESAPI.encoder().encodeForJavaScript(ccstyleParam));
            String scale = req_ccscale;
            if (!(scale != null && ValueManager.decodeFloat(scale, 0.0f) != 0.0f || "auto".equals(scale))) {
                scale = "1";
            }
            String deviceWidth = "800";
            if (req_ccdw != null) {
                deviceWidth = req_ccdw;
            }
            ServletUtil.setResponseContentType(resp, "text/html");
            String template = new ClassloaderReader(HotDeployManager.currentClassLoader()).readUTF8File(SystemXml.getStarttemplateCcRisc(), true);
            String queryString = req.getQueryString();
            if (queryString != null && queryString.indexOf("ccstyle=") < 0) {
                queryString = queryString + "&ccstyle=" + ccstyleParam;
            } else if (queryString == null) {
                queryString = "ccstyle=" + ccstyleParam;
            }
            page = !page.contains("?") ? page + "?" + queryString : page + "&" + queryString;
            if (!TypeOfSessionMgmt.getSessionMgmtViaCookie(false)) {
                page = resp.encodeRedirectURL(page);
            }
            try {
                template = template.replace("@@pagename@@", ESAPI.encoder().encodeForURL(page));
            }
            catch (Throwable t) {
                throw new Error("Could not encode URL: " + page, t);
            }
            String metaAddons = this.buildMetaAddons();
            String linkAddons = this.buildLinkAddons(pageNameToShow);
            template = template.replace("@@eclntIncludes@@", includeList);
            template = template.replace("@@ccmetaaddons@@", metaAddons);
            template = template.replace("@@cclinkaddons@@", linkAddons);
            template = template.replace("@@ccfontaccess@@", "");
            template = template.replace("@@devicewidth@@", ESAPI.encoder().encodeForHTMLAttribute(deviceWidth));
            template = template.replace("@@scale@@", ESAPI.encoder().encodeForHTMLAttribute(scale));
            template = template.replace("@@cctitle@@", ESAPI.encoder().encodeForHTMLAttribute(cctitleParam));
            template = template.replace("@@pageicon@@", ESAPI.encoder().encodeForHTMLAttribute(pageIcon));
            template = template.replace("@@riscwelcomestyle@@", ESAPI.encoder().encodeForHTMLAttribute(welcomeStyle));
            template = template.replace("@@welcomeDuration@@", ESAPI.encoder().encodeForHTMLAttribute(welcomeDuration));
            template = template.replace("@@switchExtendedTitlesOn@@", ESAPI.encoder().encodeForHTMLAttribute(ccSwitchExtendedTitlesOn));
            template = template.replace("@versionStamp@", RISCStarter.buildVersionStamp());
            template = template.replace("@@styleName@@", ESAPI.encoder().encodeForHTMLAttribute(ccstyleParam));
            CLog.L.log(CLog.LL_DBG, "HTML for RISC:\n\n" + template + "\n\n");
            this.writeTemplateToResponse(resp, template);
        }
        catch (IOException io) {
            throw io;
        }
        finally {
            TypeOfSessionMgmt.clearCurrentThread(this);
        }
    }

    protected String buildWelcomeStyle() {
        String welcomeStyle = "";
        if (SystemXml.getRiscStarter().getWelcomeimage() != null) {
            String wwi;
            String wi = SystemXml.getRiscStarter().getWelcomeimage();
            if (wi.startsWith("/")) {
                wi = wi.substring(1);
            }
            if ((wwi = SystemXml.getRiscStarter().getWelcomewaitingimage()) != null) {
                if (wwi.startsWith("/")) {
                    wwi = wwi.substring(1);
                }
                welcomeStyle = welcomeStyle + ";background-image:url(" + wwi + "),url(" + wi + ");background-repeat:no-repeat,no-repeat;background-position:bottom 50px center,center";
            } else {
                welcomeStyle = welcomeStyle + ";background-image:url(eclntjsfserver/images/waiting/waiting.gif),url(" + wi + ");background-repeat:no-repeat,no-repeat;background-position:bottom 50px center,center;background-size:40px 40px,auto";
            }
        }
        if (SystemXml.getRiscStarter().getWelcomebackgroundcolor() != null) {
            String wb = SystemXml.getRiscStarter().getWelcomebackgroundcolor();
            welcomeStyle = welcomeStyle + ";background-color:" + wb;
        }
        if (welcomeStyle.length() > 0) {
            welcomeStyle = welcomeStyle + ";box-sizing:border-box;position:absolute;overflow:hidden;z-index:100;left:0px;top:0px;width:100%;height:100%;";
        }
        return welcomeStyle;
    }

    @XSSCleanser(userComment="The content that is written into the response is an HTML text that is created from a template, in which certain placeholders are replaced with actual values. The template must be part of the resources of the application, i.e. it is not possible to e.g. reference a template from outside by URL. Replacements that are based on parameters of the .risc-request are explicitly encoded with ESAPI.encoder().encodeForHTMLAttribute(). Any other replacements are only based on the system configuration,that is part of the local application.")
    @CCMitigation(cweIds={"80", "201"}, comment="The content that is written into the response is an HTML text that is created from a template, in which certain placeholders are replaced with actual values. The template must be part of the resources of the application, i.e. it is not possible to e.g. reference a template from outside by URL. Replacements that are based on parameters of the .risc-request are explicitly encoded with ESAPI.encoder().encodeForHTMLAttribute(). Any other replacements are only based on the system configuration,that is part of the local application.")
    private void writeTemplateToResponse(HttpServletResponse resp, String template) throws IOException {
        resp.getWriter().write(template);
    }

    private void checkAvailabilityOfSystem() {
        if (ThreadData.getInstance().getHttpRequest() == null) {
            throw new Error("No thread context available.\nThis typically is an indicator that the filter " + ThreadContextInitializerFilter.class.getName() + " is not proecessed. By default this filter is registered automatically.\nWhat could have happened?\n1. you may still use the web.xml based configuration of filters and servlets. In this caseyou have to add the filter with mapping \"*\" to your web.xml to be processed as first filter of the filter chain:  <filter>\r\n    <filter-name>org.eclnt.jsfserver.util.ThreadContextInitializerFilter</filter-name>\r\n    <filter-class>org.eclnt.jsfserver.util.ThreadContextInitializerFilter</filter-class>\r\n  </filter>\r\n  <filter-mapping>\r\n    <filter-name>org.eclnt.jsfserver.util.ThreadContextInitializerFilter</filter-name>\r\n    <url-pattern>*</url-pattern>\r\n  </filter-mapping>\r\n\nWE RECOMMEND TO SWITCH TO THE AUTOMATED REGISTRATION OF FILTERS, LISTENERS AND SERVLETS!\n2. as any filter you can switch off the filter in system.xml. Do not do this with this filter! This one is obligatory!\n");
        }
    }

    private void checkIfPageCanBeDirectlyStarted(HttpServletRequest request, String page) {
        if (s_startPageChecker != null && s_startPageChecker.instance() != null) {
            boolean result;
            if (!page.startsWith("/")) {
                page = "/" + page;
            }
            if (!(result = s_startPageChecker.instance().checkIfPageCanBeDirectlyStarted(request, page))) {
                CLog.L.log(CLog.LL_WAR, "It is not allowed to directly start page: " + page);
                throw new Error("It is not allowed to directly start page: " + page);
            }
        }
    }

    private String buildLinkAddons(String pageNameToShow) {
        boolean bl;
        String versionStamp = RISCStarter.buildVersionStamp();
        StringBuffer sb = new StringBuffer();
        for (SystemXml.RISCClientStyle rISCClientStyle : SystemXml.getRISCClientStyles()) {
            if (rISCClientStyle.getSrc() == null || rISCClientStyle.getSrc().trim().length() <= 0) continue;
            sb.append("<link rel=\"stylesheet\" href=\"" + rISCClientStyle.getSrc() + versionStamp + "\"/>\n");
        }
        List<ComponentRepository.TLDInfo> libraries = ComponentRepository.readCCControllibrariesFromClassLoader();
        for (ComponentRepository.TLDInfo library : libraries) {
            String css = ComponentRepository.findCSSResourcePathForControlLibary(library);
            if (css == null) continue;
            sb.append("<link rel=\"stylesheet\" href=\"" + css + versionStamp + "\"/>\n");
        }
        boolean bl2 = false;
        try {
            List<String> manifestFileContents = ConfigFileReader.readConfigFiles("ccmanifest.json", false, false);
            if (manifestFileContents.size() >= 1) {
                String manifestFileContent = manifestFileContents.get(0);
                sb.append("<link rel=\"manifest\" href=\"ccmanifest.json\"/>\n");
                bl = true;
                if (manifestFileContents.size() > 1) {
                    CLog.L.log(CLog.LL_WAR, "Several occurances of file ccmanifest.json detected - one of them will be chosen. Please make sure that the file only occurs one time.");
                    List<URL> versions = new ClassloaderReader(true).readResourcePaths("ccmanifest.json", false);
                    for (URL version : versions) {
                        CLog.L.log(CLog.LL_WAR, "....." + version.toString());
                    }
                    if (WebResourceReader.checkIfFileExists("ccmanifest.json")) {
                        CLog.L.log(CLog.LL_WAR, ".....webcontent/ccmanifest.json");
                    }
                }
            }
        }
        catch (Throwable manifestFileContents) {
            // empty catch block
        }
        List<SystemXml.RISCClientLink> links = SystemXml.getRISCClientLinks();
        for (SystemXml.RISCClientLink link : links) {
            if ("manifest".equals(link.getRel()) && bl) continue;
            sb.append("<link ");
            if (link.getRel() != null) {
                sb.append("rel=\"" + link.getRel() + "\" ");
            }
            if (link.getHref() != null) {
                sb.append("href=\"" + link.getHref() + "\" ");
            }
            if (link.getHreflang() != null) {
                sb.append("hreflang=\"" + link.getHreflang() + "\" ");
            }
            if (link.getType() != null) {
                sb.append("type=\"" + link.getType() + "\" ");
            }
            if (link.getCrossorigin() != null) {
                sb.append("crossorigin=\"" + link.getCrossorigin() + "\" ");
            }
            sb.append("/>\n");
        }
        return sb.toString();
    }

    private String buildMetaAddons() {
        StringBuffer sb = new StringBuffer();
        List<SystemXml.RISCClientMetaTag> metaTags = SystemXml.getRISCClientMetaTags();
        for (SystemXml.RISCClientMetaTag tag : metaTags) {
            sb.append("<meta ");
            if (tag.getName() != null) {
                sb.append("name=\"");
                sb.append(ESAPI.encoder().encodeForHTMLAttribute(tag.getName()));
                sb.append("\" ");
            }
            if (tag.getHttpequiv() != null) {
                sb.append("http-equiv=\"");
                sb.append(ESAPI.encoder().encodeForHTMLAttribute(tag.getHttpequiv()));
                sb.append("\" ");
            }
            if (tag.getContent() != null) {
                sb.append("content=\"");
                sb.append(ESAPI.encoder().encodeForHTMLAttribute(tag.getContent()));
                sb.append("\" ");
            }
            sb.append("/>\n");
        }
        return sb.toString();
    }

    private String findPageNameInURI(String uri) {
        String[] extensions;
        if (!uri.endsWith(this.findRiscExtension())) {
            throw new Error("Could not interpret URI: " + uri);
        }
        uri = uri.substring(0, uri.length() - this.findRiscExtension().length());
        int uriLastSlashIndex = uri.lastIndexOf(47);
        uri = uri.substring(uriLastSlashIndex, uri.length());
        uri = uri.replace(".", "/");
        for (String extension : extensions = this.findPageExtensions()) {
            String page = uri + extension;
            boolean jspExists = WebResourceClassloaderReader.checkIfFileExists(page);
            if (!jspExists) continue;
            return page;
        }
        return uri + ".jsp";
    }

    private String buildIncludeList(String ccStyleName) {
        String src;
        String versionStamp = RISCStarter.buildVersionStamp();
        String cssVersionStamp = RISCStarter.buildStyleVersionStamp(ccStyleName);
        if (ccStyleName == null) {
            ccStyleName = "defaultrisc";
        }
        StringBuffer sb = new StringBuffer();
        Object jsSet = WebResourceClassloaderReader.getFilesInPathDirectory("eclntjsfserver/styles/" + ccStyleName + "/", ".js");
        ArrayList<String> jsList = new ArrayList<String>((Collection<String>)jsSet);
        Collections.sort(jsList);
        for (String js : jsList) {
            if (js.equals("riscstyle.js")) continue;
            src = ESAPI.encoder().encodeForHTMLAttribute("eclntjsfserver/styles/" + ccStyleName + "/" + js + cssVersionStamp);
            sb.append("\n<script type=\"text/javascript\" src=\"" + src + "\"></script>");
        }
        sb.append("\n");
        String includeList = WebResourceClassloaderReader.readUTF8FileIntoString("eclnt/risc/includelist.txt.dev", false);
        if (includeList == null || includeList.equals("")) {
            includeList = WebResourceClassloaderReader.readUTF8FileIntoString("eclnt/risc/includelist.txt", true);
        }
        includeList = includeList.replace("\"></script>", versionStamp + "\"></script>");
        sb.append(includeList);
        jsSet = WebResourceClassloaderReader.getFilesInPathDirectory("eclnt/risc/plugin/", ".js");
        jsList = new ArrayList<String>((Collection<String>)jsSet);
        Collections.sort(jsList);
        for (String js : jsList) {
            src = "eclnt/risc/plugin/" + js + versionStamp;
            src = ESAPI.encoder().encodeForHTMLAttribute(src);
            sb.append("\n<script type=\"text/javascript\" src=\"" + src + "\"></script>");
        }
        sb.append("\n");
        for (SystemXml.RISCClientScript rsc : SystemXml.getRISCClientScripts()) {
            sb.append("\n<script type=\"" + ESAPI.encoder().encodeForHTMLAttribute(rsc.getType()) + "\" src=\"" + ESAPI.encoder().encodeForHTMLAttribute(rsc.getSrc() + versionStamp) + "\"></script>");
        }
        List<ComponentRepository.TLDInfo> libraries = ComponentRepository.readCCControllibrariesFromClassLoader();
        for (ComponentRepository.TLDInfo library : libraries) {
            String jsFile = ComponentRepository.findJSResourcePathForControlLibary(library);
            if (jsFile == null) continue;
            sb.append("\n<script type=\"text/javascript\" src=\"" + ESAPI.encoder().encodeForHTMLAttribute(jsFile + versionStamp) + "\"></script>");
        }
        return sb.toString();
    }

    public static void resetBuffers(HttpServletRequest req) {
        String req_cclogtoconsole = ServletUtil.readRequestParameterFromDesignTimeRequest(req, "cclogtoconsole");
        String req_ccloglevel = ServletUtil.readRequestParameterFromDesignTimeRequest(req, "ccloglevel");
        String req_ccresetbuffers = ServletUtil.readRequestParameterFromDesignTimeRequest(req, "ccresetbuffers");
        if ("true".equals(req_ccresetbuffers)) {
            CCResetBuffers.resetBuffers();
        }
        try {
            if ("true".equals(req_cclogtoconsole)) {
                CLog.addConsoleHandler();
            } else if ("false".equals(req_cclogtoconsole)) {
                CLog.removeConsoleHandler();
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "", t);
        }
        try {
            if (req_ccloglevel != null) {
                CLog.updateLogLevel(Level.parse(req_ccloglevel));
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "", t);
        }
    }

    public static String buildVersionStamp() {
        String result = null;
        if (s_versionStamp != null && s_versionStamp.instance() != null && (result = s_versionStamp.instance().buildVersionStamp()) != null) {
            return result;
        }
        result = "?version=" + VersionXml.getVersion();
        return result;
    }

    public static String buildStyleVersionStamp(String style) {
        String result = null;
        if (s_versionStamp != null && s_versionStamp.instance() != null && (result = s_versionStamp.instance().buildStyleVersionStamp()) != null) {
            return result;
        }
        result = RISCStarter.buildVersionStamp();
        if (style.startsWith("default")) {
            return result;
        }
        if (style.startsWith("cc")) {
            return result;
        }
        result = result + "_" + System.currentTimeMillis();
        return result;
    }

    protected String findePageFolderPrefix() {
        return "faces/";
    }

    protected String[] findPageExtensions() {
        return new String[]{".jsp", ".xml"};
    }

    protected String findRiscExtension() {
        return ".risc";
    }

    protected String unescapeSlashes(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("&#x2f;", "/");
    }

    protected void manageHeaderParametersIframeEmbedding(HttpServletRequest request, String page, HttpServletResponse response) {
        try {
            if (this.checkIfInEditorPreviewMode(request)) {
                return;
            }
            if (ServletUtil.checkIfRISCUrlStartedInDevelopmentMode(request)) {
                return;
            }
            if (!page.startsWith("/")) {
                page = "/" + page;
            }
            String s = SystemXml.getRiscStarter().getEmbedableasiframe();
            if ("true".equals(s = ValueManager.toLowerCaseId(s))) {
                return;
            }
            boolean explicitlyAllowed = this.checkIfPageIsExplicitlyAllowedToBeEmbedded(page);
            if (explicitlyAllowed) {
                return;
            }
            if ("false".equals(s) || "deny".equals(s)) {
                ServletUtil.setResponseHeader(response, "X-Frame-Options", "deny");
            } else {
                ServletUtil.setResponseHeader(response, "X-Frame-Options", "sameorigin");
            }
        }
        catch (SecurityException exc) {
            CLog.L.log(CLog.LL_ERR, "Problem when managing X-Frame-Options", exc);
            throw new Error(exc);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when managing X-Frame-Options", t);
        }
    }

    private boolean checkIfPageIsExplicitlyAllowedToBeEmbedded(String page) {
        List<SystemXml.PageInfo> aies = SystemXml.getAllowIFrameEmbeddings();
        for (SystemXml.PageInfo aie : aies) {
            if (aie.getPage() == null) continue;
            String aiePage = aie.getPage();
            if (!aiePage.startsWith("/")) {
                aiePage = "/" + aiePage;
            }
            if (!ValueManager.checkIfStringMatchesAsteriskExpression(page, aiePage, false)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkIfInEditorPreviewMode(HttpServletRequest request) throws SecurityException {
        String preview = request.getParameter("cc_preview");
        if ("true".equals(preview)) {
            String s = request.getRequestURL().toString();
            if (s.contains("zz_cceditoraround.risc")) {
                return true;
            }
            CLog.L.log(CLog.LL_ERR, "Query parameter cc_preview is set to true. But: the page is not called in the context of the layout editor environment!");
            throw new SecurityException("Security alert: preview mode is set, but call is not coming from editing environment!");
        }
        return false;
    }

    public class SecurityException
    extends Exception {
        public SecurityException(String message) {
            super(message);
        }
    }
}

