/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.streamstore.personalization;

import java.util.HashMap;
import java.util.Map;
import org.eclnt.jsfserver.streamstore.personalization.PersonalizedValue;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.IPropertyTypeResolver;
import org.eclnt.jsfserver.util.ISessionAbstraction;

public class PersonalizedValueReader
extends HashMap<String, String>
implements IPropertyTypeResolver {
    Map<String, PersonalizedValue> m_personalizedValues = new HashMap<String, PersonalizedValue>();

    public PersonalizedValueReader() {
        ISessionAbstraction dialogSession = HttpSessionAccess.getCurrentDialogSession();
        dialogSession.setAttribute(PersonalizedValueReader.class.getName(), this);
    }

    public static PersonalizedValueReader instance() {
        ISessionAbstraction dialogSession = HttpSessionAccess.getCurrentDialogSession();
        PersonalizedValueReader result = (PersonalizedValueReader)dialogSession.getAttribute(PersonalizedValueReader.class.getName());
        if (result == null) {
            result = new PersonalizedValueReader();
        }
        return result;
    }

    @Override
    public String get(Object keyObj) {
        PersonalizedValue pv = this.getPersonalizedValue(keyObj.toString());
        return pv.getValue();
    }

    @Override
    public String put(String key, String value) {
        PersonalizedValue pv = this.getPersonalizedValue(key);
        pv.setValue(value);
        return value;
    }

    @Override
    public Class resolveType(String propertyName) {
        return String.class;
    }

    private PersonalizedValue getPersonalizedValue(String key) {
        PersonalizedValue pv;
        String defaultValue = null;
        int openBracketBegin = key.indexOf(40);
        if (openBracketBegin >= 0) {
            int openBracktEnd = key.indexOf(41, openBracketBegin + 1);
            if (openBracktEnd > openBracketBegin) {
                defaultValue = key.substring(openBracketBegin + 1, openBracktEnd);
            }
            key = key.substring(0, openBracketBegin);
        }
        if ((pv = this.m_personalizedValues.get(key)) == null) {
            pv = new PersonalizedValue("personalizedValueReader/" + key, defaultValue);
            this.m_personalizedValues.put("personalizedValueReader/" + key, pv);
        }
        return pv;
    }
}

