/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.tools;

import org.eclnt.ccee.simplexml.SimpleXML;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.util.file.FileManager;

public class PomXmlUtil {
    private static PomXmlUtil s_instance = new PomXmlUtil();

    public static PomXmlUtil instance() {
        return s_instance;
    }

    public static void initialize(PomXmlUtil instance) {
        s_instance = instance;
    }

    public void createPomXML4JarFile(String pomXmlFileName, String pomXml4JarFileName, String toGroupId, String toArtifactId) {
        System.out.println("createPomXML4JarFile...:");
        System.out.println("From: " + pomXmlFileName);
        System.out.println("To  : " + pomXml4JarFileName);
        String pomXml = FileManager.readUTF8File(pomXmlFileName, true);
        String pomXml4Jar = this.createPomXML4Jar(pomXml, toGroupId, toArtifactId);
        FileManager.ensureDirectoryForFileExists(pomXml4JarFileName);
        FileManager.writeUTF8File(pomXml4JarFileName, pomXml4Jar, true);
        System.out.println("Created/Updated file: " + pomXml4JarFileName);
    }

    public String createPomXML4Jar(String pomXml, String toGroupId, String toArtifactId) {
        SimpleXMLElement root = SimpleXML.parseXML(pomXml, true);
        this.updateSimpleXmlToBuildPomXml4Jar(root, toGroupId, toArtifactId);
        return SimpleXML.createXML(root);
    }

    public void updateCCVersionInPomXml(String pomXmlFileName, String ccVersion) {
        SimpleXMLElement xpev;
        System.out.println("updateCCVersionInPomXml...:");
        System.out.println("File   : " + pomXmlFileName);
        System.out.println("Version: " + ccVersion);
        String pomXml = FileManager.readUTF8File(pomXmlFileName, true);
        SimpleXMLElement root = SimpleXML.parseXML(pomXml);
        SimpleXMLElement xev = root.getSubElement("version");
        xev.setText(ccVersion);
        SimpleXMLElement xep = root.getSubElement("properties");
        if (xep != null && (xpev = xep.getSubElement("cc.version")) != null) {
            xpev.setText(ccVersion);
        }
        String updXml = SimpleXML.createXML(root);
        FileManager.writeUTF8File(pomXmlFileName, updXml, true);
    }

    private void updateSimpleXmlToBuildPomXml4Jar(SimpleXMLElement root, String toGroupId, String toArtifactId) {
        SimpleXMLElement sxe;
        if (toGroupId != null) {
            sxe = root.getSubElement("groupId");
            if (sxe == null) {
                throw new Error("XML element for groupId is missing");
            }
            sxe.setText(toGroupId);
        }
        if ((sxe = root.getSubElement("artifactId")) == null) {
            throw new Error("XML element for artifactId is missing");
        }
        if (toArtifactId != null) {
            sxe.setText(toArtifactId);
        } else {
            sxe.setText(sxe.getText() + "_lib");
        }
        sxe = root.getSubElement("name");
        if (sxe == null) {
            throw new Error("XML element for name is missing");
        }
        sxe.setText(sxe.getText() + " (library)");
        sxe = root.getSubElement("packaging");
        if (sxe == null) {
            throw new Error("XML element for packaging is missing");
        }
        sxe.setText("jar");
        root.removeAllSubElements("build");
    }
}

