/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.util.valuemgmt.ValueManager;

public class ListSorterOneAttribute<CLASS> {
    List<CLASS> m_list;
    String m_currentSortAttribute = null;
    boolean m_currentSortDirectionAscending = false;
    Map<String, IGetValue> m_getters = new HashMap<String, IGetValue>();

    public ListSorterOneAttribute(List<CLASS> list) {
        this.m_list = list;
    }

    public List<CLASS> getList() {
        return this.m_list;
    }

    public void addGetter(String attribute, IGetValue getter) {
        this.m_getters.put(attribute, getter);
    }

    public void sortBy(String attribute) throws SortException {
        if (this.m_currentSortAttribute != null && this.m_currentSortAttribute.equals(attribute)) {
            this.m_currentSortDirectionAscending = !this.m_currentSortDirectionAscending;
        } else {
            this.m_currentSortAttribute = attribute;
            this.m_currentSortDirectionAscending = true;
        }
        this.processSort();
    }

    public String getSortedBy() {
        return this.m_currentSortAttribute;
    }

    public boolean checkIfSortedBy(String attribute) {
        return ValueManager.checkIfStringsAreEqual(attribute, this.m_currentSortAttribute);
    }

    public boolean isCurrentSortDirectionAscending() {
        return this.m_currentSortDirectionAscending;
    }

    protected void processSort() throws SortException {
        IGetValue getter = this.m_getters.get(this.m_currentSortAttribute);
        if (getter == null) {
            throw new SortException("getter implementation for attribute does not exist: " + this.m_currentSortAttribute);
        }
        MyComparator c = new MyComparator(getter, this.m_currentSortDirectionAscending);
        Collections.sort(this.m_list, c);
    }

    public static interface IGetValue<CLASS> {
        public Comparable getValue(CLASS var1);
    }

    public static class SortException
    extends Exception {
        public SortException(String message) {
            super(message);
        }
    }

    static class MyComparator
    implements Comparator {
        IGetValue i_getter;
        boolean i_ascending;

        public MyComparator(IGetValue getter, boolean ascending) {
            this.i_getter = getter;
            this.i_ascending = ascending;
        }

        public int compare(Object o1, Object o2) {
            Comparable c1 = this.i_getter.getValue(o1);
            Comparable c2 = this.i_getter.getValue(o2);
            int result = c1 == null && c2 == null ? 0 : (c1 == null ? -1 : (c2 == null ? 1 : c1.compareTo(c2)));
            if (!this.i_ascending) {
                result *= -1;
            }
            return result;
        }
    }
}

