/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import jakarta.servlet.ServletContext;
import java.io.StringReader;
import java.lang.reflect.Method;
import javax.xml.parsers.SAXParser;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;
import org.eclnt.jsfserver.util.parse.SAXParserCreator;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.log.CLog;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class VersionXml {
    public static final String PATH_VERSIONXML_JAR = "org/eclnt/jsfserver/version.xml";
    static String s_version = "...undefined version...";
    static Boolean s_ownUIImplementation = null;
    static Boolean s_jakarta = null;

    public static void init(ServletContext servletContext) {
        String xml = WebResourceClassloaderReader.readUTF8FileIntoString("/eclntjsfserver/version.xml", false);
        s_version = VersionXml.getVersion(xml);
    }

    public static void overrideJakarta(boolean value) {
        s_jakarta = value;
    }

    public static String getVersion() {
        return s_version;
    }

    public static String getVersion(String xml) {
        if (xml == null || xml.length() == 0) {
            return "...undefined...";
        }
        try {
            SAXParser parser = SAXParserCreator.createSAXParser();
            InputSource is = new InputSource(new StringReader(xml));
            MyParser mp = new MyParser();
            parser.parse(is, (DefaultHandler)mp);
            return mp.i_version;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error when reading /eclntjsfserver/version.xml", t);
            return "...undefined...";
        }
    }

    public static boolean checkIfOwnUIImplementation() {
        if (s_ownUIImplementation != null) {
            return s_ownUIImplementation;
        }
        s_ownUIImplementation = false;
        try {
            Method m = FacesContext.class.getMethod("checkIfOwnUIImplementation", new Class[0]);
            s_ownUIImplementation = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return s_ownUIImplementation;
    }

    public static boolean checkIfJakarta() {
        if (s_jakarta == null) {
            s_jakarta = CCClassResolver.checkIfClassIsAvailable("org.eclnt.jsfserver.base.faces.event.ActionEvent");
        }
        return s_jakarta;
    }

    static class MyParser
    extends DefaultHandler {
        String i_version = "...undefined version...";

        MyParser() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("version")) {
                this.i_version = attributes.getValue("name");
            }
        }
    }
}

