/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.pageparsing;

import org.eclnt.jsfserver.elements.ICCComponentProperties;
import org.eclnt.jsfserver.util.pageparsing.PageSAXParserHandler;
import org.eclnt.jsfserver.util.pageparsing.ParsedNodeBase;
import org.eclnt.jsfserver.util.parse.SAXParserUtil;

public class PageParser
implements ICCComponentProperties {
    boolean m_excludeOutestRow = false;
    String m_currentPageInfo = null;
    String m_xml;

    public PageParser(String xml) {
        this(xml, false, null);
    }

    public PageParser(String xml, boolean excludeOutestRow, String pageInfo) {
        this.m_xml = xml;
        this.m_excludeOutestRow = excludeOutestRow;
        this.m_currentPageInfo = pageInfo;
        if (this.m_currentPageInfo == null) {
            this.m_currentPageInfo = "";
        }
    }

    public ParsedNodeBase parsePageLayout() {
        try {
            ParsedNodeBase rootNode = this.createRootNode();
            PageSAXParserHandler<ParsedNodeBase> includeParser = new PageSAXParserHandler<ParsedNodeBase>(rootNode, this.m_excludeOutestRow, this.m_currentPageInfo);
            SAXParserUtil.parse(this.m_xml, includeParser);
            return rootNode;
        }
        catch (Throwable t) {
            throw new Error("Problem parsing layout XML: " + this.m_currentPageInfo, t);
        }
    }

    protected ParsedNodeBase createRootNode() {
        return new ParsedNodeBase();
    }
}

