/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.useraccess;

import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.useraccess.ILanguageAccess;

public class DefaultLanguageAccess
implements ILanguageAccess {
    private static final Map<Thread, String> s_languagePerThread = new Hashtable<Thread, String>();
    private static final Map<Thread, String> s_countryPerThread = new Hashtable<Thread, String>();

    @Override
    public String getCurrentLanguage() {
        try {
            if (HttpSessionAccess.checkIfRunningInUIThread()) {
                return HttpSessionAccess.getCurrentLocale().getLanguage();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            String language = s_languagePerThread.get(Thread.currentThread());
            if (language != null) {
                return language;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Locale.getDefault().getLanguage();
    }

    @Override
    public String getCurrentCountry() {
        try {
            if (HttpSessionAccess.checkIfRunningInUIThread()) {
                return HttpSessionAccess.getCurrentLocale().getCountry();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            String country = s_countryPerThread.get(Thread.currentThread());
            if (country != null) {
                return country;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Locale.getDefault().getCountry();
    }

    public static void associateLanguageWithCurrentThread(String language) {
        s_languagePerThread.put(Thread.currentThread(), language);
    }

    public static void clearLanguageWithCurrentThread() {
        s_languagePerThread.remove(Thread.currentThread());
    }
}

