/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.image;

import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.eclnt.util.image.ServerImageManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class SVGImageConverter {
    public static byte[] createPNGForSVG(String svg) {
        try {
            Dimension d = ServerImageManager.calculateDimensionOfSVGImage(svg);
            return SVGImageConverter.createPNGForSVG(svg, d.width, d.height);
        }
        catch (Throwable t) {
            throw new Error("Problem creating PNG from SVG: " + ValueManager.truncateString(svg, 100), t);
        }
    }

    public static byte[] createPNGForSVG(String svg, int height, int width) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(svg.getBytes("UTF-8"));
            ByteArrayOutputStream resultByteStream = new ByteArrayOutputStream();
            TranscoderInput transcoderInput = new TranscoderInput((InputStream)stream);
            TranscoderOutput transcoderOutput = new TranscoderOutput((OutputStream)resultByteStream);
            PNGTranscoder pngTranscoder = new PNGTranscoder();
            pngTranscoder.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, (Object)Float.valueOf(height));
            pngTranscoder.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, (Object)Float.valueOf(width));
            pngTranscoder.transcode(transcoderInput, transcoderOutput);
            resultByteStream.flush();
            return resultByteStream.toByteArray();
        }
        catch (Throwable t) {
            throw new Error("Problem creating PNG from SVG: " + ValueManager.truncateString(svg, 100) + ", " + height + ", " + width, t);
        }
    }
}

