/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace.eximport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.JAXBManager;
import org.eclnt.workplace.IWorkpage;
import org.eclnt.workplace.IWorkpageContainer;
import org.eclnt.workplace.WorkpageContainer;
import org.eclnt.workplace.WorkplaceTileInfo;
import org.eclnt.workplace.eximport.WorkplaceExport;
import org.eclnt.workplace.eximport.WorkplaceExportContainerInfo;

public class WorkplaceExporter {
    public String exportCurrentWorkplaceToXML(WorkpageContainer wpc) {
        WorkplaceExport exp = this.exportCurrentWorkplace(wpc);
        String xml = JAXBManager.marshal(exp);
        return xml;
    }

    public WorkplaceExport exportCurrentWorkplace(WorkpageContainer wpc) {
        WorkplaceTileInfo ti = wpc.getTileManager().exportWorkplaceTileInfo();
        List<WorkplaceExportContainerInfo> xcis = this.exportContainerInfos(wpc);
        WorkplaceExport exp = new WorkplaceExport();
        exp.setTileInfo(ti);
        exp.setContainerInfos(xcis);
        return exp;
    }

    public void importWorkplaceFromXML(WorkpageContainer wpc, String xml) {
        WorkplaceExport wpe = (WorkplaceExport)JAXBManager.unmarshal(xml, WorkplaceExport.class);
        this.importWorkplace(wpc, wpe);
    }

    public void importWorkplace(WorkpageContainer wpc, WorkplaceExport wpe) {
        wpc.updateUniqueId();
        if (wpe.getTileInfo() != null) {
            wpc.getTileManager().importWorkplaceTileInfo(wpe.getTileInfo());
        }
        this.importContainerInfos(wpc, wpe.getContainerInfos());
    }

    private void importContainerInfos(WorkpageContainer wpc, List<WorkplaceExportContainerInfo> xcis) {
        for (WorkplaceExportContainerInfo xci : xcis) {
            this.importContainerInfo(wpc, xci);
        }
    }

    private void importContainerInfo(WorkpageContainer wpc, WorkplaceExportContainerInfo xci) {
        try {
            IWorkpageContainer thisIWpc = null;
            thisIWpc = xci.getContainerId() == null ? wpc : wpc.getSubContainers().get(xci.getContainerId());
            WorkpageContainer thisWpc = thisIWpc;
            IWorkpage wp = thisWpc.getAllWorkpages().get(xci.getIndexOfTopPage());
            if (wp != null) {
                wpc.switchToWorkpage(wp);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem when importing CointainerInfo: " + xci.getContainerId() + ", " + xci.getIndexOfTopPage());
        }
    }

    private List<WorkplaceExportContainerInfo> exportContainerInfos(WorkpageContainer wpc) {
        ArrayList<WorkplaceExportContainerInfo> result = new ArrayList<WorkplaceExportContainerInfo>();
        result.add(this.exportContainerInfo(wpc));
        Collection<? extends IWorkpageContainer> subContainers = wpc.getSubContainers().values();
        for (IWorkpageContainer iWorkpageContainer : subContainers) {
            WorkpageContainer subWpc = (WorkpageContainer)iWorkpageContainer;
            result.add(this.exportContainerInfo(subWpc));
        }
        return result;
    }

    private WorkplaceExportContainerInfo exportContainerInfo(WorkpageContainer wpc) {
        WorkplaceExportContainerInfo xi = new WorkplaceExportContainerInfo();
        xi.setContainerId(wpc.getOwnSubContainerId());
        xi.setIndexOfTopPage(wpc.getIndexOfCurrentlySelectedWorkpage());
        return xi;
    }
}

