/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.zzzzz.test;

import java.util.Arrays;
import java.util.List;
import org.eclnt.jsfserver.util.el.ExpressionVariableFinderCL;
import org.junit.Assert;
import org.junit.Test;

public class TestVariableFinderCL {
    @Test
    public void testBasicVariables() {
        String expr = "#{d.xx.xx == null ||d.yy.yy!=d.jj} Hallo";
        List<String> result = ExpressionVariableFinderCL.findVariables(expr);
        List<String> expected = Arrays.asList("d.xx.xx", "d.yy.yy", "d.jj");
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testVariablesOutsideExpression() {
        String expr = "#{aaa.aaa && bbb.bbb} is ccc.ccc";
        List<String> result = ExpressionVariableFinderCL.findVariables(expr);
        List<String> expected = Arrays.asList("aaa.aaa", "bbb.bbb");
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testMultipleExpressionBlocks() {
        String expr = "#{x.y} and #{z.w} but not a.b";
        List<String> result = ExpressionVariableFinderCL.findVariables(expr);
        List<String> expected = Arrays.asList("x.y", "z.w");
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testQuotedStringsIgnored() {
        String expr = "#{a.b + \"ignored.var\" + c.d}";
        List<String> result = ExpressionVariableFinderCL.findVariables(expr);
        List<String> expected = Arrays.asList("a.b", "c.d");
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testSingleQuotedStringsIgnored() {
        String expr = "#{x.y + 'also.ignored' + z.w}";
        List<String> result = ExpressionVariableFinderCL.findVariables(expr);
        List<String> expected = Arrays.asList("x.y", "z.w");
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testBracketNotationWithIndex() {
        String expr = "#{list[0].value + array[i].name}";
        List<String> result = ExpressionVariableFinderCL.findVariables(expr);
        List<String> expected = Arrays.asList("list[0].value", "array[i].name");
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testBracketNotationWithQuotedKey() {
        String expr = "#{aaa.bbb[\"1.2.3\"]}";
        List<String> result = ExpressionVariableFinderCL.findVariables(expr);
        List<String> expected = Arrays.asList("aaa.bbb[\"1.2.3\"]");
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testBracketNotationWithSingleQuotedKey() {
        String expr = "#{obj.prop['key.with.dots'].value}";
        List<String> result = ExpressionVariableFinderCL.findVariables(expr);
        List<String> expected = Arrays.asList("obj.prop['key.with.dots'].value");
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testComplexExpression() {
        String expr = "#{d.userName && (d.xxx[0] || !d.yyy.yyy == 34)}";
        List<String> result = ExpressionVariableFinderCL.findVariables(expr);
        List<String> expected = Arrays.asList("d.userName", "d.xxx[0]", "d.yyy.yyy");
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testLongVariableNames() {
        String expr = "#{d.DemoExpressionsAny.boolTrue && d.DemoExpressionsAny.boolFalse} hat heute Hunger.Und morgen?";
        List<String> result = ExpressionVariableFinderCL.findVariables(expr);
        List<String> expected = Arrays.asList("d.DemoExpressionsAny.boolTrue", "d.DemoExpressionsAny.boolFalse");
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testNoExpressionBlock() {
        String expr = "simple.var without expression block";
        List<String> result = ExpressionVariableFinderCL.findVariables(expr);
        List<String> expected = Arrays.asList(new String[0]);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testEmptyExpression() {
        String expr = "#{}";
        List<String> result = ExpressionVariableFinderCL.findVariables(expr);
        List<String> expected = Arrays.asList(new String[0]);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testNoVariablesInExpression() {
        String expr = "#{no variables here}";
        List<String> result = ExpressionVariableFinderCL.findVariables(expr);
        List<String> expected = Arrays.asList(new String[0]);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testQuotedStringOutsideExpression() {
        String expr = "Hallo \"sss.sss\" Welt";
        List<String> result = ExpressionVariableFinderCL.findVariables(expr);
        List<String> expected = Arrays.asList(new String[0]);
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testMixedQuotesAndBrackets() {
        String expr = "#{array[0].field + \"text.with.dots\"}";
        List<String> result = ExpressionVariableFinderCL.findVariables(expr);
        List<String> expected = Arrays.asList("array[0].field");
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testBracketOnlyVariable() {
        String expr = "#{ccstylevalue[2]}";
        List<String> result = ExpressionVariableFinderCL.findVariables(expr);
        List<String> expected = Arrays.asList("ccstylevalue[2]");
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testMultipleBracketOnlyVariables() {
        String expr = "#{arr[0] + data[1] + obj.prop[2]}";
        List<String> result = ExpressionVariableFinderCL.findVariables(expr);
        List<String> expected = Arrays.asList("arr[0]", "data[1]", "obj.prop[2]");
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testBracketWithQuotedKey() {
        String expr = "#{ccstylevalue['123']}";
        List<String> result = ExpressionVariableFinderCL.findVariables(expr);
        List<String> expected = Arrays.asList("ccstylevalue['123']");
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testBracketWithQuotedKeyInComparison() {
        String expr = "#{ccstylevalue['123'] == true}";
        List<String> result = ExpressionVariableFinderCL.findVariables(expr);
        List<String> expected = Arrays.asList("ccstylevalue['123']");
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testBracketWithQuotedKeyFollowedByNumber() {
        String expr = "#{ccstylevalue['123']}80";
        List<String> result = ExpressionVariableFinderCL.findVariables(expr);
        List<String> expected = Arrays.asList("ccstylevalue['123']");
        Assert.assertEquals(expected, result);
    }

    @Test
    public void testXxxx() {
        String expr = "size:#{ccstylevalue['@fontBigSize@']}";
        List<String> result = ExpressionVariableFinderCL.findVariables(expr);
        System.out.println(result);
        System.out.println("Finished!");
    }
}

