/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.zzzzz.test;

import java.io.File;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.SAXParser;
import org.eclnt.jsfserver.util.parse.SAXParserCreator;
import org.eclnt.util.file.FileManager;
import org.junit.Test;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestXMLCorrect {
    @Test
    public void test() {
        try {
            this.testDir("C:/bmu_jtc/git/eclnt_jsfserver/");
            this.testDir("C:/bmu_jtc/git/eclnt_projects/");
            this.testDir("C:/bmu_jtc/git/eclnt_ccee/");
            this.testDir("C:/bmu_jtc/git/eclnt_demos/");
            System.out.println("ALL XML FILES ARE CORRECT!");
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error(t);
        }
    }

    private void testDir(String dirName) throws Exception {
        if (dirName.endsWith("webcontentcc")) {
            return;
        }
        if (dirName.endsWith("temp")) {
            return;
        }
        if (dirName.endsWith("ztemp")) {
            return;
        }
        if (dirName.endsWith("temp_bin")) {
            return;
        }
        List<File> files = FileManager.getFilesOfDirectory(dirName);
        for (File file : files) {
            String fileName = file.getName();
            if (!fileName.endsWith(".xml") && !fileName.endsWith(".xml_template") && !fileName.endsWith(".xml.template") && !fileName.endsWith(".tld")) continue;
            this.testFile(file);
        }
        List<File> dirs = FileManager.getDirectoriesOfDirectory(dirName);
        for (File dir : dirs) {
            this.testDir(dir.getAbsolutePath());
        }
    }

    private void testFile(File file) throws Exception {
        System.out.println("Testing: " + file.getAbsolutePath());
        String xml = FileManager.readUTF8File(file.getAbsolutePath(), false);
        if (xml == null || xml.length() == 0) {
            return;
        }
        this.testXML(xml);
    }

    private void testXML(String xml) throws Exception {
        SAXParser parser = SAXParserCreator.createSAXParser();
        InputSource is = new InputSource(new StringReader(xml));
        parser.parse(is, (DefaultHandler)new MyParser());
    }

    static class MyParser
    extends DefaultHandler {
        MyParser() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        }
    }
}

