/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.zzzzz.test;

import java.io.File;
import java.util.List;
import org.eclnt.util.file.FileManager;

public class ZPackageJSModules {
    static String s_fromDir = "C:\\temp\\web\\gchartdirect\\node_modules";
    static String s_toDir = "C:\\temp\\web\\gchartdirect\\modules";
    static String[] s_patterns = new String[]{" from '", "*from'", "'from'", " from \"", "*from\"", "'from\"", "import '", "import \""};

    public static void main(String[] args) {
        ZPackageJSModules.processDirectory("/", 0);
    }

    private static void processDirectory(String relPath, int level) {
        System.out.println("Processing: " + relPath);
        FileManager.ensureDirectoryExists(s_toDir + relPath);
        List<File> files = FileManager.getFilesOfDirectory(s_fromDir + relPath);
        for (File file : files) {
            if (file.getName().endsWith(".ts") || file.getName().endsWith(".ts.map") || file.getName().endsWith(".js.map")) continue;
            byte[] content = FileManager.readFile(file.getAbsolutePath(), true);
            FileManager.writeFile(s_toDir + relPath + file.getName(), content, true);
            if (!file.getName().endsWith(".js")) continue;
            ZPackageJSModules.repackageFile(s_toDir + relPath + file.getName(), level);
        }
        List<File> dirs = FileManager.getDirectoriesOfDirectory(s_fromDir + relPath);
        for (File dir : dirs) {
            String childRelPath = relPath + dir.getName() + "/";
            ZPackageJSModules.processDirectory(childRelPath, level + 1);
        }
    }

    private static void repackageFile(String fileAbsPath, int level) {
        System.out.println("Processing: " + fileAbsPath);
        String content = FileManager.readUTF8File(fileAbsPath, true);
        int currentIndex = 0;
        boolean changed = false;
        String packagePrefix = "";
        for (int i = 0; i < level; ++i) {
            packagePrefix = packagePrefix + "../";
        }
        for (String pattern : s_patterns) {
            int nextIndex;
            while ((nextIndex = content.indexOf(pattern, currentIndex)) >= 0) {
                char behind = content.charAt(nextIndex + pattern.length());
                if (behind != '/' && behind != '.') {
                    changed = true;
                    content = content.substring(0, nextIndex + pattern.length()) + packagePrefix + content.substring(nextIndex + pattern.length());
                }
                currentIndex = nextIndex + 1;
            }
        }
        if (changed) {
            FileManager.writeUTF8File(fileAbsPath, content, true);
        }
    }
}

